/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;

public class MBMessagePermission {
    public static void check(PermissionChecker permissionChecker, long messageId, String actionId) throws PortalException, SystemException {
        if (!MBMessagePermission.contains(permissionChecker, messageId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, MBMessage message, String actionId) throws PortalException, SystemException {
        if (!MBMessagePermission.contains(permissionChecker, message, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long messageId, String actionId) throws PortalException, SystemException {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)messageId);
        return MBMessagePermission.contains(permissionChecker, message, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, MBMessage message, String actionId) throws PortalException, SystemException {
        Boolean hasPermission;
        long groupId = message.getGroupId();
        if (message.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)message.getGroupId(), (String)message.getWorkflowClassName(), (long)message.getMessageId(), (String)actionId)) != null) {
            return hasPermission;
        }
        if (MBBanLocalServiceUtil.hasBan((long)groupId, (long)permissionChecker.getUserId())) {
            return false;
        }
        long categoryId = message.getCategoryId();
        if (categoryId != 0L && categoryId != -1L) {
            MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE && !MBCategoryPermission.contains(permissionChecker, category, "VIEW")) {
                return false;
            }
        }
        if (permissionChecker.hasOwnerPermission(message.getCompanyId(), MBMessage.class.getName(), message.getRootMessageId(), message.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(groupId, MBMessage.class.getName(), message.getMessageId(), actionId);
    }
}

