/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.impl.MBMessageImpl;
import com.liferay.portlet.messageboards.service.persistence.MBMessageFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBMessageFinderImpl
extends BasePersistenceImpl<MBMessage>
implements MBMessageFinder {
    public static final String COUNT_BY_C_T = String.valueOf(MBMessageFinder.class.getName()) + ".countByC_T";
    public static final String COUNT_BY_G_U_C_S = String.valueOf(MBMessageFinder.class.getName()) + ".countByG_U_C_S";
    public static final String COUNT_BY_G_U_MD_C_S = String.valueOf(MBMessageFinder.class.getName()) + ".countByG_U_MD_C_S";
    public static final String COUNT_BY_G_U_C_A_S = String.valueOf(MBMessageFinder.class.getName()) + ".countByG_U_C_A_S";
    public static final String FIND_BY_NO_ASSETS = String.valueOf(MBMessageFinder.class.getName()) + ".findByNoAssets";
    public static final String FIND_BY_G_U_C_S = String.valueOf(MBMessageFinder.class.getName()) + ".findByG_U_C_S";
    public static final String FIND_BY_G_U_MD_C_S = String.valueOf(MBMessageFinder.class.getName()) + ".findByG_U_MD_C_S";
    public static final String FIND_BY_G_U_C_A_S = String.valueOf(MBMessageFinder.class.getName()) + ".findByG_U_C_A_S";
    private static final String _USER_ID_SQL = "AND (currentMessage.userId = ?)";

    public int countByC_T(Date createDate, long threadId) throws SystemException {
        Timestamp createDate_TS = CalendarUtil.getTimestamp((Date)createDate);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_C_T);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(createDate_TS);
            qPos.add(threadId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_U_C_S(long groupId, long userId, long[] categoryIds, int status) throws SystemException {
        return this.doCountByG_U_C_S(groupId, userId, categoryIds, status, false);
    }

    public int countByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status) throws SystemException {
        return this.doCountByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, false);
    }

    public int filterCountByG_U_C_S(long groupId, long userId, long[] categoryIds, int status) throws SystemException {
        return this.doCountByG_U_C_S(groupId, userId, categoryIds, status, true);
    }

    public int filterCountByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status) throws SystemException {
        return this.doCountByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status, true);
    }

    public int filterCountByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status) throws SystemException {
        return this.doCountByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, true);
    }

    public List<Long> filterFindByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, int start, int end) throws SystemException {
        return this.doFindByG_U_C_S(groupId, userId, categoryIds, status, start, end, true);
    }

    public List<Long> filterFindByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status, int start, int end) throws SystemException {
        return this.doFindByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status, start, end, true);
    }

    public List<Long> filterFindByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, int start, int end) throws SystemException {
        return this.doFindByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, start, end, true);
    }

    public List<MBMessage> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("MBMessage", MBMessageImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, int start, int end) throws SystemException {
        return this.doFindByG_U_C_S(groupId, userId, categoryIds, status, start, end, false);
    }

    public List<Long> findByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, int start, int end) throws SystemException {
        return this.doFindByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, start, end, false);
    }

    protected int doCountByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_U_C_S);
            if (userId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)_USER_ID_SQL, (String)"");
            }
            sql = categoryIds == null || categoryIds.length == 0 ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = CustomSQLUtil.appendCriteria((String)sql, (String)"AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            if (status != -1) {
                qPos.add(status);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_U_MD_C_S);
            if (userId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)_USER_ID_SQL, (String)"");
            }
            sql = categoryIds == null || categoryIds.length == 0 ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = CustomSQLUtil.appendCriteria((String)sql, (String)"AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            qPos.add(modifiedDate);
            if (status != -1) {
                qPos.add(status);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_U_C_A_S);
            sql = categoryIds == null || categoryIds.length == 0 ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = CustomSQLUtil.appendCriteria((String)sql, (String)"AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(userId);
            qPos.add(anonymous);
            if (status != -1) {
                qPos.add(status);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Long> doFindByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, int start, int end, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_U_C_S);
            if (userId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)_USER_ID_SQL, (String)"");
            }
            sql = categoryIds == null || categoryIds.length == 0 ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = CustomSQLUtil.appendCriteria((String)sql, (String)"AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("threadId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            if (status != -1) {
                qPos.add(status);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Long> doFindByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status, int start, int end, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_U_MD_C_S);
            if (userId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)_USER_ID_SQL, (String)"");
            }
            sql = categoryIds == null || categoryIds.length == 0 ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = CustomSQLUtil.appendCriteria((String)sql, (String)"AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("threadId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            qPos.add(modifiedDate);
            if (status != -1) {
                qPos.add(status);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Long> doFindByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, int start, int end, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_U_C_A_S);
            sql = categoryIds == null || categoryIds.length == 0 ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = CustomSQLUtil.appendCriteria((String)sql, (String)"AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("threadId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(userId);
            qPos.add(anonymous);
            if (status != -1) {
                qPos.add(status);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }
}

