/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.social;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;

public class MBActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{MBMessage.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!MBMessagePermission.contains(permissionChecker, activity.getClassPK(), "VIEW")) {
            return null;
        }
        String groupName = "";
        if (activity.getGroupId() != themeDisplay.getScopeGroupId()) {
            groupName = this.getGroupName(activity.getGroupId(), themeDisplay);
        }
        String creatorUserName = this.getUserName(activity.getUserId(), themeDisplay);
        String receiverUserName = this.getUserName(activity.getReceiverUserId(), themeDisplay);
        int activityType = activity.getType();
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)activity.getClassPK());
        StringBundler sb = new StringBundler(4);
        sb.append(themeDisplay.getPortalURL());
        sb.append(themeDisplay.getPathMain());
        sb.append("/message_boards/find_message?messageId=");
        sb.append(message.getMessageId());
        String link = sb.toString();
        String titlePattern = null;
        if (activityType == 1) {
            titlePattern = activity.getReceiverUserId() == 0L ? "activity-message-boards-add-message" : "activity-message-boards-reply-message";
        } else if (activityType == 2 && activity.getReceiverUserId() > 0L) {
            titlePattern = "activity-message-boards-reply-message";
        }
        if (Validator.isNotNull((String)groupName)) {
            titlePattern = String.valueOf(titlePattern) + "-in";
        }
        String messageSubject = this.getValue(activity.getExtraData(), "title", message.getSubject());
        Object[] titleArguments = new Object[]{groupName, creatorUserName, receiverUserName, this.wrapLink(link, messageSubject)};
        String title = themeDisplay.translate(titlePattern, titleArguments);
        String body = "";
        if (message.getCategoryId() > 0L) {
            sb.setIndex(0);
            sb.append(themeDisplay.getPortalURL());
            sb.append(themeDisplay.getPathMain());
            sb.append("/message_boards/find_category?mbCategoryId=");
            sb.append(message.getCategoryId());
            String categoryLink = sb.toString();
            body = this.wrapLink(categoryLink, "go-to-category", themeDisplay);
        }
        return new SocialActivityFeedEntry(link, title, body);
    }
}

