/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.messageboards.NoSuchDiscussionException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBCategoryServiceUtil;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class MBIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{MBMessage.class.getName()};
    public static final String PORTLET_ID = "19";
    private static final boolean _FILTER_SEARCH = true;
    private static final boolean _PERMISSION_AWARE = true;
    private static Log _log = LogFactoryUtil.getLog(MBIndexer.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long entryClassPK, String actionId) throws Exception {
        return MBMessagePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isFilterSearch() {
        return true;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] categoryIds;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)-1);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
        boolean discussion = GetterUtil.getBoolean((Object)searchContext.getAttribute("discussion"), (boolean)false);
        contextQuery.addRequiredTerm("discussion", discussion);
        long threadId = GetterUtil.getLong((String)((String)((Object)searchContext.getAttribute("threadId"))));
        if (threadId > 0L) {
            contextQuery.addRequiredTerm("threadId", threadId);
        }
        if ((categoryIds = searchContext.getCategoryIds()) != null && categoryIds.length > 0) {
            if (categoryIds[0] == 0L) {
                return;
            }
            BooleanQuery categoriesQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            long[] lArray = categoryIds;
            int n = categoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    long categoryId = lArray[n2];
                    try {
                        MBCategoryServiceUtil.getCategory((long)categoryId);
                    }
                    catch (Exception exception) {
                        break block7;
                    }
                    categoriesQuery.addTerm("categoryId", categoryId);
                }
                ++n2;
            }
            contextQuery.add((Query)categoriesQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long companyId) {
        Property property = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(property.eq((Object)companyId));
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long groupId, long categoryId) {
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(groupIdProperty.eq((Object)groupId));
        Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
        dynamicQuery.add(categoryIdProperty.eq((Object)categoryId));
        Property statusProperty = PropertyFactoryUtil.forName((String)"status");
        dynamicQuery.add(statusProperty.eq((Object)0));
    }

    protected void doDelete(Object obj) throws Exception {
        block3: {
            SearchContext searchContext;
            block4: {
                block2: {
                    searchContext = new SearchContext();
                    searchContext.setSearchEngineId(this.getSearchEngineId());
                    if (!(obj instanceof MBCategory)) break block2;
                    MBCategory category = (MBCategory)obj;
                    BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
                    booleanQuery.addRequiredTerm("portletId", PORTLET_ID);
                    booleanQuery.addRequiredTerm("categoryId", category.getCategoryId());
                    Hits hits = SearchEngineUtil.search((String)this.getSearchEngineId(), (long)category.getCompanyId(), (Query)booleanQuery, (int)-1, (int)-1);
                    int i2 = 0;
                    while (i2 < hits.getLength()) {
                        Document document = hits.doc(i2);
                        SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)category.getCompanyId(), (String)document.get("uid"));
                        ++i2;
                    }
                    break block3;
                }
                if (!(obj instanceof MBMessage)) break block4;
                MBMessage message = (MBMessage)obj;
                DocumentImpl document = new DocumentImpl();
                document.addUID(PORTLET_ID, message.getMessageId());
                SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)message.getCompanyId(), (String)document.get("uid"));
                break block3;
            }
            if (!(obj instanceof MBThread)) break block3;
            MBThread thread = (MBThread)obj;
            MBMessage message = MBMessageLocalServiceUtil.getMessage((long)thread.getRootMessageId());
            BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            booleanQuery.addRequiredTerm("portletId", PORTLET_ID);
            booleanQuery.addRequiredTerm("threadId", thread.getThreadId());
            Hits hits = SearchEngineUtil.search((String)this.getSearchEngineId(), (long)message.getCompanyId(), (Query)booleanQuery, (int)-1, (int)-1);
            int i3 = 0;
            while (i3 < hits.getLength()) {
                Document document = hits.doc(i3);
                SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)message.getCompanyId(), (String)document.get("uid"));
                ++i3;
            }
        }
    }

    protected Document doGetDocument(Object obj) throws Exception {
        MBMessage message = (MBMessage)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)message);
        document.addKeyword("categoryId", message.getCategoryId());
        document.addText("content", this.processContent(message));
        document.addKeyword("rootEntryClassPK", message.getRootMessageId());
        document.addText("title", message.getSubject());
        if (message.isAnonymous()) {
            document.remove("userName");
        }
        try {
            MBDiscussionLocalServiceUtil.getThreadDiscussion((long)message.getThreadId());
            document.addKeyword("discussion", true);
        }
        catch (NoSuchDiscussionException noSuchDiscussionException) {
            document.addKeyword("discussion", false);
        }
        document.addKeyword("threadId", message.getThreadId());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String messageId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/message_boards/view_message");
        portletURL.setParameter("messageId", messageId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        MBMessage message = (MBMessage)obj;
        if (message.isDiscussion() || message.getStatus() != 0) {
            return;
        }
        Document document = this.getDocument(message);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)message.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)classPK);
        this.doReindex(message);
        if (message.isRoot()) {
            List messages = MBMessageLocalServiceUtil.getThreadMessages((long)message.getThreadId(), (int)0);
            for (MBMessage curMessage : messages) {
                this.reindex(curMessage);
            }
        } else {
            this.reindex(message);
        }
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
        this.reindexRoot(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected String processContent(MBMessage message) {
        String content = message.getBody();
        try {
            content = BBCodeTranslatorUtil.getHTML((String)content);
        }
        catch (Exception e2) {
            _log.error((Object)("Could not parse message " + message.getMessageId() + ": " + e2.getMessage()));
        }
        content = HtmlUtil.extractText((String)content);
        return content;
    }

    protected void reindexCategories(long companyId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(MBCategory.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minCategoryIdProjection = ProjectionFactoryUtil.min((String)"categoryId");
        Projection maxCategoryIdProjection = ProjectionFactoryUtil.max((String)"categoryId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minCategoryIdProjection);
        projectionList.add(maxCategoryIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, companyId);
        List results = MBCategoryLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxCategoryIds = (Object[])results.get(0);
        if (minAndMaxCategoryIds[0] == null || minAndMaxCategoryIds[1] == null) {
            return;
        }
        long minCategoryId = (Long)minAndMaxCategoryIds[0];
        long maxCategoryId = (Long)minAndMaxCategoryIds[1];
        long startCategoryId = minCategoryId;
        long endCategoryId = startCategoryId + 10000L;
        while (startCategoryId <= maxCategoryId) {
            this.reindexCategories(companyId, startCategoryId, endCategoryId);
            startCategoryId = endCategoryId;
            endCategoryId += 10000L;
        }
    }

    protected void reindexCategories(long companyId, long startCategoryId, long endCategoryId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(MBCategory.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"categoryId");
        dynamicQuery.add(property.ge((Object)startCategoryId));
        dynamicQuery.add(property.lt((Object)endCategoryId));
        this.addReindexCriteria(dynamicQuery, companyId);
        List categories = MBCategoryLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (MBCategory category : categories) {
            long groupId = category.getGroupId();
            long categoryId = category.getCategoryId();
            this.reindexMessages(companyId, groupId, categoryId);
        }
    }

    protected void reindexMessages(long companyId, long groupId, long categoryId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(MBMessage.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minMessageIdProjection = ProjectionFactoryUtil.min((String)"messageId");
        Projection maxMessageIdProjection = ProjectionFactoryUtil.max((String)"messageId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minMessageIdProjection);
        projectionList.add(maxMessageIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, groupId, categoryId);
        List results = MBMessageLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxMessageIds = (Object[])results.get(0);
        if (minAndMaxMessageIds[0] == null || minAndMaxMessageIds[1] == null) {
            return;
        }
        long minMessageId = (Long)minAndMaxMessageIds[0];
        long maxMessageId = (Long)minAndMaxMessageIds[1];
        long startMessageId = minMessageId;
        long endMessageId = startMessageId + 10000L;
        while (startMessageId <= maxMessageId) {
            this.reindexMessages(companyId, groupId, categoryId, startMessageId, endMessageId);
            startMessageId = endMessageId;
            endMessageId += 10000L;
        }
    }

    protected void reindexMessages(long companyId, long groupId, long categoryId, long startMessageId, long endMessageId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(MBMessage.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"messageId");
        dynamicQuery.add(property.ge((Object)startMessageId));
        dynamicQuery.add(property.lt((Object)endMessageId));
        this.addReindexCriteria(dynamicQuery, groupId, categoryId);
        List messages = MBMessageLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        if (messages.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>(messages.size());
        for (MBMessage message : messages) {
            Document document = this.getDocument(message);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }

    protected void reindexRoot(long companyId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Group.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minGroupIdProjection = ProjectionFactoryUtil.min((String)"groupId");
        Projection maxGroupIdProjection = ProjectionFactoryUtil.max((String)"groupId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minGroupIdProjection);
        projectionList.add(maxGroupIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, companyId);
        List results = GroupLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxGroupIds = (Object[])results.get(0);
        if (minAndMaxGroupIds[0] == null || minAndMaxGroupIds[1] == null) {
            return;
        }
        long minGroupId = (Long)minAndMaxGroupIds[0];
        long maxGroupId = (Long)minAndMaxGroupIds[1];
        long startGroupId = minGroupId;
        long endGroupId = startGroupId + 10000L;
        while (startGroupId <= maxGroupId) {
            this.reindexRoot(companyId, startGroupId, endGroupId);
            startGroupId = endGroupId;
            endGroupId += 10000L;
        }
    }

    protected void reindexRoot(long companyId, long startGroupId, long endGroupId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Group.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(property.ge((Object)startGroupId));
        dynamicQuery.add(property.lt((Object)endGroupId));
        this.addReindexCriteria(dynamicQuery, companyId);
        List groups = GroupLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (Group group : groups) {
            long groupId = group.getGroupId();
            long categoryId = 0L;
            this.reindexMessages(companyId, groupId, categoryId);
        }
    }
}

