/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.action;

import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.mobile.device.rulegroup.RuleGroupProcessorUtil;
import com.liferay.portal.kernel.mobile.device.rulegroup.rule.RuleHandler;
import com.liferay.portal.kernel.mobile.device.rulegroup.rule.UnknownRuleHandlerException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.mobile.device.rulegroup.rule.impl.SimpleRuleHandler;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.mobiledevicerules.NoSuchActionException;
import com.liferay.portlet.mobiledevicerules.NoSuchRuleGroupException;
import com.liferay.portlet.mobiledevicerules.model.MDRRule;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleServiceUtil;
import java.util.Collection;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditRuleAction
extends PortletAction {
    private static final String _SIMPLE_RULE_EDIT_RJSP = "/html/portlet/mobile_device_rules/rule/simple_rule.jsp";

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateRule(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteRule(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.mobile_device_rules.error");
            }
            if (e2 instanceof NoSuchActionException || e2 instanceof NoSuchRuleGroupException || e2 instanceof UnknownRuleHandlerException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        long ruleId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"ruleId");
        MDRRule rule = MDRRuleServiceUtil.fetchRule((long)ruleId);
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE", (Object)rule);
        String type = BeanPropertiesUtil.getString((Object)rule, (String)"type");
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_TYPE", (Object)type);
        String editorJSP = this.getEditorJSP(type);
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_EDITOR_JSP", (Object)editorJSP);
        long ruleGroupId = BeanParamUtil.getLong((Object)rule, (PortletRequest)renderRequest, (String)"ruleGroupId");
        MDRRuleGroup ruleGroup = MDRRuleGroupServiceUtil.getRuleGroup((long)ruleGroupId);
        renderRequest.setAttribute("MOBILE_DEVICE_RULES_RULE_GROUP", (Object)ruleGroup);
        return mapping.findForward("portlet.mobile_device_rules.edit_rule");
    }

    @Override
    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        long ruleId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"ruleId");
        if (ruleId > 0L) {
            MDRRule rule = MDRRuleServiceUtil.fetchRule((long)ruleId);
            resourceRequest.setAttribute("MOBILE_DEVICE_RULES_RULE", (Object)rule);
        }
        String type = ParamUtil.getString((PortletRequest)resourceRequest, (String)"type");
        this.includeEditorJSP(portletConfig, resourceRequest, resourceResponse, type);
    }

    protected void deleteRule(ActionRequest request) throws Exception {
        long ruleId = ParamUtil.getLong((PortletRequest)request, (String)"ruleId");
        MDRRuleServiceUtil.deleteRule((long)ruleId);
    }

    protected String getEditorJSP(String ruleType) {
        if (ruleType.equals(SimpleRuleHandler.getHandlerType())) {
            return _SIMPLE_RULE_EDIT_RJSP;
        }
        return "";
    }

    protected UnicodeProperties getTypeSettingsProperties(ActionRequest actionRequest, Collection<String> propertyNames) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        for (String propertyName : propertyNames) {
            Object[] values = ParamUtil.getParameterValues((PortletRequest)actionRequest, (String)propertyName);
            String merged = StringUtil.merge((Object[])values);
            typeSettingsProperties.setProperty(propertyName, merged);
        }
        return typeSettingsProperties;
    }

    protected void includeEditorJSP(PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse, String type) throws Exception {
        String editorJSP = this.getEditorJSP(type);
        if (Validator.isNull((String)editorJSP)) {
            return;
        }
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher(editorJSP);
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void updateRule(ActionRequest actionRequest) throws Exception {
        long ruleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleId");
        long ruleGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ruleGroupId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        RuleHandler ruleHandler = RuleGroupProcessorUtil.getRuleHandler((String)type);
        if (ruleHandler == null) {
            throw new UnknownRuleHandlerException(type);
        }
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties(actionRequest, ruleHandler.getPropertyNames());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (ruleId <= 0L) {
            MDRRuleServiceUtil.addRule((long)ruleGroupId, (Map)nameMap, (Map)descriptionMap, (String)type, (UnicodeProperties)typeSettingsProperties, (ServiceContext)serviceContext);
        } else {
            MDRRuleServiceUtil.updateRule((long)ruleId, (Map)nameMap, (Map)descriptionMap, (String)type, (UnicodeProperties)typeSettingsProperties, (ServiceContext)serviceContext);
        }
    }
}

