/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.mobile.device.rulegroup.action.impl.SiteRedirectActionHandler;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.mobiledevicerules.model.MDRAction;
import com.liferay.portlet.mobiledevicerules.model.MDRRule;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroup;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.MDRActionLocalServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupInstanceLocalServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleGroupLocalServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.MDRRuleLocalServiceUtil;
import com.liferay.portlet.mobiledevicerules.service.persistence.MDRActionUtil;
import com.liferay.portlet.mobiledevicerules.service.persistence.MDRRuleGroupInstanceUtil;
import com.liferay.portlet.mobiledevicerules.service.persistence.MDRRuleGroupUtil;
import com.liferay.portlet.mobiledevicerules.service.persistence.MDRRuleUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class MDRPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final boolean _ALWAYS_STAGED = true;
    private static final String _NAMESPACE = "mobile_device_rules";
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = true;
    private static Log _log = LogFactoryUtil.getLog(MDRPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _ruleGroupInstances = new PortletDataHandlerBoolean("mobile_device_rules", "rule-group-instances", true, true);
    private static PortletDataHandlerBoolean _ruleGroups = new PortletDataHandlerBoolean("mobile_device_rules", "rule-groups", true, true);

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_ruleGroups, _ruleGroupInstances};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isAlwaysStaged() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(MDRPortletDataHandlerImpl.class, "deleteData")) {
            MDRRuleGroupInstanceLocalServiceUtil.deleteGroupRuleGroupInstances((long)portletDataContext.getScopeGroupId());
            MDRRuleGroupLocalServiceUtil.deleteRuleGroups((long)portletDataContext.getGroupId());
        }
        return null;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.mobiledevicerules", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("mobiledevicerules-data");
        Element ruleGroupsElement = rootElement.addElement("rule-groups");
        List ruleGroups = MDRRuleGroupUtil.findByGroupId((long)portletDataContext.getGroupId());
        for (MDRRuleGroup ruleGroup : ruleGroups) {
            this.exportRuleGroup(portletDataContext, ruleGroupsElement, ruleGroup);
        }
        Element ruleGroupInstancesElement = rootElement.addElement("rule-group-instances");
        List ruleGroupInstances = MDRRuleGroupInstanceUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (MDRRuleGroupInstance ruleGroupInstance : ruleGroupInstances) {
            this.exportRuleGroupInstance(portletDataContext, ruleGroupInstancesElement, ruleGroupInstance);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.mobiledevicerules", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element ruleGroupsElement = rootElement.element("rule-groups");
        List ruleGroupElements = ruleGroupsElement.elements("rule-group");
        for (Element ruleGroupElement : ruleGroupElements) {
            String path = ruleGroupElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            MDRRuleGroup ruleGroup = (MDRRuleGroup)portletDataContext.getZipEntryAsObject(path);
            this.importRuleGroup(portletDataContext, ruleGroupElement, ruleGroup);
        }
        Element ruleGroupInstancesElement = rootElement.element("rule-group-instances");
        List ruleGroupInstanceElements = ruleGroupInstancesElement.elements("rule-group-instance");
        for (Element ruleGroupInstanceElement : ruleGroupInstanceElements) {
            String path = ruleGroupInstanceElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            MDRRuleGroupInstance ruleGroupInstance = (MDRRuleGroupInstance)portletDataContext.getZipEntryAsObject(path);
            this.importRuleGroupInstance(portletDataContext, ruleGroupInstanceElement, ruleGroupInstance);
        }
        return null;
    }

    protected void exportAction(PortletDataContext portletDataContext, Element actionsElement, MDRAction action) throws Exception {
        Element actionElement;
        String path;
        block4: {
            path = this.getActionPath(portletDataContext, action);
            if (!portletDataContext.isPathNotProcessed(path)) {
                return;
            }
            actionElement = actionsElement.addElement("action");
            String type = action.getType();
            if (type.equals(SiteRedirectActionHandler.class.getName())) {
                UnicodeProperties typeSettingsProperties = action.getTypeSettingsProperties();
                long targetPlid = GetterUtil.getLong((String)typeSettingsProperties.getProperty("plid"));
                try {
                    Layout targetLayout = LayoutLocalServiceUtil.getLayout((long)targetPlid);
                    actionElement.addAttribute("layout-uuid", targetLayout.getUuid());
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)("Unable to set the layout uuid of the target " + targetPlid + ". Site redirect may not match after import."), (Throwable)e2);
                }
            }
        }
        portletDataContext.addClassedModel(actionElement, path, (ClassedModel)action, _NAMESPACE);
    }

    protected void exportRule(PortletDataContext portletDataContext, Element rulesElement, MDRRule rule) throws Exception {
        String path = this.getRulePath(portletDataContext, rule);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element ruleElement = rulesElement.addElement("rule");
        portletDataContext.addClassedModel(ruleElement, path, (ClassedModel)rule, _NAMESPACE);
    }

    protected void exportRuleGroup(PortletDataContext portletDataContext, Element ruleGroupsElement, MDRRuleGroup ruleGroup) throws Exception {
        if (!portletDataContext.isWithinDateRange(ruleGroup.getModifiedDate())) {
            return;
        }
        String path = this.getRuleGroupPath(portletDataContext, ruleGroup);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element ruleGroupElement = ruleGroupsElement.addElement("rule-group");
        portletDataContext.addClassedModel(ruleGroupElement, path, (ClassedModel)ruleGroup, _NAMESPACE);
        Element mdrRulesElement = ruleGroupElement.addElement("rules");
        List rules = ruleGroup.getRules();
        for (MDRRule rule : rules) {
            this.exportRule(portletDataContext, mdrRulesElement, rule);
        }
    }

    protected void exportRuleGroupInstance(PortletDataContext portletDataContext, Element ruleGroupInstancesElement, MDRRuleGroupInstance ruleGroupInstance) throws Exception {
        if (!portletDataContext.isWithinDateRange(ruleGroupInstance.getModifiedDate())) {
            return;
        }
        String path = this.getRuleGroupInstancePath(portletDataContext, ruleGroupInstance);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element ruleGroupInstanceElement = ruleGroupInstancesElement.addElement("rule-group-instance");
        MDRRuleGroup ruleGroup = ruleGroupInstance.getRuleGroup();
        String className = ruleGroupInstance.getClassName();
        if (className.equals(Layout.class.getName())) {
            Layout layout = LayoutLocalServiceUtil.getLayout((long)ruleGroupInstance.getClassPK());
            ruleGroupInstanceElement.addAttribute("layout-uuid", layout.getUuid());
        }
        String ruleGroupUuid = ruleGroup.getUuid();
        ruleGroupInstanceElement.addAttribute("rule-group-uuid", ruleGroupUuid);
        portletDataContext.addClassedModel(ruleGroupInstanceElement, path, (ClassedModel)ruleGroupInstance, _NAMESPACE);
        Element actionsElement = ruleGroupInstanceElement.addElement("actions");
        List actions = ruleGroupInstance.getActions();
        for (MDRAction action : actions) {
            this.exportAction(portletDataContext, actionsElement, action);
        }
    }

    protected String getActionPath(PortletDataContext portletDataContext, MDRAction action) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("178"));
        sb.append("/actions/");
        sb.append(action.getActionId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getRuleGroupInstancePath(PortletDataContext portletDataContext, MDRRuleGroupInstance ruleGroupInstance) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("178"));
        sb.append("/rule-group-instances/");
        sb.append(ruleGroupInstance.getRuleGroupInstanceId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getRuleGroupPath(PortletDataContext portletDataContext, MDRRuleGroup ruleGroup) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("178"));
        sb.append("/rule-groups/");
        sb.append(ruleGroup.getRuleGroupId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getRulePath(PortletDataContext portletDataContext, MDRRule rule) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("178"));
        sb.append("/rules/");
        sb.append(rule.getRuleId());
        sb.append(".xml");
        return sb.toString();
    }

    protected void importAction(PortletDataContext portletDataContext, Element actionElement, MDRRuleGroupInstance ruleGroupInstance, MDRAction action) throws Exception {
        long userId = portletDataContext.getUserId(action.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext(actionElement, (ClassedModel)action, _NAMESPACE);
        serviceContext.setUserId(userId);
        this.validateTargetLayoutPlid(actionElement, action);
        MDRAction importedAction = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRAction existingAction = MDRActionUtil.fetchByUUID_G((String)action.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingAction == null) {
                serviceContext.setUuid(action.getUuid());
                importedAction = MDRActionLocalServiceUtil.addAction((long)ruleGroupInstance.getRuleGroupInstanceId(), (Map)action.getNameMap(), (Map)action.getDescriptionMap(), (String)action.getType(), (UnicodeProperties)action.getTypeSettingsProperties(), (ServiceContext)serviceContext);
            } else {
                importedAction = MDRActionLocalServiceUtil.updateAction((long)existingAction.getActionId(), (Map)action.getNameMap(), (Map)action.getDescriptionMap(), (String)action.getType(), (UnicodeProperties)action.getTypeSettingsProperties(), (ServiceContext)serviceContext);
            }
        } else {
            importedAction = MDRActionLocalServiceUtil.addAction((long)ruleGroupInstance.getRuleGroupInstanceId(), (Map)action.getNameMap(), (Map)action.getDescriptionMap(), (String)action.getType(), (UnicodeProperties)action.getTypeSettingsProperties(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)action, (ClassedModel)importedAction, _NAMESPACE);
    }

    protected void importRule(PortletDataContext portletDataContext, Element ruleElement, MDRRuleGroup ruleGroup, MDRRule rule) throws Exception {
        long userId = portletDataContext.getUserId(rule.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext(ruleElement, (ClassedModel)rule, _NAMESPACE);
        serviceContext.setUserId(userId);
        MDRRule importedRule = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRRule existingRule = MDRRuleUtil.fetchByUUID_G((String)rule.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingRule == null) {
                serviceContext.setUuid(rule.getUuid());
                importedRule = MDRRuleLocalServiceUtil.addRule((long)ruleGroup.getRuleGroupId(), (Map)rule.getNameMap(), (Map)rule.getDescriptionMap(), (String)rule.getType(), (UnicodeProperties)rule.getTypeSettingsProperties(), (ServiceContext)serviceContext);
            } else {
                importedRule = MDRRuleLocalServiceUtil.updateRule((long)existingRule.getRuleId(), (Map)rule.getNameMap(), (Map)rule.getDescriptionMap(), (String)rule.getType(), (UnicodeProperties)rule.getTypeSettingsProperties(), (ServiceContext)serviceContext);
            }
        } else {
            importedRule = MDRRuleLocalServiceUtil.addRule((long)ruleGroup.getRuleGroupId(), (Map)rule.getNameMap(), (Map)rule.getDescriptionMap(), (String)rule.getType(), (UnicodeProperties)rule.getTypeSettingsProperties(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)rule, (ClassedModel)importedRule, _NAMESPACE);
    }

    protected void importRuleGroup(PortletDataContext portletDataContext, Element ruleGroupElement, MDRRuleGroup ruleGroup) throws Exception {
        long userId = portletDataContext.getUserId(ruleGroup.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext(ruleGroupElement, (ClassedModel)ruleGroup, _NAMESPACE);
        serviceContext.setUserId(userId);
        MDRRuleGroup importedRuleGroup = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRRuleGroup existingRuleGroup = MDRRuleGroupUtil.fetchByUUID_G((String)ruleGroup.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingRuleGroup == null) {
                serviceContext.setUuid(ruleGroup.getUuid());
                importedRuleGroup = MDRRuleGroupLocalServiceUtil.addRuleGroup((long)portletDataContext.getScopeGroupId(), (Map)ruleGroup.getNameMap(), (Map)ruleGroup.getDescriptionMap(), (ServiceContext)serviceContext);
            } else {
                importedRuleGroup = MDRRuleGroupLocalServiceUtil.updateRuleGroup((long)existingRuleGroup.getRuleGroupId(), (Map)ruleGroup.getNameMap(), (Map)ruleGroup.getDescriptionMap(), (ServiceContext)serviceContext);
            }
        } else {
            importedRuleGroup = MDRRuleGroupLocalServiceUtil.addRuleGroup((long)portletDataContext.getScopeGroupId(), (Map)ruleGroup.getNameMap(), (Map)ruleGroup.getDescriptionMap(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)ruleGroup, (ClassedModel)importedRuleGroup, _NAMESPACE);
        Element rulesElement = ruleGroupElement.element("rules");
        List ruleElements = rulesElement.elements("rule");
        for (Element ruleElement : ruleElements) {
            String path = ruleElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            MDRRule rule = (MDRRule)portletDataContext.getZipEntryAsObject(path);
            this.importRule(portletDataContext, ruleElement, importedRuleGroup, rule);
        }
    }

    protected void importRuleGroupInstance(PortletDataContext portletDataContext, Element ruleGroupInstanceElement, MDRRuleGroupInstance ruleGroupInstance) throws Exception {
        long userId = portletDataContext.getUserId(ruleGroupInstance.getUserUuid());
        Map ruleGroupIds = portletDataContext.getNewPrimaryKeysMap(MDRRuleGroup.class);
        Long ruleGroupId = (Long)ruleGroupIds.get(ruleGroupInstance.getRuleGroupId());
        if (ruleGroupId == null) {
            try {
                String ruleGroupUuid = ruleGroupInstanceElement.attributeValue("rule-group-uuid");
                MDRRuleGroup ruleGroup = MDRRuleGroupUtil.fetchByUUID_G((String)ruleGroupUuid, (long)portletDataContext.getScopeGroupId());
                ruleGroupId = ruleGroup.getRuleGroupId();
            }
            catch (Exception e2) {
                if (_log.isErrorEnabled()) {
                    _log.warn((Object)("Unable to import rule group instance " + ruleGroupInstance), (Throwable)e2);
                }
                return;
            }
        }
        long classPK = 0L;
        String layoutUuid = ruleGroupInstanceElement.attributeValue("layout-uuid");
        try {
            if (Validator.isNotNull((String)layoutUuid)) {
                Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)layoutUuid, (long)portletDataContext.getScopeGroupId());
                classPK = layout.getPrimaryKey();
            } else {
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)portletDataContext.getScopeGroupId(), (boolean)portletDataContext.isPrivateLayout());
                classPK = layoutSet.getLayoutSetId();
            }
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(5);
                sb.append("Layout ");
                sb.append(layoutUuid);
                sb.append(" is missing for rule group instance ");
                sb.append(ruleGroupInstance.getRuleGroupInstanceId());
                sb.append(", skipping this rule group instance.");
                _log.warn((Object)sb.toString());
            }
            return;
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext(ruleGroupInstanceElement, (ClassedModel)ruleGroupInstance, _NAMESPACE);
        serviceContext.setUserId(userId);
        MDRRuleGroupInstance importedRuleGroupInstance = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MDRRuleGroupInstance existingMDRRuleGroupInstance = MDRRuleGroupInstanceUtil.fetchByUUID_G((String)ruleGroupInstance.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingMDRRuleGroupInstance == null) {
                serviceContext.setUuid(ruleGroupInstance.getUuid());
                importedRuleGroupInstance = MDRRuleGroupInstanceLocalServiceUtil.addRuleGroupInstance((long)portletDataContext.getScopeGroupId(), (String)ruleGroupInstance.getClassName(), (long)classPK, (long)ruleGroupId, (int)ruleGroupInstance.getPriority(), (ServiceContext)serviceContext);
            } else {
                importedRuleGroupInstance = MDRRuleGroupInstanceLocalServiceUtil.updateRuleGroupInstance((long)existingMDRRuleGroupInstance.getRuleGroupInstanceId(), (int)ruleGroupInstance.getPriority());
            }
        } else {
            importedRuleGroupInstance = MDRRuleGroupInstanceLocalServiceUtil.addRuleGroupInstance((long)portletDataContext.getScopeGroupId(), (String)ruleGroupInstance.getClassName(), (long)classPK, (long)ruleGroupId, (int)ruleGroupInstance.getPriority(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)ruleGroupInstance, (ClassedModel)importedRuleGroupInstance, _NAMESPACE);
        Element actionsElement = ruleGroupInstanceElement.element("actions");
        List actionElements = actionsElement.elements("action");
        for (Element actionElement : actionElements) {
            String path = actionElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            MDRAction action = (MDRAction)portletDataContext.getZipEntryAsObject(path);
            this.importAction(portletDataContext, actionElement, importedRuleGroupInstance, action);
        }
    }

    protected void validateTargetLayoutPlid(Element actionElement, MDRAction action) {
        block4: {
            String type = action.getType();
            if (!type.equals(SiteRedirectActionHandler.class.getName())) {
                return;
            }
            String targetLayoutUuid = actionElement.attributeValue("layout-uuid");
            if (Validator.isNull((String)targetLayoutUuid)) {
                return;
            }
            UnicodeProperties typeSettingsProperties = action.getTypeSettingsProperties();
            long targetGroupId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("groupId"));
            try {
                Layout targetLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)targetLayoutUuid, (long)targetGroupId);
                typeSettingsProperties.setProperty("plid", String.valueOf(targetLayout.getPlid()));
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to find target layout with uuid " + targetLayoutUuid + " in group " + targetGroupId + ". Site redirect may not match target layout."), (Throwable)e2);
            }
        }
    }
}

