/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.myplaces.action;

import com.liferay.portal.NoSuchLayoutSetException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String redirect;
        String privateLayoutParam;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        List<Layout> layouts = this.getLayouts(groupId, privateLayoutParam = actionRequest.getParameter("privateLayout"));
        if (layouts.isEmpty()) {
            SessionErrors.add((PortletRequest)actionRequest, (String)NoSuchLayoutSetException.class.getName(), (Object)((Object)new NoSuchLayoutSetException("{groupId=" + groupId + ",privateLayout=" + privateLayoutParam + "}")));
        }
        if (Validator.isNull((String)(redirect = this.getRedirect(themeDisplay, layouts, groupId, privateLayoutParam)))) {
            redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
        }
        if (Validator.isNotNull((String)redirect)) {
            actionResponse.sendRedirect(redirect);
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return mapping.findForward("portlet.my_sites.view");
    }

    @Override
    public ActionForward strutsExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String redirect;
        String privateLayoutParam;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        List<Layout> layouts = this.getLayouts(groupId, privateLayoutParam = request.getParameter("privateLayout"));
        if (layouts.isEmpty()) {
            SessionErrors.add((HttpServletRequest)request, (String)NoSuchLayoutSetException.class.getName(), (Object)((Object)new NoSuchLayoutSetException("{groupId=" + groupId + ",privateLayout=" + privateLayoutParam + "}")));
        }
        if (Validator.isNull((String)(redirect = this.getRedirect(themeDisplay, layouts, groupId, privateLayoutParam)))) {
            redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
        }
        response.sendRedirect(redirect);
        return null;
    }

    protected List<Layout> getLayouts(long groupId, boolean privateLayout) throws Exception {
        return LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)0L);
    }

    protected List<Layout> getLayouts(long groupId, String privateLayoutParam) throws Exception {
        List<Layout> layouts = null;
        boolean privateLayout = false;
        if (Validator.isNull((String)privateLayoutParam)) {
            layouts = this.getLayouts(groupId, false);
            if (layouts.isEmpty()) {
                layouts = this.getLayouts(groupId, true);
            }
        } else {
            privateLayout = GetterUtil.getBoolean((String)privateLayoutParam);
            layouts = this.getLayouts(groupId, privateLayout);
        }
        return layouts;
    }

    protected String getRedirect(ThemeDisplay themeDisplay, List<Layout> layouts, long groupId, String privateLayoutParam) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        for (Layout layout : layouts) {
            if (layout.isHidden() || !LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW")) continue;
            return PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        return PortalUtil.getGroupFriendlyURL((Group)group, (boolean)GetterUtil.getBoolean((String)privateLayoutParam), (ThemeDisplay)themeDisplay);
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }
}

