/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.action;

import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.polls.util.PollsUtil;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;

public class ViewChartAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            long questionId = ParamUtil.getLong((HttpServletRequest)request, (String)"questionId");
            String chartType = ParamUtil.getString((HttpServletRequest)request, (String)"chartType", (String)"pie");
            CategoryDataset dataset = PollsUtil.getVotesDataset(questionId);
            String chartName = themeDisplay.translate("vote-results");
            String xName = themeDisplay.translate("choice");
            String yName = themeDisplay.translate("votes");
            JFreeChart chart = null;
            if (chartType.equals("area")) {
                chart = ChartFactory.createAreaChart((String)chartName, (String)xName, (String)yName, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            } else if (chartType.equals("horizontal_bar")) {
                chart = ChartFactory.createBarChart((String)chartName, (String)xName, (String)yName, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
            } else if (chartType.equals("line")) {
                chart = ChartFactory.createLineChart((String)chartName, (String)xName, (String)yName, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            } else if (chartType.equals("vertical_bar")) {
                chart = ChartFactory.createBarChart((String)chartName, (String)xName, (String)yName, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            } else {
                PieDataset pieData = DatasetUtilities.createPieDatasetForRow((CategoryDataset)dataset, (int)0);
                chart = ChartFactory.createPieChart((String)chartName, (PieDataset)pieData, (boolean)true, (boolean)false, (boolean)false);
            }
            response.setContentType("image/jpeg");
            ServletOutputStream os = response.getOutputStream();
            ChartUtilities.writeChartAsJPEG((OutputStream)os, (JFreeChart)chart, (int)400, (int)400);
            return null;
        }
        catch (Exception e2) {
            PortalUtil.sendError((Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }
}

