/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.polls.NoSuchQuestionException;
import com.liferay.portlet.polls.lar.PollsPortletDataHandlerImpl;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.model.PollsVote;
import com.liferay.portlet.polls.service.persistence.PollsQuestionUtil;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class PollsDisplayPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _DATA_LOCALIZED = true;
    private static final String _NAMESPACE = "polls";
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = true;
    private static Log _log = LogFactoryUtil.getLog(PollsDisplayPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _questions = new PortletDataHandlerBoolean("polls", "questions", true, true);
    private static PortletDataHandlerBoolean _votes = new PortletDataHandlerBoolean("polls", "votes");

    public String[] getDataPortletPreferences() {
        return new String[]{"questionId"};
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_questions, _votes};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_questions, _votes};
    }

    public boolean isDataLocalized() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletPreferences.setValue("questionId", "");
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        long questionId = GetterUtil.getLong((String)portletPreferences.getValue("questionId", ""));
        if (questionId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No question id found in preferences of portlet " + portletId));
            }
            return "";
        }
        PollsQuestion question = null;
        try {
            question = PollsQuestionUtil.findByPrimaryKey((long)questionId);
        }
        catch (NoSuchQuestionException nsqe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsqe, (Throwable)nsqe);
            }
            return "";
        }
        portletDataContext.addPermissions("com.liferay.portlet.polls", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("polls-display-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        Element questionsElement = rootElement.addElement("questions");
        Element choicesElement = rootElement.addElement("choices");
        Element votesElement = rootElement.addElement("votes");
        PollsPortletDataHandlerImpl.exportQuestion(portletDataContext, questionsElement, choicesElement, votesElement, question);
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        long questionId;
        portletDataContext.importPermissions("com.liferay.portlet.polls", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        if (Validator.isNull((String)data)) {
            return null;
        }
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element questionsElement = rootElement.element("questions");
        for (Element questionElement : questionsElement.elements("question")) {
            String path = questionElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            PollsQuestion question = (PollsQuestion)portletDataContext.getZipEntryAsObject(path);
            PollsPortletDataHandlerImpl.importQuestion(portletDataContext, questionElement, question);
        }
        Element choicesElement = rootElement.element("choices");
        for (Element choiceElement : choicesElement.elements("choice")) {
            String path = choiceElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            PollsChoice choice = (PollsChoice)portletDataContext.getZipEntryAsObject(path);
            PollsPortletDataHandlerImpl.importChoice(portletDataContext, choice);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "votes")) {
            Element votesElement = rootElement.element("votes");
            for (Element voteElement : votesElement.elements("vote")) {
                String path = voteElement.attributeValue("path");
                if (!portletDataContext.isPathNotProcessed(path)) continue;
                PollsVote vote = (PollsVote)portletDataContext.getZipEntryAsObject(path);
                PollsPortletDataHandlerImpl.importVote(portletDataContext, vote);
            }
        }
        if ((questionId = GetterUtil.getLong((String)portletPreferences.getValue("questionId", ""))) > 0L) {
            Map questionIds = portletDataContext.getNewPrimaryKeysMap(PollsQuestion.class);
            questionId = MapUtil.getLong((Map)questionIds, (long)questionId, (long)questionId);
            portletPreferences.setValue("questionId", String.valueOf(questionId));
        }
        return portletPreferences;
    }
}

