/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.polls.NoSuchVoteException;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.service.PollsChoiceLocalServiceUtil;
import com.liferay.portlet.polls.service.PollsVoteLocalServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class PollsUtil {
    public static CategoryDataset getVotesDataset(long questionId) throws SystemException {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        String seriesName = "";
        for (PollsChoice choice : PollsChoiceLocalServiceUtil.getChoices((long)questionId)) {
            Integer number = choice.getVotesCount();
            dataset.addValue((Number)number, (Comparable)((Object)seriesName), (Comparable)((Object)choice.getName()));
        }
        return dataset;
    }

    public static boolean hasVoted(HttpServletRequest request, long questionId) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        if (themeDisplay.isSignedIn()) {
            try {
                PollsVoteLocalServiceUtil.getVote((long)questionId, (long)themeDisplay.getUserId());
            }
            catch (NoSuchVoteException noSuchVoteException) {
                return false;
            }
            return true;
        }
        HttpSession session = request.getSession();
        Boolean hasVoted = (Boolean)session.getAttribute(String.valueOf(PollsQuestion.class.getName()) + "." + questionId);
        return hasVoted != null && hasVoted != false;
    }

    public static void saveVote(ActionRequest actionRequest, long questionId) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        PollsUtil.saveVote(request, questionId);
    }

    public static void saveVote(HttpServletRequest request, long questionId) {
        HttpSession session = request.getSession();
        session.setAttribute(String.valueOf(PollsQuestion.class.getName()) + "." + questionId, (Object)Boolean.TRUE);
    }

    public static void saveVote(RenderRequest renderRequest, long questionId) {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        PollsUtil.saveVote(request, questionId);
    }
}

