/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portalsettings.action;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.service.CompanyServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PrefsPropsUtil;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditLDAPServerAction
extends PortletAction {
    private static final String[] _KEYS = new String[]{"ldap.auth.search.filter", "ldap.base.dn", "ldap.base.provider.url", "ldap.contact.custom.mappings", "ldap.contact.mappings", "ldap.group.default.object.classes", "ldap.group.mappings", "ldap.groups.dn", "ldap.import.group.search.filter", "ldap.import.user.search.filter", "ldap.security.credentials", "ldap.security.principal", "ldap.server.name", "ldap.user.custom.mappings", "ldap.user.default.object.classes", "ldap.user.mappings", "ldap.users.dn"};

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateLDAPServer(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteLDAPServer(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.portal_settings.error");
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portal_settings.edit_ldap_server"));
    }

    protected UnicodeProperties addLDAPServer(long companyId, UnicodeProperties properties) throws Exception {
        String[] keys;
        String defaultPostfix = LDAPSettingsUtil.getPropertyPostfix(0L);
        Object[] defaultKeys = new String[_KEYS.length];
        int i2 = 0;
        while (i2 < _KEYS.length) {
            defaultKeys[i2] = String.valueOf(_KEYS[i2]) + defaultPostfix;
            ++i2;
        }
        long ldapServerId = CounterLocalServiceUtil.increment();
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        Set keysSet = properties.keySet();
        String[] stringArray = keys = keysSet.toArray(new String[keysSet.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (ArrayUtil.contains((Object[])defaultKeys, (Object)key)) {
                String value = properties.remove((Object)key);
                if (key.equals("ldap.security.credentials" + defaultPostfix) && value.equals("TEMP_OBFUSCATION_VALUE")) {
                    value = PrefsPropsUtil.getString("ldap.security.credentials");
                }
                properties.setProperty(key.replace(defaultPostfix, postfix), value);
            }
            ++n2;
        }
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(companyId);
        String ldapServerIds = preferences.getValue("ldap.server.ids", "");
        ldapServerIds = StringUtil.add((String)ldapServerIds, (String)String.valueOf(ldapServerId));
        properties.setProperty("ldap.server.ids", ldapServerIds);
        return properties;
    }

    protected void deleteLDAPServer(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long ldapServerId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ldapServerId");
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String[] keys = new String[_KEYS.length];
        int i2 = 0;
        while (i2 < _KEYS.length) {
            keys[i2] = String.valueOf(_KEYS[i2]) + postfix;
            ++i2;
        }
        CompanyServiceUtil.removePreferences((long)themeDisplay.getCompanyId(), (String[])keys);
        PortletPreferences preferences = PrefsPropsUtil.getPreferences(themeDisplay.getCompanyId());
        UnicodeProperties properties = new UnicodeProperties();
        String ldapServerIds = preferences.getValue("ldap.server.ids", "");
        ldapServerIds = StringUtil.remove((String)ldapServerIds, (String)String.valueOf(ldapServerId));
        properties.put("ldap.server.ids", ldapServerIds);
        CompanyServiceUtil.updatePreferences((long)themeDisplay.getCompanyId(), (UnicodeProperties)properties);
    }

    protected void updateLDAPServer(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long ldapServerId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ldapServerId");
        UnicodeProperties properties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"settings--");
        if (ldapServerId <= 0L) {
            properties = this.addLDAPServer(themeDisplay.getCompanyId(), properties);
        }
        CompanyServiceUtil.updatePreferences((long)themeDisplay.getCompanyId(), (UnicodeProperties)properties);
    }
}

