/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.NoSuchPortletItemException;
import com.liferay.portal.PortletItemNameException;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.PortletPreferencesServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditArchivedSetupsAction
extends EditConfigurationAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("save")) {
                this.updateSetup(actionRequest, portlet);
            } else if (cmd.equals("restore")) {
                this.restoreSetup(actionRequest, portlet);
            } else if (cmd.equals("delete")) {
                this.deleteSetup(actionRequest);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchPortletItemException || e2 instanceof PortletItemNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.sendRedirect(actionRequest, actionResponse);
            }
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
            }
            throw e2;
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".refreshPortlet"), (Object)portletResource);
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".updatedConfiguration"));
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_archived_setups"));
    }

    protected void deleteSetup(ActionRequest actionRequest) throws Exception {
        long portletItemId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"portletItemId");
        PortletPreferencesServiceUtil.deleteArchivedPreferences((long)portletItemId);
    }

    protected void restoreSetup(ActionRequest actionRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        PortletPreferences setup = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portlet.getPortletId());
        PortletPreferencesServiceUtil.restoreArchivedPreferences((long)themeDisplay.getScopeGroupId(), (String)name, (Layout)themeDisplay.getLayout(), (String)portlet.getRootPortletId(), (PortletPreferences)setup);
    }

    protected void updateSetup(ActionRequest actionRequest, Portlet portlet) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        PortletPreferences setup = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portlet.getPortletId());
        PortletPreferencesServiceUtil.updateArchivePreferences((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)name, (String)portlet.getRootPortletId(), (PortletPreferences)setup);
    }
}

