/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionPropagator;
import com.liferay.portal.service.PermissionServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionServiceUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditPermissionsAction
extends EditConfigurationAction {
    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("group_permissions")) {
                this.updateGroupPermissions(actionRequest);
            } else if (cmd.equals("guest_permissions")) {
                this.updateGuestPermissions(actionRequest);
            } else if (cmd.equals("organization_permissions")) {
                this.updateOrganizationPermissions(actionRequest);
            } else if (cmd.equals("role_permissions")) {
                this.updateRolePermissions(actionRequest);
            } else if (cmd.equals("user_group_permissions")) {
                this.updateUserGroupPermissions(actionRequest);
            } else if (cmd.equals("user_permissions")) {
                this.updateUserPermissions(actionRequest);
            }
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM < 5) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"permissionsRedirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                this.addSuccessMessage(actionRequest, actionResponse);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        String portletResource = ParamUtil.getString((PortletRequest)renderRequest, (String)"portletResource");
        String modelResource = ParamUtil.getString((PortletRequest)renderRequest, (String)"modelResource");
        String resourcePrimKey = ParamUtil.getString((PortletRequest)renderRequest, (String)"resourcePrimKey");
        String selResource = portletResource;
        if (Validator.isNotNull((String)modelResource)) {
            selResource = modelResource;
        }
        try {
            PermissionServiceUtil.checkPermission((long)groupId, (String)selResource, (String)resourcePrimKey);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)renderRequest, "portlet.portlet_configuration.error");
        }
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletResource);
        if (portlet != null) {
            renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_permissions"));
    }

    protected String[] getActionIds(ActionRequest actionRequest, long roleId, boolean includePreselected) {
        List<String> actionIds = this.getActionIdsList(actionRequest, roleId, includePreselected);
        return actionIds.toArray(new String[actionIds.size()]);
    }

    protected List<String> getActionIdsList(ActionRequest actionRequest, long roleId, boolean includePreselected) {
        ArrayList<String> actionIds = new ArrayList<String>();
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String actionId;
            int pos;
            String name = (String)enu.nextElement();
            if (name.startsWith(String.valueOf(roleId) + "_ACTION_")) {
                pos = name.indexOf("_ACTION_");
                actionId = name.substring(pos + 8);
                actionIds.add(actionId);
                continue;
            }
            if (!includePreselected || !name.startsWith(String.valueOf(roleId) + "_PRESELECTED_")) continue;
            pos = name.indexOf("_PRESELECTED_");
            actionId = name.substring(pos + 13);
            actionIds.add(actionId);
        }
        return actionIds;
    }

    protected void updateGroupPermissions(ActionRequest actionRequest) throws Exception {
        Resource resource;
        Layout layout = (Layout)actionRequest.getAttribute("LAYOUT");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"groupIdActionIds"));
        PermissionServiceUtil.setGroupPermissions((long)groupId, (String[])actionIds, (long)resourceId);
        if (!layout.isPrivateLayout() && (resource = ResourceLocalServiceUtil.getResource((long)resourceId)).getPrimKey().startsWith(String.valueOf(layout.getPlid()) + "_LAYOUT_")) {
            CacheUtil.clearCache(layout.getCompanyId());
        }
    }

    protected void updateGuestPermissions(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"guestActionIds"));
        PermissionServiceUtil.setUserPermissions((long)themeDisplay.getDefaultUserId(), (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
    }

    protected void updateOrganizationPermissions(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationIdsPosValue");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"organizationIdActionIds"));
        PermissionServiceUtil.setGroupPermissions((String)Organization.class.getName(), (String)String.valueOf(organizationId), (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
    }

    protected void updateRolePermissions(ActionRequest actionRequest) throws Exception {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            this.updateRolePermissions_5(actionRequest);
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.updateRolePermissions_6(actionRequest);
        } else {
            this.updateRolePermissions_1to4(actionRequest);
        }
    }

    protected void updateRolePermissions_1to4(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        long roleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"roleIdsPosValue");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"roleIdActionIds"));
        PermissionServiceUtil.setRolePermissions((long)roleId, (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
    }

    protected void updateRolePermissions_5(ActionRequest actionRequest) throws Exception {
        long[] roleIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        HashMap<Long, String[]> roleIdsToActionIds = new HashMap<Long, String[]>();
        long[] lArray = roleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"rolesSearchContainerPrimaryKeys"), (long)0L);
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long roleId = lArray[n2];
            String[] actionIds = this.getActionIds(actionRequest, roleId, false);
            roleIdsToActionIds.put(roleId, actionIds);
            ++n2;
        }
        PermissionServiceUtil.setIndividualPermissions((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getCompanyId(), roleIdsToActionIds, (long)resourceId);
    }

    protected void updateRolePermissions_6(ActionRequest actionRequest) throws Exception {
        Portlet portlet;
        PermissionPropagator permissionPropagator;
        long roleId;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        String modelResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"modelResource");
        long[] roleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"rolesSearchContainerPrimaryKeys"), (long)0L);
        String selResource = PortletConstants.getRootPortletId((String)portletResource);
        if (Validator.isNotNull((String)modelResource)) {
            selResource = modelResource;
        }
        long resourceGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceGroupId", (long)themeDisplay.getScopeGroupId());
        String resourcePrimKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"resourcePrimKey");
        HashMap<Long, String[]> roleIdsToActionIds = new HashMap<Long, String[]>();
        if (ResourceBlockLocalServiceUtil.isSupported((String)selResource)) {
            long[] lArray = roleIds;
            int n = roleIds.length;
            int n2 = 0;
            while (n2 < n) {
                roleId = lArray[n2];
                List<String> actionIds = this.getActionIdsList(actionRequest, roleId, true);
                roleIdsToActionIds.put(roleId, actionIds.toArray(new String[actionIds.size()]));
                ++n2;
            }
            ResourceBlockServiceUtil.setIndividualScopePermissions((long)themeDisplay.getCompanyId(), (long)resourceGroupId, (String)selResource, (long)GetterUtil.getLong((String)resourcePrimKey), roleIdsToActionIds);
        } else {
            long[] lArray = roleIds;
            int n = roleIds.length;
            int n3 = 0;
            while (n3 < n) {
                roleId = lArray[n3];
                String[] actionIds = this.getActionIds(actionRequest, roleId, false);
                roleIdsToActionIds.put(roleId, actionIds);
                ++n3;
            }
            ResourcePermissionServiceUtil.setIndividualResourcePermissions((long)resourceGroupId, (long)themeDisplay.getCompanyId(), (String)selResource, (String)resourcePrimKey, roleIdsToActionIds);
        }
        if (PropsValues.PERMISSIONS_PROPAGATION_ENABLED && (permissionPropagator = (portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletResource)).getPermissionPropagatorInstance()) != null) {
            permissionPropagator.propagateRolePermissions(actionRequest, modelResource, resourcePrimKey, roleIds);
        }
    }

    protected void updateUserGroupPermissions(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        long userGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userGroupIdsPosValue");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"userGroupIdActionIds"));
        PermissionServiceUtil.setGroupPermissions((String)UserGroup.class.getName(), (String)String.valueOf(userGroupId), (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
    }

    protected void updateUserPermissions(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long resourceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"resourceId");
        long userId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"userIdsPosValue");
        String[] actionIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"userIdActionIds"));
        PermissionServiceUtil.setUserPermissions((long)userId, (long)themeDisplay.getScopeGroupId(), (String[])actionIds, (long)resourceId);
    }
}

