/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.shopping.CategoryNameException;
import com.liferay.portlet.shopping.NoSuchCategoryException;
import com.liferay.portlet.shopping.action.ActionUtil;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.service.ShoppingCategoryServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditCategoryAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateCategory(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteCategory(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchCategoryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.shopping.error");
            }
            if (e2 instanceof CategoryNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getCategory((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchCategoryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.shopping.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.shopping.edit_category"));
    }

    protected void deleteCategory(ActionRequest actionRequest) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId");
        ShoppingCategoryServiceUtil.deleteCategory((long)categoryId);
    }

    protected void updateCategory(ActionRequest actionRequest) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId");
        long parentCategoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentCategoryId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        boolean mergeWithParentCategory = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeWithParentCategory");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)ShoppingCategory.class.getName(), (PortletRequest)actionRequest);
        if (categoryId <= 0L) {
            ShoppingCategoryServiceUtil.addCategory((long)parentCategoryId, (String)name, (String)description, (ServiceContext)serviceContext);
        } else {
            ShoppingCategoryServiceUtil.updateCategory((long)categoryId, (long)parentCategoryId, (String)name, (String)description, (boolean)mergeWithParentCategory, (ServiceContext)serviceContext);
        }
    }
}

