/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.model.impl;

import com.liferay.portal.kernel.util.HashCode;
import com.liferay.portal.kernel.util.HashCodeFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.shopping.model.ShoppingCartItem;
import com.liferay.portlet.shopping.model.ShoppingItem;

public class ShoppingCartItemImpl
implements ShoppingCartItem {
    private String _fields;
    private ShoppingItem _item;

    public static String[] getFieldsArray(String fields) {
        return StringUtil.split((String)fields, (char)'&');
    }

    public ShoppingCartItemImpl(ShoppingItem item, String fields) {
        this._item = item;
        this._fields = fields;
    }

    public int compareTo(ShoppingCartItem cartItem) {
        if (cartItem == null) {
            return -1;
        }
        int value = this.getItem().compareTo(cartItem.getItem());
        if (value == 0) {
            value = this.getFields().compareTo(cartItem.getFields());
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ShoppingCartItem cartItem = (ShoppingCartItem)obj;
        return this.getItem().equals(cartItem.getItem()) && this.getFields().equals(cartItem.getFields());
    }

    public String getCartItemId() {
        long itemId = this.getItem().getItemId();
        if (Validator.isNull((String)this._fields)) {
            return String.valueOf(itemId);
        }
        return String.valueOf(itemId) + "|" + this._fields;
    }

    public String getFields() {
        return this._fields;
    }

    public String[] getFieldsArray() {
        return ShoppingCartItemImpl.getFieldsArray(this._fields);
    }

    public ShoppingItem getItem() {
        return this._item;
    }

    public int hashCode() {
        HashCode hashCode = HashCodeFactoryUtil.getHashCode();
        hashCode.append(this._item.getItemId());
        hashCode.append((Object)this._fields);
        return hashCode.toHashCode();
    }
}

