/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.impl.ShoppingItemImpl;
import com.liferay.portlet.shopping.service.persistence.ShoppingItemFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShoppingItemFinderImpl
extends BasePersistenceImpl<ShoppingItem>
implements ShoppingItemFinder {
    public static final String COUNT_BY_G_C = String.valueOf(ShoppingItemFinder.class.getName()) + ".countByG_C";

    public int countByG_C(long groupId, List<Long> categoryIds) throws SystemException {
        return this.doCountByG_C(groupId, categoryIds, false);
    }

    public int countByFeatured(long groupId, long[] categoryIds) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            StringBundler query = new StringBundler();
            query.append("SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItem ");
            query.append("WHERE ");
            query.append("ShoppingItem.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                int i2 = 0;
                while (i2 < categoryIds.length) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i2 + 1 < categoryIds.length) {
                        query.append("OR ");
                    }
                    ++i2;
                }
                query.append(") AND ");
            }
            query.append("ShoppingItem.featured = ? AND ");
            query.append("ShoppingItem.smallImage = ?");
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            long[] lArray = categoryIds;
            int n = categoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                long categoryId = lArray[n2];
                qPos.add(categoryId);
                ++n2;
            }
            qPos.add(true);
            qPos.add(true);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n3 = count.intValue();
                return n3;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByKeywords(long groupId, long[] categoryIds, String keywords) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            StringBundler query = new StringBundler();
            query.append("SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItem ");
            query.append("WHERE ");
            query.append("ShoppingItem.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                int i2 = 0;
                while (i2 < categoryIds.length) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i2 + 1 < categoryIds.length) {
                        query.append("OR ");
                    }
                    ++i2;
                }
                query.append(") AND ");
            }
            query.append("(ShoppingItem.name LIKE ? OR ");
            query.append("ShoppingItem.description LIKE ? OR ");
            query.append("ShoppingItem.properties LIKE ?))");
            keywords = String.valueOf('%') + keywords + '%';
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            long[] lArray = categoryIds;
            int n = categoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                long categoryId = lArray[n2];
                qPos.add(categoryId);
                ++n2;
            }
            qPos.add(keywords);
            qPos.add(keywords);
            qPos.add(keywords);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n3 = count.intValue();
                return n3;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countBySale(long groupId, long[] categoryIds) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            StringBundler query = new StringBundler();
            query.append("SELECT COUNT(*) AS COUNT_VALUE FROM ShoppingItem ");
            query.append("WHERE ");
            query.append("ShoppingItem.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                int i2 = 0;
                while (i2 < categoryIds.length) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i2 + 1 < categoryIds.length) {
                        query.append("OR ");
                    }
                    ++i2;
                }
                query.append(") AND ");
            }
            query.append("ShoppingItem.sale = ? AND ");
            query.append("ShoppingItem.smallImage = ?");
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            long[] lArray = categoryIds;
            int n = categoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                long categoryId = lArray[n2];
                qPos.add(categoryId);
                ++n2;
            }
            qPos.add(true);
            qPos.add(true);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n3 = count.intValue();
                return n3;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int filterCountByG_C(long groupId, List<Long> categoryIds) throws SystemException {
        return this.doCountByG_C(groupId, categoryIds, true);
    }

    public List<ShoppingItem> findByFeatured(long groupId, long[] categoryIds, int numOfItems) throws SystemException {
        int countByFeatured = this.countByFeatured(groupId, categoryIds);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = new StringBundler();
            query.append("SELECT {ShoppingItem.*} FROM ShoppingItem ");
            query.append("WHERE ");
            query.append("ShoppingItem.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                int i2 = 0;
                while (i2 < categoryIds.length) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i2 + 1 < categoryIds.length) {
                        query.append("OR ");
                    }
                    ++i2;
                }
                query.append(") AND ");
            }
            query.append("ShoppingItem.featured = ? AND ");
            query.append("ShoppingItem.smallImage = ?");
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addEntity("ShoppingItem", ShoppingItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            long[] lArray = categoryIds;
            int n = categoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                long categoryId = lArray[n2];
                qPos.add(categoryId);
                ++n2;
            }
            qPos.add(true);
            qPos.add(true);
            List list = QueryUtil.randomList((Query)q, (Dialect)this.getDialect(), (int)countByFeatured, (int)numOfItems);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingItem> findByKeywords(long groupId, long[] categoryIds, String keywords, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = new StringBundler();
            query.append("SELECT {ShoppingItem.*} FROM ShoppingItem ");
            query.append("WHERE ");
            query.append("ShoppingItem.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                int i2 = 0;
                while (i2 < categoryIds.length) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i2 + 1 < categoryIds.length) {
                        query.append("OR ");
                    }
                    ++i2;
                }
                query.append(") AND ");
            }
            query.append("(ShoppingItem.name LIKE ? OR ");
            query.append("ShoppingItem.description LIKE ? OR ");
            query.append("ShoppingItem.properties LIKE ?))");
            keywords = String.valueOf('%') + keywords + '%';
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addEntity("ShoppingItem", ShoppingItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            long[] lArray = categoryIds;
            int n = categoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                long categoryId = lArray[n2];
                qPos.add(categoryId);
                ++n2;
            }
            qPos.add(keywords);
            qPos.add(keywords);
            qPos.add(keywords);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShoppingItem> findBySale(long groupId, long[] categoryIds, int numOfItems) throws SystemException {
        int countBySale = this.countBySale(groupId, categoryIds);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = new StringBundler();
            query.append("SELECT {ShoppingItem.*} FROM ShoppingItem ");
            query.append("WHERE ");
            query.append("ShoppingItem.groupId = ? AND (");
            if (categoryIds != null && categoryIds.length > 0) {
                query.append("(");
                int i2 = 0;
                while (i2 < categoryIds.length) {
                    query.append("ShoppingItem.categoryId = ? ");
                    if (i2 + 1 < categoryIds.length) {
                        query.append("OR ");
                    }
                    ++i2;
                }
                query.append(") AND ");
            }
            query.append("ShoppingItem.sale = ? AND ");
            query.append("ShoppingItem.smallImage = ?");
            SQLQuery q = session.createSQLQuery(query.toString());
            q.addEntity("ShoppingItem", ShoppingItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            long[] lArray = categoryIds;
            int n = categoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                long categoryId = lArray[n2];
                qPos.add(categoryId);
                ++n2;
            }
            qPos.add(true);
            qPos.add(true);
            List list = QueryUtil.randomList((Query)q, (Dialect)this.getDialect(), (int)countBySale, (int)numOfItems);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_C(long groupId, List<Long> categoryIds, boolean inlineSQLHelper) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_C);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)ShoppingItem.class.getName(), (String)"ShoppingItem.itemId", (long)groupId);
            }
            sql = StringUtil.replace((String)sql, (String)"[$CATEGORY_ID$]", (String)this.getCategoryIds(categoryIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            int i2 = 0;
            while (i2 < categoryIds.size()) {
                Long categoryId = categoryIds.get(i2);
                qPos.add(categoryId);
                ++i2;
            }
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getCategoryIds(List<Long> categoryIds) {
        if (categoryIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(categoryIds.size() * 2 - 1);
        int i2 = 0;
        while (i2 < categoryIds.size()) {
            sb.append("categoryId = ? ");
            if (i2 + 1 != categoryIds.size()) {
                sb.append("OR ");
            }
            ++i2;
        }
        return sb.toString();
    }
}

