/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.ContentUtil;
import java.io.IOException;
import java.util.Currency;
import java.util.Locale;
import java.util.TreeSet;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class ShoppingPreferences {
    public static final String CC_NONE = "none";
    public static final String[] CC_TYPES;
    public static final String[] CURRENCY_IDS;
    public static final double[] INSURANCE_RANGE;
    public static final double[] SHIPPING_RANGE;
    private PortletPreferences _portletPreferences;

    static {
        block7: {
            CC_TYPES = new String[]{"visa", "mastercard", "discover", "amex"};
            String[] ids = null;
            try {
                try {
                    TreeSet<String> set = new TreeSet<String>();
                    Locale[] locales = Locale.getAvailableLocales();
                    int i2 = 0;
                    while (i2 < locales.length) {
                        Locale locale = locales[i2];
                        if (locale.getCountry().length() == 2) {
                            Currency currency = Currency.getInstance(locale);
                            String currencyId = currency.getCurrencyCode();
                            set.add(currencyId);
                        }
                        ++i2;
                    }
                    ids = set.toArray(new String[set.size()]);
                }
                catch (Exception exception) {
                    ids = new String[]{"USD", "CAD", "EUR", "GBP", "JPY"};
                    CURRENCY_IDS = ids;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                CURRENCY_IDS = ids;
                throw throwable;
            }
            CURRENCY_IDS = ids;
        }
        INSURANCE_RANGE = new double[]{0.01, 9.99, 10.0, 49.99, 50.0, 99.99, 100.0, 199.99, 200.0, Double.POSITIVE_INFINITY};
        SHIPPING_RANGE = new double[]{0.01, 9.99, 10.0, 49.99, 50.0, 99.99, 100.0, 199.99, 200.0, Double.POSITIVE_INFINITY};
    }

    public static ShoppingPreferences getInstance(long companyId, long groupId) throws SystemException {
        return new ShoppingPreferences(companyId, groupId);
    }

    public String[][] getAlternativeShipping() {
        String value = this._portletPreferences.getValue("alternativeShipping", null);
        if (value == null) {
            return new String[0][0];
        }
        String[] array = StringUtil.split((String)"alternativeShipping", (String)"[$_ARRAY_$]");
        String[][] alternativeShipping = new String[array.length][0];
        int i2 = 0;
        while (i2 < array.length) {
            alternativeShipping[i2] = StringUtil.split((String)array[i2]);
            ++i2;
        }
        return alternativeShipping;
    }

    public String getAlternativeShippingName(int altShipping) {
        String altShippingName = "";
        try {
            altShippingName = this.getAlternativeShipping()[0][altShipping];
        }
        catch (Exception exception) {}
        return altShippingName;
    }

    public String[] getCcTypes() {
        String ccTypes = this._portletPreferences.getValue("ccTypes", StringUtil.merge((Object[])CC_TYPES));
        if (ccTypes.equals(CC_NONE)) {
            return new String[0];
        }
        return StringUtil.split((String)ccTypes);
    }

    public String getCurrencyId() {
        return this._portletPreferences.getValue("currencyId", "USD");
    }

    public String getEmailFromAddress(long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)this._portletPreferences, (long)companyId, (String)PropsValues.SHOPPING_EMAIL_FROM_ADDRESS);
    }

    public String getEmailFromName(long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)this._portletPreferences, (long)companyId, (String)PropsValues.SHOPPING_EMAIL_FROM_NAME);
    }

    public String getEmailOrderConfirmationBody() {
        String emailOrderConfirmationBody = this._portletPreferences.getValue("emailOrderConfirmationBody", "");
        if (Validator.isNotNull((String)emailOrderConfirmationBody)) {
            return emailOrderConfirmationBody;
        }
        return ContentUtil.get((String)PropsUtil.get("shopping.email.order.confirmation.body"));
    }

    public boolean getEmailOrderConfirmationEnabled() {
        String emailOrderConfirmationEnabled = this._portletPreferences.getValue("emailOrderConfirmationEnabled", "");
        if (Validator.isNotNull((String)emailOrderConfirmationEnabled)) {
            return GetterUtil.getBoolean((String)emailOrderConfirmationEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("shopping.email.order.confirmation.enabled"));
    }

    public String getEmailOrderConfirmationSubject() {
        String emailOrderConfirmationSubject = this._portletPreferences.getValue("emailOrderConfirmationSubject", "");
        if (Validator.isNotNull((String)emailOrderConfirmationSubject)) {
            return emailOrderConfirmationSubject;
        }
        return ContentUtil.get((String)PropsUtil.get("shopping.email.order.confirmation.subject"));
    }

    public String getEmailOrderShippingBody() {
        String emailOrderShippingBody = this._portletPreferences.getValue("emailOrderShippingBody", "");
        if (Validator.isNotNull((String)emailOrderShippingBody)) {
            return emailOrderShippingBody;
        }
        return ContentUtil.get((String)PropsUtil.get("shopping.email.order.shipping.body"));
    }

    public boolean getEmailOrderShippingEnabled() {
        String emailOrderShippingEnabled = this._portletPreferences.getValue("emailOrderShippingEnabled", "");
        if (Validator.isNotNull((String)emailOrderShippingEnabled)) {
            return GetterUtil.getBoolean((String)emailOrderShippingEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("shopping.email.order.shipping.enabled"));
    }

    public String getEmailOrderShippingSubject() {
        String emailOrderShippingSubject = this._portletPreferences.getValue("emailOrderShippingSubject", "");
        if (Validator.isNotNull((String)emailOrderShippingSubject)) {
            return emailOrderShippingSubject;
        }
        return ContentUtil.get((String)PropsUtil.get("shopping.email.order.shipping.subject"));
    }

    public String[] getInsurance() {
        String value = this._portletPreferences.getValue("insurance", null);
        if (value == null) {
            return new String[5];
        }
        return StringUtil.split((String)value);
    }

    public String getInsuranceFormula() {
        return this._portletPreferences.getValue("insuranceFormula", "flat");
    }

    public double getMinOrder() {
        return GetterUtil.getDouble((String)this._portletPreferences.getValue("minOrder", ""));
    }

    public String getPayPalEmailAddress() {
        return this._portletPreferences.getValue("paypalEmailAddress", "");
    }

    public String[] getShipping() {
        String value = this._portletPreferences.getValue("shipping", null);
        if (value == null) {
            return new String[5];
        }
        return StringUtil.split((String)value);
    }

    public String getShippingFormula() {
        return this._portletPreferences.getValue("shippingFormula", "flat");
    }

    public double getTaxRate() {
        return GetterUtil.getDouble((String)this._portletPreferences.getValue("taxRate", ""));
    }

    public String getTaxState() {
        return this._portletPreferences.getValue("taxState", "CA");
    }

    public void setAlternativeShipping(String[][] alternativeShipping) throws ReadOnlyException {
        if (alternativeShipping.length == 0) {
            this._portletPreferences.setValue("alternativeShipping", "");
        }
        StringBundler sb = new StringBundler(alternativeShipping.length * 2 - 1);
        int i2 = 0;
        while (i2 < alternativeShipping.length) {
            sb.append(StringUtil.merge((Object[])alternativeShipping[i2]));
            if (i2 + 1 < alternativeShipping.length) {
                sb.append("[$_ARRAY_$]");
            }
            ++i2;
        }
        this._portletPreferences.setValue("alternativeShipping", sb.toString());
    }

    public void setCcTypes(String[] ccTypes) throws ReadOnlyException {
        if (ccTypes.length == 0) {
            this._portletPreferences.setValue("ccTypes", CC_NONE);
        } else {
            this._portletPreferences.setValue("ccTypes", StringUtil.merge((Object[])ccTypes));
        }
    }

    public void setCurrencyId(String currencyId) throws ReadOnlyException {
        this._portletPreferences.setValue("currencyId", currencyId);
    }

    public void setEmailFromAddress(String emailFromAddress) throws ReadOnlyException {
        this._portletPreferences.setValue("emailFromAddress", emailFromAddress);
    }

    public void setEmailFromName(String emailFromName) throws ReadOnlyException {
        this._portletPreferences.setValue("emailFromName", emailFromName);
    }

    public void setEmailOrderConfirmationBody(String emailOrderConfirmationBody) throws ReadOnlyException {
        this._portletPreferences.setValue("emailOrderConfirmationBody", emailOrderConfirmationBody);
    }

    public void setEmailOrderConfirmationEnabled(boolean emailOrderConfirmationEnabled) throws ReadOnlyException {
        this._portletPreferences.setValue("emailOrderConfirmationEnabled", String.valueOf(emailOrderConfirmationEnabled));
    }

    public void setEmailOrderConfirmationSubject(String emailOrderConfirmationSubject) throws ReadOnlyException {
        this._portletPreferences.setValue("emailOrderConfirmationSubject", emailOrderConfirmationSubject);
    }

    public void setEmailOrderShippingBody(String emailOrderShippingBody) throws ReadOnlyException {
        this._portletPreferences.setValue("emailOrderShippingBody", emailOrderShippingBody);
    }

    public void setEmailOrderShippingEnabled(boolean emailOrderShippingEnabled) throws ReadOnlyException {
        this._portletPreferences.setValue("emailOrderShippingEnabled", String.valueOf(emailOrderShippingEnabled));
    }

    public void setEmailOrderShippingSubject(String emailOrderShippingSubject) throws ReadOnlyException {
        this._portletPreferences.setValue("emailOrderShippingSubject", emailOrderShippingSubject);
    }

    public void setInsurance(String[] insurance) throws ReadOnlyException {
        this._portletPreferences.setValue("insurance", StringUtil.merge((Object[])insurance));
    }

    public void setInsuranceFormula(String insuranceFormula) throws ReadOnlyException {
        this._portletPreferences.setValue("insuranceFormula", insuranceFormula);
    }

    public void setMinOrder(double minOrder) throws ReadOnlyException {
        this._portletPreferences.setValue("minOrder", String.valueOf(minOrder));
    }

    public void setPayPalEmailAddress(String payPalEmailAddress) throws ReadOnlyException {
        this._portletPreferences.setValue("paypalEmailAddress", payPalEmailAddress);
    }

    public void setShipping(String[] shipping) throws ReadOnlyException {
        this._portletPreferences.setValue("shipping", StringUtil.merge((Object[])shipping));
    }

    public void setShippingFormula(String shippingFormula) throws ReadOnlyException {
        this._portletPreferences.setValue("shippingFormula", shippingFormula);
    }

    public void setTaxRate(double taxRate) throws ReadOnlyException {
        this._portletPreferences.setValue("taxRate", String.valueOf(taxRate));
    }

    public void setTaxState(String taxState) throws ReadOnlyException {
        this._portletPreferences.setValue("taxState", taxState);
    }

    public void store() throws IOException, ValidatorException {
        this._portletPreferences.store();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean useAlternativeShipping() {
        String[][] alternativeShipping = this.getAlternativeShipping();
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= 10) {
                    return false;
                }
                if (Validator.isNotNull((String)alternativeShipping[0][i2]) && Validator.isNotNull((String)alternativeShipping[1][i2])) {
                    return true;
                }
                ++i2;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean usePayPal() {
        return Validator.isNotNull((String)this.getPayPalEmailAddress());
    }

    protected ShoppingPreferences(long companyId, long groupId) throws SystemException {
        long ownerId = groupId;
        int ownerType = 2;
        long plid = 0L;
        String portletId = "34";
        this._portletPreferences = PortletPreferencesLocalServiceUtil.getPreferences((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId);
    }
}

