/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.social.model.SocialAchievement;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityCounter;
import com.liferay.portlet.social.model.SocialActivityCounterDefinition;
import com.liferay.portlet.social.model.SocialActivityDefinition;
import com.liferay.portlet.social.model.SocialActivityLimit;
import com.liferay.portlet.social.model.SocialActivityProcessor;
import com.liferay.portlet.social.service.SocialActivityCounterLocalService;
import com.liferay.portlet.social.service.base.SocialActivityCounterLocalServiceBaseImpl;
import com.liferay.portlet.social.service.persistence.SocialActivityCounterFinderUtil;
import com.liferay.portlet.social.util.SocialCounterPeriodUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialActivityCounterLocalServiceImpl
extends SocialActivityCounterLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(SocialActivityCounterLocalService.class);

    public SocialActivityCounter addActivityCounter(long groupId, long classNameId, long classPK, String name, int ownerType, int currentValue, int totalValue, int startPeriod, int endPeriod) throws PortalException, SystemException {
        return this.addActivityCounter(groupId, classNameId, classPK, name, ownerType, currentValue, totalValue, startPeriod, endPeriod, 0L, 0);
    }

    public SocialActivityCounter addActivityCounter(long groupId, long classNameId, long classPK, String name, int ownerType, int currentValue, int totalValue, int startPeriod, int endPeriod, long previousActivityCounterId, int periodLength) throws PortalException, SystemException {
        SocialActivityCounter activityCounter = null;
        String lockKey = this.getLockKey(groupId, classNameId, classPK, name, ownerType);
        Lock lock = null;
        while (true) {
            try {
                lock = this.lockLocalService.lock(SocialActivityCounter.class.getName(), lockKey, lockKey, false);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)"Unable to acquire activity counter lock. Retrying.");
                continue;
            }
            if (lock.isNew()) {
                try {
                    DB db = DBFactoryUtil.getDB();
                    String dbType = db.getType();
                    if (dbType.equals("hypersonic")) {
                        activityCounter = this.createActivityCounter(groupId, classNameId, classPK, name, ownerType, currentValue, totalValue, startPeriod, endPeriod, previousActivityCounterId, periodLength);
                        break;
                    }
                    activityCounter = this.socialActivityCounterLocalService.createActivityCounter(groupId, classNameId, classPK, name, ownerType, currentValue, totalValue, startPeriod, endPeriod, previousActivityCounterId, periodLength);
                    break;
                }
                finally {
                    this.lockLocalService.unlock(SocialActivityCounter.class.getName(), lockKey, lockKey, false);
                }
            }
            Date createDate = lock.getCreateDate();
            if (System.currentTimeMillis() - createDate.getTime() >= PropsValues.SOCIAL_ACTIVITY_COUNTER_LOCK_TIMEOUT) {
                this.lockLocalService.unlock(SocialActivityCounter.class.getName(), lockKey, lock.getOwner(), false);
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Forcibly removed lock " + lock + ". See " + "social.activity.counter.lock.timeout"));
                continue;
            }
            try {
                Thread.sleep(PropsValues.SOCIAL_ACTIVITY_COUNTER_LOCK_RETRY_DELAY);
            }
            catch (InterruptedException ie) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)"Interrupted while waiting to reacquire lock", (Throwable)ie);
            }
        }
        return activityCounter;
    }

    public void addActivityCounters(SocialActivity activity) throws PortalException, SystemException {
        if (!this.socialActivitySettingLocalService.isEnabled(activity.getGroupId(), activity.getClassNameId())) {
            return;
        }
        User user = this.userPersistence.findByPrimaryKey(activity.getUserId());
        SocialActivityDefinition activityDefinition = this.socialActivitySettingLocalService.getActivityDefinition(activity.getGroupId(), activity.getClassName(), activity.getType());
        if (activityDefinition == null || !activityDefinition.isEnabled()) {
            return;
        }
        SocialActivityProcessor activityProcessor = activityDefinition.getActivityProcessor();
        if (activityProcessor != null) {
            activityProcessor.processActivity(activity);
        }
        AssetEntry assetEntry = activity.getAssetEntry();
        User assetEntryUser = this.userPersistence.findByPrimaryKey(assetEntry.getUserId());
        for (SocialActivityCounterDefinition activityCounterDefinition : activityDefinition.getActivityCounterDefinitions()) {
            if (!this.addActivityCounter(user, assetEntryUser, activityCounterDefinition) || !this.checkActivityLimit(user, activity, activityCounterDefinition)) continue;
            this.incrementActivityCounter(activity.getGroupId(), user, activity.getAssetEntry(), activityCounterDefinition);
        }
        for (SocialAchievement achievement : activityDefinition.getAchievements()) {
            achievement.processActivity(activity);
        }
        if (!user.isDefaultUser() && user.isActive()) {
            this.incrementActivityCounter(activity.getGroupId(), PortalUtil.getClassNameId((String)User.class.getName()), activity.getUserId(), "user.activities", 1, 1, 0);
        }
        if (!assetEntryUser.isDefaultUser() && assetEntryUser.isActive()) {
            this.incrementActivityCounter(activity.getGroupId(), activity.getClassNameId(), activity.getClassPK(), "asset.activities", 2, 1, 0);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public SocialActivityCounter createActivityCounter(long groupId, long classNameId, long classPK, String name, int ownerType, int currentValue, int totalValue, int startPeriod, int endPeriod) throws PortalException, SystemException {
        return this.createActivityCounter(groupId, classNameId, classPK, name, ownerType, currentValue, totalValue, startPeriod, endPeriod, 0L, 0);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public SocialActivityCounter createActivityCounter(long groupId, long classNameId, long classPK, String name, int ownerType, int currentValue, int totalValue, int startPeriod, int endPeriod, long previousActivityCounterId, int periodLength) throws PortalException, SystemException {
        SocialActivityCounter activityCounter = null;
        if (previousActivityCounterId != 0L) {
            activityCounter = this.socialActivityCounterPersistence.findByPrimaryKey(previousActivityCounterId);
            if (periodLength == 0) {
                activityCounter.setEndPeriod(SocialCounterPeriodUtil.getStartPeriod() - 1);
            } else {
                activityCounter.setEndPeriod(activityCounter.getStartPeriod() + periodLength - 1);
            }
            this.socialActivityCounterPersistence.update((BaseModel)activityCounter, false);
        }
        if ((activityCounter = this.socialActivityCounterPersistence.fetchByG_C_C_N_O_E(groupId, classNameId, classPK, name, ownerType, endPeriod, false)) != null) {
            return activityCounter;
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        long activityCounterId = this.counterLocalService.increment();
        activityCounter = this.socialActivityCounterPersistence.create(activityCounterId);
        activityCounter.setGroupId(groupId);
        activityCounter.setCompanyId(group.getCompanyId());
        activityCounter.setClassNameId(classNameId);
        activityCounter.setClassPK(classPK);
        activityCounter.setName(name);
        activityCounter.setOwnerType(ownerType);
        activityCounter.setCurrentValue(currentValue);
        activityCounter.setTotalValue(totalValue);
        activityCounter.setStartPeriod(startPeriod);
        activityCounter.setEndPeriod(endPeriod);
        this.socialActivityCounterPersistence.update((BaseModel)activityCounter, false);
        return activityCounter;
    }

    public void deleteActivityCounters(AssetEntry assetEntry) throws PortalException, SystemException {
        if (assetEntry == null) {
            return;
        }
        SocialActivityCounter latestContributionActivityCounter = this.fetchLatestActivityCounter(assetEntry.getGroupId(), PortalUtil.getClassNameId((String)User.class.getName()), assetEntry.getUserId(), "contribution", 3);
        SocialActivityCounter latestPopularityActivityCounter = this.fetchLatestActivityCounter(assetEntry.getGroupId(), assetEntry.getClassNameId(), assetEntry.getClassPK(), "popularity", 2);
        if (latestContributionActivityCounter != null && latestPopularityActivityCounter != null) {
            int startPeriod = SocialCounterPeriodUtil.getStartPeriod();
            if (latestContributionActivityCounter.getStartPeriod() != startPeriod) {
                latestContributionActivityCounter = this.addActivityCounter(latestContributionActivityCounter.getGroupId(), latestContributionActivityCounter.getClassNameId(), latestContributionActivityCounter.getClassPK(), latestContributionActivityCounter.getName(), latestContributionActivityCounter.getOwnerType(), 0, latestContributionActivityCounter.getTotalValue(), SocialCounterPeriodUtil.getStartPeriod(), -1, latestContributionActivityCounter.getActivityCounterId(), 0);
            }
            if (latestPopularityActivityCounter.getStartPeriod() == startPeriod) {
                latestContributionActivityCounter.setCurrentValue(latestContributionActivityCounter.getCurrentValue() - latestPopularityActivityCounter.getCurrentValue());
            }
            latestContributionActivityCounter.setTotalValue(latestContributionActivityCounter.getTotalValue() - latestPopularityActivityCounter.getTotalValue());
            this.socialActivityCounterPersistence.update((BaseModel)latestContributionActivityCounter, false);
        }
        this.deleteActivityCounters(assetEntry.getClassNameId(), assetEntry.getClassPK());
        this.socialActivityLimitPersistence.removeByC_C(assetEntry.getClassNameId(), assetEntry.getClassPK());
    }

    public void deleteActivityCounters(long classNameId, long classPK) throws SystemException {
        this.socialActivityCounterPersistence.removeByC_C(classNameId, classPK);
    }

    public SocialActivityCounter fetchActivityCounterByEndPeriod(long groupId, long classNameId, long classPK, String name, int ownerType, int endPeriod) throws SystemException {
        return this.socialActivityCounterPersistence.fetchByG_C_C_N_O_E(groupId, classNameId, classPK, name, ownerType, endPeriod);
    }

    public SocialActivityCounter fetchActivityCounterByStartPeriod(long groupId, long classNameId, long classPK, String name, int ownerType, int startPeriod) throws SystemException {
        return this.socialActivityCounterPersistence.fetchByG_C_C_N_O_S(groupId, classNameId, classPK, name, ownerType, startPeriod);
    }

    public SocialActivityCounter fetchLatestActivityCounter(long groupId, long classNameId, long classPK, String name, int ownerType) throws SystemException {
        return this.socialActivityCounterPersistence.fetchByG_C_C_N_O_E(groupId, classNameId, classPK, name, ownerType, -1);
    }

    public List<SocialActivityCounter> getOffsetActivityCounters(long groupId, String name, int startOffset, int endOffset) throws SystemException {
        int startPeriod = SocialCounterPeriodUtil.getStartPeriod((int)startOffset);
        int endPeriod = SocialCounterPeriodUtil.getEndPeriod((int)endOffset);
        return this.getPeriodActivityCounters(groupId, name, startPeriod, endPeriod);
    }

    public List<SocialActivityCounter> getOffsetDistributionActivityCounters(long groupId, String name, int startOffset, int endOffset) throws SystemException {
        int startPeriod = SocialCounterPeriodUtil.getStartPeriod((int)startOffset);
        int endPeriod = SocialCounterPeriodUtil.getEndPeriod((int)endOffset);
        return this.getPeriodDistributionActivityCounters(groupId, name, startPeriod, endPeriod);
    }

    public List<SocialActivityCounter> getPeriodActivityCounters(long groupId, String name, int startPeriod, int endPeriod) throws SystemException {
        int offset = SocialCounterPeriodUtil.getOffset((int)endPeriod);
        int periodLength = SocialCounterPeriodUtil.getPeriodLength((int)offset);
        return this.socialActivityCounterFinder.findAC_ByG_N_S_E_1(groupId, name, startPeriod, endPeriod, periodLength);
    }

    public List<SocialActivityCounter> getPeriodDistributionActivityCounters(long groupId, String name, int startPeriod, int endPeriod) throws SystemException {
        int offset = SocialCounterPeriodUtil.getOffset((int)endPeriod);
        int periodLength = SocialCounterPeriodUtil.getPeriodLength((int)offset);
        return this.socialActivityCounterFinder.findAC_ByG_N_S_E_2(groupId, name, startPeriod, endPeriod, periodLength);
    }

    public List<Tuple> getUserActivityCounters(long groupId, String[] rankingNames, String[] selectedNames, int start, int end) throws SystemException {
        List userIds = this.socialActivityCounterFinder.findU_ByG_N(groupId, rankingNames, start, end);
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        Tuple[] userActivityCounters = new Tuple[userIds.size()];
        List activityCounters = SocialActivityCounterFinderUtil.findAC_By_G_C_C_N_S_E((long)groupId, (List)userIds, (String[])selectedNames, (int)-1, (int)-1);
        long userId = 0L;
        HashMap<String, SocialActivityCounter> activityCountersMap = null;
        for (SocialActivityCounter activityCounter : activityCounters) {
            if (userId != activityCounter.getClassPK()) {
                userId = activityCounter.getClassPK();
                activityCountersMap = new HashMap<String, SocialActivityCounter>();
                Tuple userActivityCounter = new Tuple(new Object[]{userId, activityCountersMap});
                int i2 = 0;
                while (i2 < userIds.size()) {
                    long curUserId = (Long)userIds.get(i2);
                    if (userId == curUserId) {
                        userActivityCounters[i2] = userActivityCounter;
                        break;
                    }
                    ++i2;
                }
            }
            activityCountersMap.put(activityCounter.getName(), activityCounter);
        }
        return Arrays.asList(userActivityCounters);
    }

    public int getUserActivityCountersCount(long groupId, String[] rankingNames) throws SystemException {
        return SocialActivityCounterFinderUtil.countU_ByG_N((long)groupId, (String[])rankingNames);
    }

    public void incrementUserAchievementCounter(long userId, long groupId) throws PortalException, SystemException {
        this.incrementActivityCounter(groupId, PortalUtil.getClassNameId((String)User.class.getName()), userId, "user.achievements", 1, 1, 0);
    }

    protected boolean addActivityCounter(User user, User assetEntryUser, SocialActivityCounterDefinition activityCounterDefinition) {
        if ((user.isDefaultUser() || !user.isActive()) && activityCounterDefinition.getOwnerType() != 2) {
            return false;
        }
        if ((assetEntryUser.isDefaultUser() || !assetEntryUser.isActive()) && activityCounterDefinition.getOwnerType() != 1) {
            return false;
        }
        if (!activityCounterDefinition.isEnabled() || activityCounterDefinition.getIncrement() == 0) {
            return false;
        }
        String name = activityCounterDefinition.getName();
        return user.getUserId() != assetEntryUser.getUserId() || !name.equals("contribution") && !name.equals("popularity");
    }

    protected boolean checkActivityLimit(User user, SocialActivity activity, SocialActivityCounterDefinition activityCounterDefinition) throws PortalException, SystemException {
        int count;
        SocialActivityLimit activityLimit;
        block6: {
            if (activityCounterDefinition.getLimitValue() == 0) {
                return true;
            }
            long classPK = activity.getClassPK();
            String name = activityCounterDefinition.getName();
            if (name.equals("participation")) {
                classPK = 0L;
            }
            if ((activityLimit = this.socialActivityLimitPersistence.fetchByG_U_C_C_A_A(activity.getGroupId(), user.getUserId(), activity.getClassNameId(), classPK, activity.getType(), activityCounterDefinition.getName())) == null) {
                try {
                    activityLimit = this.socialActivityLimitLocalService.addActivityLimit(user.getUserId(), activity.getGroupId(), activity.getClassNameId(), classPK, activity.getType(), activityCounterDefinition.getName(), activityCounterDefinition.getLimitPeriod());
                }
                catch (SystemException se) {
                    activityLimit = this.socialActivityLimitPersistence.fetchByG_U_C_C_A_A(activity.getGroupId(), user.getUserId(), activity.getClassNameId(), classPK, activity.getType(), activityCounterDefinition.getName());
                    if (activityLimit != null) break block6;
                    throw se;
                }
            }
        }
        if ((count = activityLimit.getCount(activityCounterDefinition.getLimitPeriod())) < activityCounterDefinition.getLimitValue()) {
            activityLimit.setCount(activityCounterDefinition.getLimitPeriod(), count + 1);
            this.socialActivityLimitPersistence.update((BaseModel)activityLimit, false);
            return true;
        }
        return false;
    }

    protected String getLockKey(long groupId, long classNameId, long classPK, String name, int ownerType) {
        StringBundler sb = new StringBundler(7);
        sb.append(StringUtil.toHexString((long)groupId));
        sb.append("#");
        sb.append(StringUtil.toHexString((long)classNameId));
        sb.append("#");
        sb.append(StringUtil.toHexString((long)classPK));
        sb.append("#");
        sb.append(name);
        return sb.toString();
    }

    protected void incrementActivityCounter(long groupId, long classNameId, long classPK, String name, int ownerType, int increment, int periodLength) throws PortalException, SystemException {
        SocialActivityCounter activityCounter = this.fetchLatestActivityCounter(groupId, classNameId, classPK, name, ownerType);
        if (activityCounter == null) {
            activityCounter = this.addActivityCounter(groupId, classNameId, classPK, name, ownerType, 0, 0, SocialCounterPeriodUtil.getStartPeriod(), -1);
            if (periodLength > 0) {
                activityCounter.setStartPeriod(SocialCounterPeriodUtil.getActivityDay());
            }
        }
        if (!activityCounter.isActivePeriod(periodLength)) {
            activityCounter = this.addActivityCounter(activityCounter.getGroupId(), activityCounter.getClassNameId(), activityCounter.getClassPK(), activityCounter.getName(), activityCounter.getOwnerType(), 0, activityCounter.getTotalValue(), SocialCounterPeriodUtil.getStartPeriod(), -1, activityCounter.getActivityCounterId(), periodLength);
        }
        activityCounter.setCurrentValue(activityCounter.getCurrentValue() + increment);
        activityCounter.setTotalValue(activityCounter.getTotalValue() + increment);
        this.socialActivityCounterPersistence.update((BaseModel)activityCounter, false);
    }

    protected void incrementActivityCounter(long groupId, User user, AssetEntry assetEntry, SocialActivityCounterDefinition activityCounterDefinition) throws PortalException, SystemException {
        int ownerType = activityCounterDefinition.getOwnerType();
        long userClassNameId = PortalUtil.getClassNameId((String)User.class.getName());
        if (ownerType == 1) {
            this.incrementActivityCounter(groupId, userClassNameId, user.getUserId(), activityCounterDefinition.getName(), ownerType, activityCounterDefinition.getIncrement(), activityCounterDefinition.getPeriodLength());
        } else if (ownerType == 2) {
            this.incrementActivityCounter(groupId, assetEntry.getClassNameId(), assetEntry.getClassPK(), activityCounterDefinition.getName(), ownerType, activityCounterDefinition.getIncrement(), activityCounterDefinition.getPeriodLength());
        } else {
            this.incrementActivityCounter(groupId, userClassNameId, assetEntry.getUserId(), activityCounterDefinition.getName(), ownerType, activityCounterDefinition.getIncrement(), activityCounterDefinition.getPeriodLength());
        }
    }
}

