/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ImportExportThreadLocal;
import com.liferay.portal.kernel.messaging.async.Async;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.social.NoSuchActivityException;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityDefinition;
import com.liferay.portlet.social.service.base.SocialActivityLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialActivityLocalServiceImpl
extends SocialActivityLocalServiceBaseImpl {
    public void addActivity(long userId, long groupId, Date createDate, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException, SystemException {
        Group group;
        if (ImportExportThreadLocal.isImportInProcess()) {
            return;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        if (groupId > 0L && (group = this.groupLocalService.getGroup(groupId)).isLayout()) {
            Layout layout = this.layoutLocalService.getLayout(group.getClassPK());
            groupId = layout.getGroupId();
        }
        SocialActivity activity = this.socialActivityPersistence.create(0L);
        activity.setGroupId(groupId);
        activity.setCompanyId(user.getCompanyId());
        activity.setUserId(user.getUserId());
        activity.setCreateDate(createDate.getTime());
        activity.setMirrorActivityId(0L);
        activity.setClassNameId(classNameId);
        activity.setClassPK(classPK);
        activity.setType(type);
        activity.setExtraData(extraData);
        activity.setReceiverUserId(receiverUserId);
        AssetEntry assetEntry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        activity.setAssetEntry(assetEntry);
        SocialActivity mirrorActivity = null;
        if (receiverUserId > 0L && userId != receiverUserId) {
            mirrorActivity = this.socialActivityPersistence.create(0L);
            mirrorActivity.setGroupId(groupId);
            mirrorActivity.setCompanyId(user.getCompanyId());
            mirrorActivity.setUserId(receiverUserId);
            mirrorActivity.setCreateDate(createDate.getTime());
            mirrorActivity.setClassNameId(classNameId);
            mirrorActivity.setClassPK(classPK);
            mirrorActivity.setType(type);
            mirrorActivity.setExtraData(extraData);
            mirrorActivity.setReceiverUserId(user.getUserId());
            mirrorActivity.setAssetEntry(assetEntry);
        }
        this.socialActivityLocalService.addActivity(activity, mirrorActivity);
    }

    public void addActivity(long userId, long groupId, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException, SystemException {
        SocialActivity socialActivity;
        if (ImportExportThreadLocal.isImportInProcess()) {
            return;
        }
        Date createDate = new Date();
        long classNameId = PortalUtil.getClassNameId((String)className);
        while ((socialActivity = this.socialActivityPersistence.fetchByG_U_CD_C_C_T_R(groupId, userId, createDate.getTime(), classNameId, classPK, type, receiverUserId)) != null) {
            createDate = new Date(createDate.getTime() + 1L);
        }
        this.addActivity(userId, groupId, createDate, className, classPK, type, extraData, receiverUserId);
    }

    @Async
    public void addActivity(SocialActivity activity, SocialActivity mirrorActivity) throws PortalException, SystemException {
        if (ImportExportThreadLocal.isImportInProcess()) {
            return;
        }
        if (activity.getActivityId() > 0L || mirrorActivity != null && mirrorActivity.getActivityId() > 0L) {
            throw new PortalException("Activity and mirror activity must not have primary keys set");
        }
        SocialActivityDefinition activityDefinition = this.socialActivitySettingLocalService.getActivityDefinition(activity.getGroupId(), activity.getClassName(), activity.getType());
        if (activityDefinition == null && activity.getType() < 10000 || activityDefinition != null && activityDefinition.isLogActivity()) {
            long activityId = this.counterLocalService.increment(SocialActivity.class.getName());
            activity.setActivityId(activityId);
            this.socialActivityPersistence.update((BaseModel)activity, false);
            if (mirrorActivity != null) {
                long mirrorActivityId = this.counterLocalService.increment(SocialActivity.class.getName());
                mirrorActivity.setActivityId(mirrorActivityId);
                mirrorActivity.setMirrorActivityId(activity.getPrimaryKey());
                this.socialActivityPersistence.update((BaseModel)mirrorActivity, false);
            }
        }
        this.socialActivityCounterLocalService.addActivityCounters(activity);
    }

    public void addUniqueActivity(long userId, long groupId, Date createDate, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        SocialActivity socialActivity = this.socialActivityPersistence.fetchByG_U_CD_C_C_T_R(groupId, userId, createDate.getTime(), classNameId, classPK, type, receiverUserId);
        if (socialActivity != null) {
            return;
        }
        this.addActivity(userId, groupId, createDate, className, classPK, type, extraData, receiverUserId);
    }

    public void addUniqueActivity(long userId, long groupId, String className, long classPK, int type, String extraData, long receiverUserId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        int count = this.socialActivityPersistence.countByG_U_C_C_T_R(groupId, userId, classNameId, classPK, type, receiverUserId);
        if (count > 0) {
            return;
        }
        this.addActivity(userId, groupId, new Date(), className, classPK, type, extraData, receiverUserId);
    }

    public void deleteActivities(AssetEntry assetEntry) throws PortalException, SystemException {
        this.socialActivityPersistence.removeByC_C(assetEntry.getClassNameId(), assetEntry.getClassPK());
        this.socialActivityCounterLocalService.deleteActivityCounters(assetEntry);
    }

    public void deleteActivities(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.socialActivityPersistence.removeByC_C(classNameId, classPK);
    }

    public void deleteActivity(long activityId) throws PortalException, SystemException {
        SocialActivity activity = this.socialActivityPersistence.findByPrimaryKey(activityId);
        this.deleteActivity(activity);
    }

    public void deleteActivity(SocialActivity activity) throws SystemException {
        this.socialActivityPersistence.remove((BaseModel)activity);
        try {
            this.socialActivityPersistence.removeByMirrorActivityId(activity.getActivityId());
        }
        catch (NoSuchActivityException noSuchActivityException) {}
    }

    public void deleteUserActivities(long userId) throws SystemException {
        List activities = this.socialActivityPersistence.findByUserId(userId, -1, -1);
        for (SocialActivity activity : activities) {
            this.socialActivityPersistence.remove((BaseModel)activity);
        }
        activities = this.socialActivityPersistence.findByReceiverUserId(userId, -1, -1);
        for (SocialActivity activity : activities) {
            this.socialActivityPersistence.remove((BaseModel)activity);
        }
        this.socialActivityCounterLocalService.deleteActivityCounters(PortalUtil.getClassNameId((String)User.class.getName()), userId);
    }

    public List<SocialActivity> getActivities(long classNameId, int start, int end) throws SystemException {
        return this.socialActivityPersistence.findByClassNameId(classNameId, start, end);
    }

    public List<SocialActivity> getActivities(long mirrorActivityId, long classNameId, long classPK, int start, int end) throws SystemException {
        return this.socialActivityPersistence.findByM_C_C(mirrorActivityId, classNameId, classPK, start, end);
    }

    public List<SocialActivity> getActivities(long mirrorActivityId, String className, long classPK, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getActivities(mirrorActivityId, classNameId, classPK, start, end);
    }

    public List<SocialActivity> getActivities(String className, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getActivities(classNameId, start, end);
    }

    public int getActivitiesCount(long classNameId) throws SystemException {
        return this.socialActivityPersistence.countByClassNameId(classNameId);
    }

    public int getActivitiesCount(long mirrorActivityId, long classNameId, long classPK) throws SystemException {
        return this.socialActivityPersistence.countByM_C_C(mirrorActivityId, classNameId, classPK);
    }

    public int getActivitiesCount(long mirrorActivityId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getActivitiesCount(mirrorActivityId, classNameId, classPK);
    }

    public int getActivitiesCount(String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getActivitiesCount(classNameId);
    }

    public SocialActivity getActivity(long activityId) throws PortalException, SystemException {
        return this.socialActivityPersistence.findByPrimaryKey(activityId);
    }

    public List<SocialActivity> getGroupActivities(long groupId, int start, int end) throws SystemException {
        return this.socialActivityFinder.findByGroupId(groupId, start, end);
    }

    public int getGroupActivitiesCount(long groupId) throws SystemException {
        return this.socialActivityFinder.countByGroupId(groupId);
    }

    public List<SocialActivity> getGroupUsersActivities(long groupId, int start, int end) throws SystemException {
        return this.socialActivityFinder.findByGroupUsers(groupId, start, end);
    }

    public int getGroupUsersActivitiesCount(long groupId) throws SystemException {
        return this.socialActivityFinder.countByGroupUsers(groupId);
    }

    public SocialActivity getMirrorActivity(long mirrorActivityId) throws PortalException, SystemException {
        return this.socialActivityPersistence.findByMirrorActivityId(mirrorActivityId);
    }

    public List<SocialActivity> getOrganizationActivities(long organizationId, int start, int end) throws SystemException {
        return this.socialActivityFinder.findByOrganizationId(organizationId, start, end);
    }

    public int getOrganizationActivitiesCount(long organizationId) throws SystemException {
        return this.socialActivityFinder.countByOrganizationId(organizationId);
    }

    public List<SocialActivity> getOrganizationUsersActivities(long organizationId, int start, int end) throws SystemException {
        return this.socialActivityFinder.findByOrganizationUsers(organizationId, start, end);
    }

    public int getOrganizationUsersActivitiesCount(long organizationId) throws SystemException {
        return this.socialActivityFinder.countByOrganizationUsers(organizationId);
    }

    public List<SocialActivity> getRelationActivities(long userId, int start, int end) throws SystemException {
        return this.socialActivityFinder.findByRelation(userId, start, end);
    }

    public List<SocialActivity> getRelationActivities(long userId, int type, int start, int end) throws SystemException {
        return this.socialActivityFinder.findByRelationType(userId, type, start, end);
    }

    public int getRelationActivitiesCount(long userId) throws SystemException {
        return this.socialActivityFinder.countByRelation(userId);
    }

    public int getRelationActivitiesCount(long userId, int type) throws SystemException {
        return this.socialActivityFinder.countByRelationType(userId, type);
    }

    public List<SocialActivity> getUserActivities(long userId, int start, int end) throws SystemException {
        return this.socialActivityPersistence.findByUserId(userId, start, end);
    }

    public int getUserActivitiesCount(long userId) throws SystemException {
        return this.socialActivityPersistence.countByUserId(userId);
    }

    public List<SocialActivity> getUserGroupsActivities(long userId, int start, int end) throws SystemException {
        return this.socialActivityFinder.findByUserGroups(userId, start, end);
    }

    public int getUserGroupsActivitiesCount(long userId) throws SystemException {
        return this.socialActivityFinder.countByUserGroups(userId);
    }

    public List<SocialActivity> getUserGroupsAndOrganizationsActivities(long userId, int start, int end) throws SystemException {
        return this.socialActivityFinder.findByUserGroupsAndOrganizations(userId, start, end);
    }

    public int getUserGroupsAndOrganizationsActivitiesCount(long userId) throws SystemException {
        return this.socialActivityFinder.countByUserGroupsAndOrganizations(userId);
    }

    public List<SocialActivity> getUserOrganizationsActivities(long userId, int start, int end) throws SystemException {
        return this.socialActivityFinder.findByUserOrganizations(userId, start, end);
    }

    public int getUserOrganizationsActivitiesCount(long userId) throws SystemException {
        return this.socialActivityFinder.countByUserOrganizations(userId);
    }
}

