/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.social.model.SocialActivityCounterDefinition;
import com.liferay.portlet.social.model.SocialActivityDefinition;
import com.liferay.portlet.social.model.SocialActivitySetting;
import com.liferay.portlet.social.service.base.SocialActivitySettingLocalServiceBaseImpl;
import com.liferay.portlet.social.util.SocialConfigurationUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialActivitySettingLocalServiceImpl
extends SocialActivitySettingLocalServiceBaseImpl {
    private static PortalCache _activityDefinitions = MultiVMPoolUtil.getCache((String)SocialActivitySettingLocalServiceImpl.class.getName());

    public SocialActivityDefinition getActivityDefinition(long groupId, String className, int activityType) throws SystemException {
        String key = this.encodeKey(groupId, className, activityType);
        SocialActivityDefinition activityDefinition = (SocialActivityDefinition)_activityDefinitions.get((Serializable)((Object)key));
        if (activityDefinition != null) {
            return activityDefinition;
        }
        SocialActivityDefinition defaultActivityDefinition = SocialConfigurationUtil.getActivityDefinition(className, activityType);
        if (defaultActivityDefinition == null) {
            return null;
        }
        activityDefinition = this.getActivityDefinition(groupId, className, activityType, defaultActivityDefinition);
        _activityDefinitions.put((Serializable)((Object)key), (Serializable)activityDefinition);
        return activityDefinition;
    }

    public List<SocialActivityDefinition> getActivityDefinitions(long groupId, String className) throws SystemException {
        ArrayList<SocialActivityDefinition> activityDefinitions = new ArrayList<SocialActivityDefinition>();
        List<SocialActivityDefinition> defaultActivityDefinitions = SocialConfigurationUtil.getActivityDefinitions(className);
        for (SocialActivityDefinition defaultActivityDefinition : defaultActivityDefinitions) {
            SocialActivityDefinition activityDefinition = this.getActivityDefinition(groupId, className, defaultActivityDefinition.getActivityType());
            activityDefinitions.add(activityDefinition);
        }
        return activityDefinitions;
    }

    public List<SocialActivitySetting> getActivitySettings(long groupId) throws SystemException {
        return this.socialActivitySettingPersistence.findByG_A(groupId, 0);
    }

    public boolean isEnabled(long groupId, long classNameId) throws SystemException {
        SocialActivitySetting activitySetting = this.socialActivitySettingPersistence.fetchByG_C_A_N(groupId, classNameId, 0, "enabled");
        if (activitySetting == null) {
            return false;
        }
        return GetterUtil.getBoolean((String)activitySetting.getValue());
    }

    public void updateActivitySetting(long groupId, String className, boolean enabled) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        SocialActivitySetting activitySetting = this.socialActivitySettingPersistence.fetchByG_C_A_N(groupId, classNameId, 0, "enabled");
        if (activitySetting == null) {
            Group group = this.groupLocalService.getGroup(groupId);
            long activitySettingId = this.counterLocalService.increment();
            activitySetting = this.socialActivitySettingPersistence.create(activitySettingId);
            activitySetting.setGroupId(groupId);
            activitySetting.setCompanyId(group.getCompanyId());
            activitySetting.setClassNameId(classNameId);
            activitySetting.setName("enabled");
        }
        activitySetting.setValue(String.valueOf(enabled));
        this.socialActivitySettingPersistence.update((BaseModel)activitySetting, false);
    }

    public void updateActivitySetting(long groupId, String className, int activityType, SocialActivityCounterDefinition activityCounterDefinition) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        SocialActivityDefinition defaultActivityDefinition = SocialConfigurationUtil.getActivityDefinition(className, activityType);
        SocialActivityCounterDefinition defaultActivityCounterDefinition = defaultActivityDefinition.getActivityCounterDefinition(activityCounterDefinition.getName());
        SocialActivitySetting activitySetting = this.socialActivitySettingPersistence.fetchByG_C_A_N(groupId, classNameId, activityType, activityCounterDefinition.getName());
        if (defaultActivityCounterDefinition != null && defaultActivityCounterDefinition.equals((Object)activityCounterDefinition)) {
            if (activitySetting != null) {
                this.socialActivitySettingPersistence.remove((BaseModel)activitySetting);
            }
            return;
        }
        if (activitySetting != null) {
            activitySetting.setValue(this.toJSON(activityCounterDefinition));
        } else {
            Group group = this.groupLocalService.getGroup(groupId);
            long activitySettingId = this.counterLocalService.increment();
            activitySetting = this.socialActivitySettingPersistence.create(activitySettingId);
            activitySetting.setGroupId(groupId);
            activitySetting.setCompanyId(group.getCompanyId());
            activitySetting.setClassNameId(classNameId);
            activitySetting.setActivityType(activityType);
            activitySetting.setName(activityCounterDefinition.getName());
            activitySetting.setValue(this.toJSON(activityCounterDefinition));
        }
        this.socialActivitySettingPersistence.update((BaseModel)activitySetting, false);
        String key = this.encodeKey(groupId, className, activityType);
        _activityDefinitions.remove((Serializable)((Object)key));
    }

    public void updateActivitySettings(long groupId, String className, int activityType, List<SocialActivityCounterDefinition> activityCounterDefinitions) throws PortalException, SystemException {
        for (SocialActivityCounterDefinition activityCounterDefinition : activityCounterDefinitions) {
            this.updateActivitySetting(groupId, className, activityType, activityCounterDefinition);
        }
    }

    protected String encodeKey(long groupId, String className, int activityType) {
        StringBundler sb = new StringBundler(5);
        sb.append(groupId);
        sb.append("#");
        sb.append(className);
        sb.append("#");
        sb.append(activityType);
        return sb.toString();
    }

    protected SocialActivityDefinition getActivityDefinition(long groupId, String className, int activityType, SocialActivityDefinition defaultActivityDefinition) throws SystemException {
        SocialActivityDefinition activityDefinition = defaultActivityDefinition.clone();
        List<SocialActivitySetting> activitySettings = this.getActivitySettings(groupId, className, defaultActivityDefinition.getActivityType());
        for (SocialActivitySetting activitySetting : activitySettings) {
            String name = activitySetting.getName();
            if (name.equals("enabled")) {
                activityDefinition.setEnabled(GetterUtil.getBoolean((String)activitySetting.getValue(), (boolean)defaultActivityDefinition.isEnabled()));
                continue;
            }
            if (name.equals("logEnabled")) {
                activityDefinition.setLogActivity(GetterUtil.getBoolean((String)activitySetting.getValue(), (boolean)defaultActivityDefinition.isLogActivity()));
                continue;
            }
            JSONObject jsonObject = null;
            try {
                jsonObject = JSONFactoryUtil.createJSONObject((String)activitySetting.getValue());
            }
            catch (Exception exception) {
                jsonObject = JSONFactoryUtil.createJSONObject();
            }
            SocialActivityCounterDefinition activityCounterDefinition = activityDefinition.getActivityCounterDefinition(name);
            if (activityCounterDefinition == null) {
                activityCounterDefinition = new SocialActivityCounterDefinition();
                activityCounterDefinition.setName(name);
                activityDefinition.addCounter(activityCounterDefinition);
            }
            activityCounterDefinition.setEnabled(jsonObject.getBoolean("enabled"));
            activityCounterDefinition.setIncrement(jsonObject.getInt("value"));
            activityCounterDefinition.setLimitEnabled(jsonObject.getBoolean("limitEnabled"));
            activityCounterDefinition.setLimitPeriod(jsonObject.getInt("limitPeriod"));
            activityCounterDefinition.setLimitValue(jsonObject.getInt("limitValue"));
            activityCounterDefinition.setOwnerType(jsonObject.getInt("ownerType"));
        }
        return activityDefinition;
    }

    protected List<SocialActivitySetting> getActivitySettings(long groupId, String className, int activityType) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List activitySettings = this.socialActivitySettingPersistence.findByG_C_A(groupId, classNameId, activityType);
        return activitySettings;
    }

    protected String toJSON(SocialActivityCounterDefinition activityCounterDefinition) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("enabled", activityCounterDefinition.isEnabled());
        jsonObject.put("limitEnabled", activityCounterDefinition.isLimitEnabled());
        jsonObject.put("limitPeriod", activityCounterDefinition.getLimitPeriod());
        jsonObject.put("limitValue", activityCounterDefinition.getLimitValue());
        jsonObject.put("ownerType", activityCounterDefinition.getOwnerType());
        jsonObject.put("value", activityCounterDefinition.getIncrement());
        return jsonObject.toString();
    }
}

