/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.social.model.SocialActivityCounterDefinition;
import com.liferay.portlet.social.model.SocialActivityDefinition;
import com.liferay.portlet.social.service.base.SocialActivitySettingServiceBaseImpl;
import com.liferay.portlet.social.util.comparator.SocialActivityDefinitionNameComparator;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialActivitySettingServiceImpl
extends SocialActivitySettingServiceBaseImpl {
    public SocialActivityDefinition getActivityDefinition(long groupId, String className, int activityType) throws PortalException, SystemException {
        this.checkPermission(groupId);
        return this.socialActivitySettingLocalService.getActivityDefinition(groupId, className, activityType);
    }

    public List<SocialActivityDefinition> getActivityDefinitions(long groupId, String className) throws PortalException, SystemException {
        this.checkPermission(groupId);
        return this.socialActivitySettingLocalService.getActivityDefinitions(groupId, className);
    }

    public JSONArray getJSONActivityDefinitions(long groupId, String className) throws PortalException, SystemException {
        this.checkPermission(groupId);
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List activityDefinitions = this.socialActivitySettingLocalService.getActivityDefinitions(groupId, className);
        Collections.sort((List)activityDefinitions, (Comparator)new SocialActivityDefinitionNameComparator(LocaleUtil.getMostRelevantLocale()));
        for (SocialActivityDefinition activityDefinition : activityDefinitions) {
            JSONObject activityDefinitionJSONObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)activityDefinition));
            JSONArray activityCounterDefinitionsJSONArray = JSONFactoryUtil.createJSONArray();
            for (SocialActivityCounterDefinition activityCounterDefinition : activityDefinition.getActivityCounterDefinitions()) {
                JSONObject activityCounterDefinitionJSONObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)activityCounterDefinition));
                activityCounterDefinitionsJSONArray.put(activityCounterDefinitionJSONObject);
            }
            activityDefinitionJSONObject.put("counters", activityCounterDefinitionsJSONArray);
            jsonArray.put(activityDefinitionJSONObject);
        }
        return jsonArray;
    }

    public void updateActivitySetting(long groupId, String className, boolean enabled) throws PortalException, SystemException {
        this.checkPermission(groupId);
        this.socialActivitySettingLocalService.updateActivitySetting(groupId, className, enabled);
    }

    public void updateActivitySetting(long groupId, String className, int activityType, SocialActivityCounterDefinition activityCounterDefinition) throws PortalException, SystemException {
        this.checkPermission(groupId);
        this.socialActivitySettingLocalService.updateActivitySetting(groupId, className, activityType, activityCounterDefinition);
    }

    public void updateActivitySettings(long groupId, String className, int activityType, List<SocialActivityCounterDefinition> activityCounterDefinitions) throws PortalException, SystemException {
        this.checkPermission(groupId);
        this.socialActivitySettingLocalService.updateActivitySettings(groupId, className, activityType, activityCounterDefinitions);
    }

    protected void checkPermission(long groupId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isGroupAdmin(groupId) && !permissionChecker.isGroupOwner(groupId)) {
            throw new PrincipalException();
        }
    }
}

