/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.socialactivity.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.permission.comparator.ModelResourceComparator;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.social.model.SocialActivityCounterDefinition;
import com.liferay.portlet.social.model.SocialActivityDefinition;
import com.liferay.portlet.social.model.SocialActivitySetting;
import com.liferay.portlet.social.service.SocialActivitySettingLocalServiceUtil;
import com.liferay.portlet.social.service.SocialActivitySettingServiceUtil;
import com.liferay.portlet.social.util.SocialConfigurationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ViewAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (cmd.equals("update")) {
            this.updateActivitySettings(actionRequest);
        }
        this.sendRedirect(actionRequest, actionResponse);
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        LinkedHashMap<String, Boolean> activitySettingsMap = new LinkedHashMap<String, Boolean>();
        List activitySettings = SocialActivitySettingLocalServiceUtil.getActivitySettings((long)themeDisplay.getScopeGroupIdOrLiveGroupId());
        String[] modelNames = SocialConfigurationUtil.getActivityModelNames();
        ModelResourceComparator comparator = new ModelResourceComparator(themeDisplay.getLocale());
        Arrays.sort(modelNames, comparator);
        String[] stringArray = modelNames;
        int n = modelNames.length;
        int n2 = 0;
        while (n2 < n) {
            String modelName = stringArray[n2];
            activitySettingsMap.put(modelName, false);
            ++n2;
        }
        for (SocialActivitySetting activitySetting : activitySettings) {
            String name = activitySetting.getName();
            if (!name.equals("enabled") || !activitySettingsMap.containsKey(activitySetting.getClassName())) continue;
            activitySettingsMap.put(activitySetting.getClassName(), GetterUtil.getBoolean((String)activitySetting.getValue()));
        }
        renderRequest.setAttribute("SOCIAL_ACTIVITY_SETTINGS_MAP", activitySettingsMap);
        return mapping.findForward("portlet.social_activity.view");
    }

    protected SocialActivityCounterDefinition updateActivityCounterDefinition(JSONObject actionJSONObject, SocialActivityDefinition activityDefinition, String activityCounterName) {
        SocialActivityCounterDefinition activityCounterDefinition = activityDefinition.getActivityCounterDefinition(activityCounterName);
        if (activityCounterDefinition == null) {
            activityCounterDefinition = new SocialActivityCounterDefinition();
            activityCounterDefinition.setName(activityCounterName);
        }
        if (activityCounterName.equals("contribution")) {
            activityCounterDefinition.setOwnerType(3);
        } else if (activityCounterName.equals("participation")) {
            activityCounterDefinition.setOwnerType(1);
        } else if (activityCounterName.equals("popularity")) {
            activityCounterDefinition.setOwnerType(2);
            activityCounterName = "contribution";
        } else {
            throw new IllegalArgumentException();
        }
        activityCounterDefinition.setEnabled(actionJSONObject.getBoolean("active"));
        activityCounterDefinition.setIncrement(actionJSONObject.getInt(String.valueOf(activityCounterName) + "Increment"));
        activityCounterDefinition.setLimitPeriod(actionJSONObject.getInt(String.valueOf(activityCounterName) + "LimitPeriod"));
        activityCounterDefinition.setLimitValue(actionJSONObject.getInt(String.valueOf(activityCounterName) + "LimitValue"));
        return activityCounterDefinition;
    }

    protected void updateActivitySettings(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String settingsJSON = ParamUtil.getString((PortletRequest)actionRequest, (String)"settingsJSON");
        JSONObject settingsJSONObject = JSONFactoryUtil.createJSONObject((String)settingsJSON);
        JSONArray actionsJSONArray = settingsJSONObject.getJSONArray("actions");
        String modelName = settingsJSONObject.getString("modelName");
        int i2 = 0;
        while (i2 < actionsJSONArray.length()) {
            JSONObject actionJSONObject = actionsJSONArray.getJSONObject(i2);
            int activityType = actionJSONObject.getInt("activityType");
            SocialActivityDefinition activityDefinition = SocialActivitySettingLocalServiceUtil.getActivityDefinition((long)themeDisplay.getScopeGroupIdOrLiveGroupId(), (String)modelName, (int)activityType);
            if (activityDefinition != null) {
                ArrayList<SocialActivityCounterDefinition> activityCounterDefinitions = new ArrayList<SocialActivityCounterDefinition>();
                activityCounterDefinitions.add(this.updateActivityCounterDefinition(actionJSONObject, activityDefinition, "contribution"));
                activityCounterDefinitions.add(this.updateActivityCounterDefinition(actionJSONObject, activityDefinition, "participation"));
                activityCounterDefinitions.add(this.updateActivityCounterDefinition(actionJSONObject, activityDefinition, "popularity"));
                SocialActivitySettingServiceUtil.updateActivitySettings((long)themeDisplay.getScopeGroupIdOrLiveGroupId(), (String)modelName, (int)activityType, activityCounterDefinitions);
            }
            ++i2;
        }
    }
}

