/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.softwarecatalog.FrameworkVersionNameException;
import com.liferay.portlet.softwarecatalog.NoSuchFrameworkVersionException;
import com.liferay.portlet.softwarecatalog.action.ActionUtil;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.service.SCFrameworkVersionServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFrameworkVersionAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFrameworkVersion(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFrameworkVersion(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchFrameworkVersionException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.software_catalog.error");
            }
            if (e2 instanceof FrameworkVersionNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFrameworkVersion((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchFrameworkVersionException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.software_catalog.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.software_catalog.edit_framework_version"));
    }

    protected void deleteFrameworkVersion(ActionRequest actionRequest) throws Exception {
        long frameworkVersionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"frameworkVersionId");
        SCFrameworkVersionServiceUtil.deleteFrameworkVersion((long)frameworkVersionId);
    }

    protected void updateFrameworkVersion(ActionRequest actionRequest) throws Exception {
        long frameworkVersionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"frameworkVersionId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        int priority = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"priority");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)SCFrameworkVersion.class.getName(), (PortletRequest)actionRequest);
        if (frameworkVersionId <= 0L) {
            SCFrameworkVersionServiceUtil.addFrameworkVersion((String)name, (String)url, (boolean)active, (int)priority, (ServiceContext)serviceContext);
        } else {
            SCFrameworkVersionServiceUtil.updateFrameworkVersion((long)frameworkVersionId, (String)name, (String)url, (boolean)active, (int)priority);
        }
    }
}

