/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.softwarecatalog.DuplicateProductVersionDirectDownloadURLException;
import com.liferay.portlet.softwarecatalog.NoSuchProductVersionException;
import com.liferay.portlet.softwarecatalog.ProductVersionChangeLogException;
import com.liferay.portlet.softwarecatalog.ProductVersionDownloadURLException;
import com.liferay.portlet.softwarecatalog.ProductVersionFrameworkVersionException;
import com.liferay.portlet.softwarecatalog.ProductVersionNameException;
import com.liferay.portlet.softwarecatalog.UnavailableProductVersionDirectDownloadURLException;
import com.liferay.portlet.softwarecatalog.action.ActionUtil;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.service.SCProductVersionServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditProductVersionAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateProductVersion(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteProductVersion(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchProductVersionException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.software_catalog.error");
            }
            if (e2 instanceof DuplicateProductVersionDirectDownloadURLException || e2 instanceof ProductVersionChangeLogException || e2 instanceof ProductVersionDownloadURLException || e2 instanceof ProductVersionFrameworkVersionException || e2 instanceof ProductVersionNameException || e2 instanceof UnavailableProductVersionDirectDownloadURLException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getProductVersion((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchProductVersionException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.software_catalog.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.software_catalog.edit_product_version"));
    }

    protected void deleteProductVersion(ActionRequest actionRequest) throws Exception {
        long productVersionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"productVersionId");
        SCProductVersionServiceUtil.deleteProductVersion((long)productVersionId);
    }

    protected void updateProductVersion(ActionRequest actionRequest) throws Exception {
        long productVersionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"productVersionId");
        long productEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"productEntryId");
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        String changeLog = ParamUtil.getString((PortletRequest)actionRequest, (String)"changeLog");
        String downloadPageURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"downloadPageURL");
        String directDownloadURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"directDownloadURL");
        boolean testDirectDownloadURL = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"testDirectDownloadURL");
        boolean repoStoreArtifact = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"repoStoreArtifact");
        long[] frameworkVersionIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"frameworkVersions");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)SCProductVersion.class.getName(), (PortletRequest)actionRequest);
        if (productVersionId <= 0L) {
            SCProductVersionServiceUtil.addProductVersion((long)productEntryId, (String)version, (String)changeLog, (String)downloadPageURL, (String)directDownloadURL, (boolean)testDirectDownloadURL, (boolean)repoStoreArtifact, (long[])frameworkVersionIds, (ServiceContext)serviceContext);
        } else {
            SCProductVersionServiceUtil.updateProductVersion((long)productVersionId, (String)version, (String)changeLog, (String)downloadPageURL, (String)directDownloadURL, (boolean)testDirectDownloadURL, (boolean)repoStoreArtifact, (long[])frameworkVersionIds);
        }
    }
}

