/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.softwarecatalog.FrameworkVersionNameException;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.service.base.SCFrameworkVersionLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCFrameworkVersionLocalServiceImpl
extends SCFrameworkVersionLocalServiceBaseImpl {
    public SCFrameworkVersion addFrameworkVersion(long userId, String name, String url, boolean active, int priority, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date now = new Date();
        this.validate(name);
        long frameworkVersionId = this.counterLocalService.increment();
        SCFrameworkVersion frameworkVersion = this.scFrameworkVersionPersistence.create(frameworkVersionId);
        frameworkVersion.setGroupId(groupId);
        frameworkVersion.setCompanyId(user.getCompanyId());
        frameworkVersion.setUserId(user.getUserId());
        frameworkVersion.setUserName(user.getFullName());
        frameworkVersion.setCreateDate(now);
        frameworkVersion.setModifiedDate(now);
        frameworkVersion.setName(name);
        frameworkVersion.setUrl(url);
        frameworkVersion.setActive(active);
        frameworkVersion.setPriority(priority);
        this.scFrameworkVersionPersistence.update((BaseModel)frameworkVersion, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFrameworkVersionResources(frameworkVersion, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFrameworkVersionResources(frameworkVersion, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return frameworkVersion;
    }

    public void addFrameworkVersionResources(long frameworkVersionId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        SCFrameworkVersion frameworkVersion = this.scFrameworkVersionPersistence.findByPrimaryKey(frameworkVersionId);
        this.addFrameworkVersionResources(frameworkVersion, addGroupPermissions, addGuestPermissions);
    }

    public void addFrameworkVersionResources(long frameworkVersionId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        SCFrameworkVersion frameworkVersion = this.scFrameworkVersionPersistence.findByPrimaryKey(frameworkVersionId);
        this.addFrameworkVersionResources(frameworkVersion, groupPermissions, guestPermissions);
    }

    public void addFrameworkVersionResources(SCFrameworkVersion frameworkVersion, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(frameworkVersion.getCompanyId(), frameworkVersion.getGroupId(), frameworkVersion.getUserId(), SCFrameworkVersion.class.getName(), frameworkVersion.getFrameworkVersionId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addFrameworkVersionResources(SCFrameworkVersion frameworkVersion, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(frameworkVersion.getCompanyId(), frameworkVersion.getGroupId(), frameworkVersion.getUserId(), SCFrameworkVersion.class.getName(), frameworkVersion.getFrameworkVersionId(), groupPermissions, guestPermissions);
    }

    public void deleteFrameworkVersion(long frameworkVersionId) throws PortalException, SystemException {
        SCFrameworkVersion frameworkVersion = this.scFrameworkVersionPersistence.findByPrimaryKey(frameworkVersionId);
        this.deleteFrameworkVersion(frameworkVersion);
    }

    public void deleteFrameworkVersion(SCFrameworkVersion frameworkVersion) throws SystemException {
        this.scFrameworkVersionPersistence.remove((BaseModel)frameworkVersion);
    }

    public void deleteFrameworkVersions(long groupId) throws SystemException {
        List frameworkVersions = this.scFrameworkVersionPersistence.findByGroupId(groupId);
        for (SCFrameworkVersion frameworkVersion : frameworkVersions) {
            this.deleteFrameworkVersion(frameworkVersion);
        }
    }

    public SCFrameworkVersion getFrameworkVersion(long frameworkVersionId) throws PortalException, SystemException {
        return this.scFrameworkVersionPersistence.findByPrimaryKey(frameworkVersionId);
    }

    public List<SCFrameworkVersion> getFrameworkVersions(long groupId, boolean active) throws SystemException {
        return this.scFrameworkVersionPersistence.findByG_A(groupId, active);
    }

    public List<SCFrameworkVersion> getFrameworkVersions(long groupId, boolean active, int start, int end) throws SystemException {
        return this.scFrameworkVersionPersistence.findByG_A(groupId, active, start, end);
    }

    public List<SCFrameworkVersion> getFrameworkVersions(long groupId, int start, int end) throws SystemException {
        return this.scFrameworkVersionPersistence.findByGroupId(groupId, start, end);
    }

    public int getFrameworkVersionsCount(long groupId) throws SystemException {
        return this.scFrameworkVersionPersistence.countByGroupId(groupId);
    }

    public int getFrameworkVersionsCount(long groupId, boolean active) throws SystemException {
        return this.scFrameworkVersionPersistence.countByG_A(groupId, active);
    }

    public List<SCFrameworkVersion> getProductVersionFrameworkVersions(long productVersionId) throws SystemException {
        return this.scProductVersionPersistence.getSCFrameworkVersions(productVersionId);
    }

    public SCFrameworkVersion updateFrameworkVersion(long frameworkVersionId, String name, String url, boolean active, int priority) throws PortalException, SystemException {
        this.validate(name);
        SCFrameworkVersion frameworkVersion = this.scFrameworkVersionPersistence.findByPrimaryKey(frameworkVersionId);
        frameworkVersion.setName(name);
        frameworkVersion.setUrl(url);
        frameworkVersion.setActive(active);
        frameworkVersion.setPriority(priority);
        this.scFrameworkVersionPersistence.update((BaseModel)frameworkVersion, false);
        return frameworkVersion;
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new FrameworkVersionNameException();
        }
    }
}

