/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.softwarecatalog.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.model.SCProductVersion;
import com.liferay.portlet.softwarecatalog.service.SCProductEntryLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class SCIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{SCProductEntry.class.getName()};
    public static final String PORTLET_ID = "98";

    public SCIndexer() {
        this.setStagingAware(false);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long companyId) {
        Property property = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(property.eq((Object)companyId));
    }

    protected void doDelete(Object obj) throws Exception {
        SCProductEntry productEntry = (SCProductEntry)obj;
        this.deleteDocument(productEntry.getCompanyId(), productEntry.getProductEntryId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        SCProductEntry productEntry = (SCProductEntry)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)productEntry);
        StringBundler sb = new StringBundler(15);
        String longDescription = HtmlUtil.extractText((String)productEntry.getLongDescription());
        sb.append(longDescription);
        sb.append(" ");
        sb.append(productEntry.getPageURL());
        sb.append(" ");
        sb.append(productEntry.getRepoArtifactId());
        sb.append(" ");
        sb.append(productEntry.getRepoGroupId());
        sb.append(" ");
        String shortDescription = HtmlUtil.extractText((String)productEntry.getShortDescription());
        sb.append(shortDescription);
        sb.append(" ");
        sb.append(productEntry.getType());
        sb.append(" ");
        sb.append(productEntry.getUserId());
        sb.append(" ");
        String userName = PortalUtil.getUserName((long)productEntry.getUserId(), (String)productEntry.getUserName());
        sb.append(userName);
        document.addText("content", sb.toString());
        document.addText("title", productEntry.getName());
        document.addKeyword("type", productEntry.getType());
        String version = "";
        SCProductVersion latestProductVersion = productEntry.getLatestVersion();
        if (latestProductVersion != null) {
            version = latestProductVersion.getVersion();
        }
        document.addKeyword("version", version);
        document.addText("longDescription", longDescription);
        document.addText("pageURL", productEntry.getPageURL());
        document.addKeyword("repoArtifactId", productEntry.getRepoArtifactId());
        document.addKeyword("repoGroupId", productEntry.getRepoGroupId());
        document.addText("shortDescription", shortDescription);
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String productEntryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/software_catalog/view_product_entry");
        portletURL.setParameter("productEntryId", productEntryId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        SCProductEntry productEntry = (SCProductEntry)obj;
        Document document = this.getDocument(productEntry);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)productEntry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        SCProductEntry productEntry = SCProductEntryLocalServiceUtil.getProductEntry((long)classPK);
        this.doReindex(productEntry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexProductEntries(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        String type = (String)((Object)searchContext.getAttribute("type"));
        if (Validator.isNotNull((String)type)) {
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            searchQuery.addRequiredTerm("type", type);
            fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void reindexProductEntries(long companyId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(SCProductEntry.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minProductEntryIdProjection = ProjectionFactoryUtil.min((String)"productEntryId");
        Projection maxProductEntryIdProjection = ProjectionFactoryUtil.max((String)"productEntryId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minProductEntryIdProjection);
        projectionList.add(maxProductEntryIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, companyId);
        List results = SCProductEntryLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxProductEntryIds = (Object[])results.get(0);
        if (minAndMaxProductEntryIds[0] == null || minAndMaxProductEntryIds[1] == null) {
            return;
        }
        long minProductEntryId = (Long)minAndMaxProductEntryIds[0];
        long maxProductEntryId = (Long)minAndMaxProductEntryIds[1];
        long startProductEntryId = minProductEntryId;
        long endProductEntryId = startProductEntryId + 10000L;
        while (startProductEntryId <= maxProductEntryId) {
            this.reindexProductEntries(companyId, startProductEntryId, endProductEntryId);
            startProductEntryId = endProductEntryId;
            endProductEntryId += 10000L;
        }
    }

    protected void reindexProductEntries(long companyId, long startProductEntryId, long endProductEntryId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(SCProductEntry.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"productEntryId");
        dynamicQuery.add(property.ge((Object)startProductEntryId));
        dynamicQuery.add(property.lt((Object)endProductEntryId));
        this.addReindexCriteria(dynamicQuery, companyId);
        List productEntries = SCProductEntryLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        if (productEntries.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>(productEntries.size());
        for (SCProductEntry productEntry : productEntries) {
            Document document = this.getDocument(productEntry);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

