/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.translator.util;

import com.liferay.portal.kernel.microsofttranslator.MicrosoftTranslator;
import com.liferay.portal.kernel.microsofttranslator.MicrosoftTranslatorFactoryUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portlet.translator.model.Translation;

public class TranslationWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 7776000000L;
    private String _fromText;
    private String _translationId;

    public TranslationWebCacheItem(String translationId, String fromText) {
        this._translationId = translationId;
        this._fromText = fromText;
    }

    public Object convert(String key) throws WebCacheException {
        Translation translation = new Translation(this._translationId, this._fromText);
        try {
            MicrosoftTranslator microsoftTranslator = MicrosoftTranslatorFactoryUtil.getMicrosoftTranslator();
            int x = this._translationId.indexOf("_");
            if (x == -1 || x + 1 == this._translationId.length()) {
                throw new WebCacheException("Invalid translation ID " + this._translationId);
            }
            if (Character.isUpperCase(this._translationId.charAt(x + 1)) && ((x = this._translationId.indexOf("_", x + 1)) == -1 || x + 1 == this._translationId.length())) {
                throw new WebCacheException("Invalid translation ID " + this._translationId);
            }
            String fromLanguage = this._translationId.substring(0, x);
            String toLanguage = this._translationId.substring(x + 1);
            String toText = microsoftTranslator.translate(fromLanguage, toLanguage, this._fromText);
            translation.setToText(toText);
        }
        catch (Exception e2) {
            throw new WebCacheException((Throwable)e2);
        }
        return translation;
    }

    public long getRefreshTime() {
        return 7776000000L;
    }
}

