/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.action;

import com.liferay.portal.AddressCityException;
import com.liferay.portal.AddressStreetException;
import com.liferay.portal.AddressZipException;
import com.liferay.portal.DuplicateOrganizationException;
import com.liferay.portal.EmailAddressException;
import com.liferay.portal.NoSuchCountryException;
import com.liferay.portal.NoSuchListTypeException;
import com.liferay.portal.NoSuchOrganizationException;
import com.liferay.portal.NoSuchRegionException;
import com.liferay.portal.OrganizationNameException;
import com.liferay.portal.OrganizationParentException;
import com.liferay.portal.PhoneNumberException;
import com.liferay.portal.RequiredOrganizationException;
import com.liferay.portal.WebsiteURLException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.OrganizationServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import com.liferay.portlet.usersadmin.action.ActionUtil;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditOrganizationAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            Organization organization = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                organization = this.updateOrganization(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteOrganizations(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            if (organization != null) {
                redirect = HttpUtil.setParameter((String)redirect, (String)(String.valueOf(actionResponse.getNamespace()) + "organizationId"), (long)organization.getOrganizationId());
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchOrganizationException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.users_admin.error");
            }
            if (e2 instanceof AddressCityException || e2 instanceof AddressStreetException || e2 instanceof AddressZipException || e2 instanceof DuplicateOrganizationException || e2 instanceof EmailAddressException || e2 instanceof NoSuchCountryException || e2 instanceof NoSuchListTypeException || e2 instanceof NoSuchRegionException || e2 instanceof OrganizationNameException || e2 instanceof OrganizationParentException || e2 instanceof PhoneNumberException || e2 instanceof RequiredOrganizationException || e2 instanceof WebsiteURLException) {
                if (e2 instanceof NoSuchListTypeException) {
                    NoSuchListTypeException nslte = (NoSuchListTypeException)((Object)e2);
                    SessionErrors.add((PortletRequest)actionRequest, (String)(String.valueOf(e2.getClass().getName()) + nslte.getType()));
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                }
                if (e2 instanceof RequiredOrganizationException) {
                    String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                    long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
                    if (organizationId > 0L) {
                        redirect = HttpUtil.setParameter((String)redirect, (String)(String.valueOf(actionResponse.getNamespace()) + "organizationId"), (long)organizationId);
                    }
                    if (Validator.isNotNull((String)redirect)) {
                        actionResponse.sendRedirect(redirect);
                    }
                }
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getOrganization((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchOrganizationException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.users_admin.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.users_admin.edit_organization"));
    }

    protected void deleteOrganizations(ActionRequest actionRequest) throws Exception {
        long[] deleteOrganizationIds;
        long[] lArray = deleteOrganizationIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteOrganizationIds"), (long)0L);
        int n = deleteOrganizationIds.length;
        int n2 = 0;
        while (n2 < n) {
            long deleteOrganizationId = lArray[n2];
            OrganizationServiceUtil.deleteOrganization((long)deleteOrganizationId);
            ++n2;
        }
    }

    protected Organization updateOrganization(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long organizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"organizationId");
        long parentOrganizationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentOrganizationSearchContainerPrimaryKeys", (long)0L);
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        boolean recursable = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"recursable");
        int statusId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"statusId");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        long regionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"regionId");
        long countryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"countryId");
        String comments = ParamUtil.getString((PortletRequest)actionRequest, (String)"comments");
        boolean site = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"site");
        List addresses = UsersAdminUtil.getAddresses((ActionRequest)actionRequest);
        List emailAddresses = UsersAdminUtil.getEmailAddresses((ActionRequest)actionRequest);
        List orgLabors = UsersAdminUtil.getOrgLabors((ActionRequest)actionRequest);
        List phones = UsersAdminUtil.getPhones((ActionRequest)actionRequest);
        List websites = UsersAdminUtil.getWebsites((ActionRequest)actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Organization.class.getName(), (PortletRequest)actionRequest);
        Organization organization = null;
        if (organizationId <= 0L) {
            organization = OrganizationServiceUtil.addOrganization((long)parentOrganizationId, (String)name, (String)type, (boolean)recursable, (long)regionId, (long)countryId, (int)statusId, (String)comments, (boolean)site, (List)addresses, (List)emailAddresses, (List)orgLabors, (List)phones, (List)websites, (ServiceContext)serviceContext);
        } else {
            organization = OrganizationServiceUtil.updateOrganization((long)organizationId, (long)parentOrganizationId, (String)name, (String)type, (boolean)recursable, (long)regionId, (long)countryId, (int)statusId, (String)comments, (boolean)site, (List)addresses, (List)emailAddresses, (List)orgLabors, (List)phones, (List)websites, (ServiceContext)serviceContext);
            boolean deleteLogo = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"deleteLogo");
            if (deleteLogo) {
                OrganizationServiceUtil.deleteLogo((long)organization.getOrganizationId());
            }
        }
        long publicLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeId");
        long privateLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeId");
        boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeLinkEnabled", (publicLayoutSetPrototypeId > 0L ? 1 : 0) != 0);
        boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeLinkEnabled", (privateLayoutSetPrototypeId > 0L ? 1 : 0) != 0);
        Group organizationGroup = organization.getGroup();
        if (GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)organizationGroup.getGroupId(), (String)"UPDATE")) {
            SitesUtil.updateLayoutSetPrototypesLinks(organizationGroup, publicLayoutSetPrototypeId, privateLayoutSetPrototypeId, publicLayoutSetPrototypeLinkEnabled, privateLayoutSetPrototypeLinkEnabled);
        }
        String reminderQueries = actionRequest.getParameter("reminderQueries");
        PortletPreferences preferences = organization.getPreferences();
        LocalizationUtil.setLocalizedPreferencesValues((PortletRequest)actionRequest, (PortletPreferences)preferences, (String)"reminderQueries");
        preferences.setValue("reminderQueries", reminderQueries);
        preferences.store();
        return organization;
    }
}

