/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;

public class UserIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{User.class.getName()};
    public static final String PORTLET_ID = "125";
    private static final boolean _PERMISSION_AWARE = true;

    public UserIndexer() {
        this.setStagingAware(false);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean isIndexerEnabled() {
        return PropsValues.USERS_INDEXER_ENABLED;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        LinkedHashMap params;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
        if ((params = (LinkedHashMap)searchContext.getAttribute("params")) != null) {
            for (Map.Entry entry : params.entrySet()) {
                Object[] values;
                Class<?> clazz;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null || (clazz = value.getClass()).isArray() && (values = (Object[])value).length == 0) continue;
                this.addContextQueryParams(contextQuery, searchContext, key, value);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "city", false);
        this.addSearchTerm(searchQuery, searchContext, "country", false);
        this.addSearchTerm(searchQuery, searchContext, "emailAddress", false);
        this.addSearchTerm(searchQuery, searchContext, "firstName", false);
        this.addSearchTerm(searchQuery, searchContext, "fullName", false);
        this.addSearchTerm(searchQuery, searchContext, "lastName", false);
        this.addSearchTerm(searchQuery, searchContext, "middleName", false);
        this.addSearchTerm(searchQuery, searchContext, "region", false);
        this.addSearchTerm(searchQuery, searchContext, "screenName", false);
        this.addSearchTerm(searchQuery, searchContext, "street", false);
        this.addSearchTerm(searchQuery, searchContext, "zip", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void addContextQueryParams(BooleanQuery contextQuery, SearchContext searchContext, String key, Object value) throws Exception {
        if (key.equals("usersOrgs")) {
            if (value instanceof Long[]) {
                Long[] values = (Long[])value;
                BooleanQuery usersOrgsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
                Long[] longArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    long organizationId = longArray[n2];
                    usersOrgsQuery.addTerm("organizationIds", organizationId);
                    usersOrgsQuery.addTerm("ancestorOrganizationIds", organizationId);
                    ++n2;
                }
                contextQuery.add((Query)usersOrgsQuery, BooleanClauseOccur.MUST);
            } else {
                contextQuery.addRequiredTerm("organizationIds", String.valueOf(value));
            }
        } else if (key.equals("usersOrgsCount")) {
            contextQuery.addRequiredTerm("organizationCount", String.valueOf(value));
        } else if (key.equals("usersRoles")) {
            contextQuery.addRequiredTerm("roleIds", String.valueOf(value));
        } else if (key.equals("usersTeams")) {
            contextQuery.addRequiredTerm("teamIds", String.valueOf(value));
        } else if (key.equals("usersUserGroups")) {
            contextQuery.addRequiredTerm("userGroupIds", String.valueOf(value));
        }
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long companyId) {
        Property property = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(property.eq((Object)companyId));
    }

    protected void doDelete(Object obj) throws Exception {
        User user = (User)obj;
        this.deleteDocument(user.getCompanyId(), user.getUserId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        User user = (User)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)user);
        long[] organizationIds = user.getOrganizationIds();
        document.addKeyword("companyId", user.getCompanyId());
        document.addDate("modified", user.getModifiedDate());
        document.addKeyword("status", user.getStatus());
        document.addKeyword("userId", user.getUserId());
        document.addKeyword("userName", user.getFullName());
        document.addKeyword("ancestorOrganizationIds", this.getAncestorOrganizationIds(user.getUserId(), user.getOrganizationIds()));
        document.addText("emailAddress", user.getEmailAddress());
        document.addText("firstName", user.getFirstName());
        document.addText("fullName", user.getFullName());
        document.addKeyword("groupIds", user.getGroupIds());
        document.addText("jobTitle", user.getJobTitle());
        document.addText("lastName", user.getLastName());
        document.addText("middleName", user.getMiddleName());
        document.addKeyword("organizationIds", organizationIds);
        document.addKeyword("organizationCount", String.valueOf(organizationIds.length));
        document.addKeyword("roleIds", user.getRoleIds());
        document.addText("screenName", user.getScreenName());
        document.addKeyword("teamIds", user.getTeamIds());
        document.addKeyword("userGroupIds", user.getUserGroupIds());
        this.populateAddresses(document, user.getAddresses(), 0L, 0L);
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("email-address")) {
            return "emailAddress";
        }
        if (orderByCol.equals("first-name")) {
            return "firstName";
        }
        if (orderByCol.equals("job-title")) {
            return "jobTitle";
        }
        if (orderByCol.equals("last-name")) {
            return "lastName";
        }
        if (orderByCol.equals("screen-name")) {
            return "screenName";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String firstName = document.get("firstName");
        String middleName = document.get("middleName");
        String lastName = document.get("lastName");
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        String title = fullNameGenerator.getFullName(firstName, middleName, lastName);
        String content = null;
        String userId = document.get("userId");
        portletURL.setParameter("struts_action", "/users_admin/edit_user");
        portletURL.setParameter("p_u_i_d", userId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        if (obj instanceof List) {
            List users = (List)obj;
            for (User user : users) {
                this.doReindex(user);
            }
        } else if (obj instanceof Long) {
            long userId = (Long)obj;
            User user = UserLocalServiceUtil.getUserById((long)userId);
            this.doReindex(user);
        } else if (obj instanceof long[]) {
            long[] userIds = (long[])obj;
            HashMap<Long, ArrayList<Document>> documentsMap = new HashMap<Long, ArrayList<Document>>();
            long[] lArray = userIds;
            int n = userIds.length;
            int n2 = 0;
            while (n2 < n) {
                long userId = lArray[n2];
                User user = UserLocalServiceUtil.getUserById((long)userId);
                if (!user.isDefaultUser()) {
                    Document document = this.getDocument(user);
                    long companyId = user.getCompanyId();
                    ArrayList<Document> documents = (ArrayList<Document>)documentsMap.get(companyId);
                    if (documents == null) {
                        documents = new ArrayList<Document>();
                        documentsMap.put(companyId, documents);
                    }
                    documents.add(document);
                }
                ++n2;
            }
            for (Map.Entry entry : documentsMap.entrySet()) {
                long companyId = (Long)entry.getKey();
                Collection documents = (Collection)entry.getValue();
                SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, (Collection)documents);
            }
        } else if (obj instanceof User) {
            User user = (User)obj;
            if (user.isDefaultUser()) {
                return;
            }
            Document document = this.getDocument(user);
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)user.getCompanyId(), (Document)document);
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        User user = UserLocalServiceUtil.getUserById((long)classPK);
        this.doReindex(user);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexUsers(companyId);
    }

    protected long[] getAncestorOrganizationIds(long userId, long[] organizationIds) throws Exception {
        ArrayList ancestorOrganizations = new ArrayList();
        long[] lArray = organizationIds;
        int n = organizationIds.length;
        int n2 = 0;
        while (n2 < n) {
            long organizationId = lArray[n2];
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
            ancestorOrganizations.addAll(organization.getAncestors());
            ++n2;
        }
        long[] ancestorOrganizationIds = new long[ancestorOrganizations.size()];
        int i2 = 0;
        while (i2 < ancestorOrganizations.size()) {
            Organization ancestorOrganization = (Organization)ancestorOrganizations.get(i2);
            ancestorOrganizationIds[i2] = ancestorOrganization.getOrganizationId();
            ++i2;
        }
        return ancestorOrganizationIds;
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexUsers(long companyId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(User.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minUserIdProjection = ProjectionFactoryUtil.min((String)"userId");
        Projection maxUserIdProjection = ProjectionFactoryUtil.max((String)"userId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minUserIdProjection);
        projectionList.add(maxUserIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, companyId);
        List results = UserLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxUserIds = (Object[])results.get(0);
        if (minAndMaxUserIds[0] == null || minAndMaxUserIds[1] == null) {
            return;
        }
        long minUserId = (Long)minAndMaxUserIds[0];
        long maxUserId = (Long)minAndMaxUserIds[1];
        long startUserId = minUserId;
        long endUserId = startUserId + 10000L;
        while (startUserId <= maxUserId) {
            this.reindexUsers(companyId, startUserId, endUserId);
            startUserId = endUserId;
            endUserId += 10000L;
        }
    }

    protected void reindexUsers(long companyId, long startUserId, long endUserId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(User.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"userId");
        dynamicQuery.add(property.ge((Object)startUserId));
        dynamicQuery.add(property.lt((Object)endUserId));
        this.addReindexCriteria(dynamicQuery, companyId);
        List users = UserLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        if (users.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>(users.size());
        for (User user : users) {
            if (user.isDefaultUser()) continue;
            Document document = this.getDocument(user);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

