/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.TempFileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.action.EditFileEntryAction;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.action.ActionUtil;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditPageAttachmentAction
extends EditFileEntryAction {
    private static final String _TEMP_FOLDER_NAME = EditPageAttachmentAction.class.getName();

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (Validator.isNull((String)cmd)) {
                UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                if (uploadException != null) {
                    if (uploadException.isExceededSizeLimit()) {
                        throw new FileSizeException(uploadException.getCause());
                    }
                    throw new PortalException(uploadException.getCause());
                }
            } else if (cmd.equals("add")) {
                this.addAttachment(actionRequest);
            } else if (cmd.equals("add_multiple")) {
                this.addMultipleFileEntries(actionRequest, actionResponse);
            } else if (cmd.equals("add_temp")) {
                this.addTempAttachment(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteAttachment(actionRequest);
            } else if (cmd.equals("delete_temp")) {
                this.deleteTempAttachment(actionRequest, actionResponse);
            }
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
            } else {
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchNodeException || e2 instanceof NoSuchPageException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.wiki.error");
            }
            if (e2 instanceof DuplicateFileException || e2 instanceof FileNameException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e2.getClass().getName());
                HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                response.setStatus(492);
            }
            if (e2 instanceof FileSizeException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e2.getClass().getName());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getNode((PortletRequest)renderRequest);
            ActionUtil.getPage((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchNodeException || e2 instanceof NoSuchPageException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.wiki.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.wiki.edit_page_attachment"));
    }

    /*
     * Unable to fully structure code
     */
    protected void addAttachment(ActionRequest actionRequest) throws Exception {
        uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        numOfFiles = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"numOfFiles");
        inputStreamOVPs = new ArrayList<ObjectValuePair>();
        try {
            if (numOfFiles == 0) {
                fileName = uploadPortletRequest.getFileName("file");
                inputStream = uploadPortletRequest.getFileAsStream("file");
                if (inputStream != null) {
                    inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
                    inputStreamOVPs.add(inputStreamOVP);
                }
            } else {
                i = 1;
                while (i <= numOfFiles) {
                    fileName = uploadPortletRequest.getFileName("file" + i);
                    inputStream = uploadPortletRequest.getFileAsStream("file" + i);
                    if (inputStream != null) {
                        inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
                        inputStreamOVPs.add(inputStreamOVP);
                    }
                    ++i;
                }
            }
            WikiPageServiceUtil.addPageAttachments((long)nodeId, (String)title, inputStreamOVPs);
        }
        finally {
            ** for (inputStreamOVP : inputStreamOVPs)
        }
lbl-1000:
        // 1 sources

        {
            inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((InputStream)inputStream);
            continue;
        }
lbl32:
        // 1 sources

    }

    @Override
    protected void addMultipleFileEntries(ActionRequest actionRequest, ActionResponse actionResponse, String selectedFileName, List<String> validFileNames, List<KeyValuePair> invalidFileNameKVPs) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String tempFileName = TempFileUtil.getTempFileName((long)themeDisplay.getUserId(), (String)selectedFileName, (String)_TEMP_FOLDER_NAME);
        try {
            try {
                InputStream inputStream = TempFileUtil.getTempFileAsStream((String)tempFileName);
                WikiPageServiceUtil.addPageAttachment((long)nodeId, (String)title, (String)selectedFileName, (InputStream)inputStream);
                validFileNames.add(selectedFileName);
            }
            catch (Exception e2) {
                String errorMessage = this.getAddMultipleFileEntriesErrorMessage(themeDisplay, e2);
                KeyValuePair invalidFileNameKVP = new KeyValuePair(selectedFileName, errorMessage);
                invalidFileNameKVPs.add(invalidFileNameKVP);
                TempFileUtil.deleteTempFile((String)tempFileName);
            }
        }
        finally {
            TempFileUtil.deleteTempFile((String)tempFileName);
        }
    }

    protected void addTempAttachment(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String sourceFileName = uploadPortletRequest.getFileName("file");
        InputStream inputStream = null;
        try {
            inputStream = uploadPortletRequest.getFileAsStream("file");
            WikiPageServiceUtil.addTempPageAttachment((long)nodeId, (String)sourceFileName, (String)_TEMP_FOLDER_NAME, (InputStream)inputStream);
        }
        finally {
            StreamUtil.cleanUp((InputStream)inputStream);
        }
    }

    protected void deleteAttachment(ActionRequest actionRequest) throws Exception {
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String attachment = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        WikiPageServiceUtil.deletePageAttachment((long)nodeId, (String)title, (String)attachment);
    }

    protected void deleteTempAttachment(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            WikiPageServiceUtil.deleteTempPageAttachment((long)nodeId, (String)fileName, (String)_TEMP_FOLDER_NAME);
            jsonObject.put("deleted", Boolean.TRUE.booleanValue());
        }
        catch (Exception exception) {
            String errorMessage = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", Boolean.FALSE.booleanValue());
            jsonObject.put("errorMessage", errorMessage);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
    }
}

