/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.engines.antlrwiki.translator;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TreeNode;
import com.liferay.portal.parsers.creole.ast.CollectionNode;
import com.liferay.portal.parsers.creole.ast.HeadingNode;
import com.liferay.portal.parsers.creole.ast.ImageNode;
import com.liferay.portal.parsers.creole.ast.WikiPageNode;
import com.liferay.portal.parsers.creole.ast.extension.TableOfContentsNode;
import com.liferay.portal.parsers.creole.ast.link.LinkNode;
import com.liferay.portal.parsers.creole.visitor.impl.XhtmlTranslationVisitor;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.engines.antlrwiki.translator.TableOfContentsVisitor;
import com.liferay.portlet.wiki.engines.antlrwiki.translator.internal.UnformattedHeadingTextVisitor;
import com.liferay.portlet.wiki.engines.antlrwiki.translator.internal.UnformattedLinksTextVisitor;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.util.List;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XhtmlTranslator
extends XhtmlTranslationVisitor {
    private static final String _HEADING_ANCHOR_PREFIX = "section-";
    private static Log _log = LogFactoryUtil.getLog(XhtmlTranslator.class);
    private String _attachmentURLPrefix;
    private PortletURL _editPageURL;
    private WikiPageNode _rootWikiPageNode;
    private PortletURL _viewPageURL;
    private WikiPage _wikiPage;

    public String translate(WikiPage wikiPage, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix, WikiPageNode wikiPageNode) {
        this._wikiPage = wikiPage;
        this._viewPageURL = viewPageURL;
        this._editPageURL = editPageURL;
        this._attachmentURLPrefix = attachmentURLPrefix;
        this._rootWikiPageNode = wikiPageNode;
        return super.translate(wikiPageNode);
    }

    @Override
    public void visit(HeadingNode headingNode) {
        this.append("<h");
        this.append(headingNode.getLevel());
        String unformattedText = this.getUnformattedHeadingText(headingNode);
        String markup = this.getHeadingMarkup(this._wikiPage.getTitle(), unformattedText);
        this.append(" id=\"");
        this.append(markup);
        this.append("\">");
        this.traverse(headingNode.getChildASTNodes());
        this.append("<a class=\"hashlink\" href=\"");
        if (this._viewPageURL != null) {
            this.append(this._viewPageURL.toString());
        }
        this.append("#");
        this.append(markup);
        this.append("\">#</a></h");
        this.append(headingNode.getLevel());
        this.append(">");
    }

    @Override
    public void visit(ImageNode imageNode) {
        this.append("<img");
        if (imageNode.hasAltCollectionNode()) {
            this.append(" alt=\"");
            CollectionNode altCollectionNode = imageNode.getAltNode();
            this.traverse(altCollectionNode.getASTNodes());
            this.append("\"");
        }
        this.append(" src=\"");
        if (imageNode.isAbsoluteLink()) {
            this.append(imageNode.getLink());
        } else {
            this.append(this._attachmentURLPrefix);
            this.append(imageNode.getLink());
        }
        this.append("\" />");
    }

    @Override
    public void visit(LinkNode linkNode) {
        this.append("<a href=\"");
        this.appendHref(linkNode);
        this.append("\">");
        if (linkNode.hasAltCollectionNode()) {
            CollectionNode altCollectionNode = linkNode.getAltCollectionNode();
            this.traverse(altCollectionNode.getASTNodes());
        } else {
            this.append(HtmlUtil.escape((String)linkNode.getLink()));
        }
        this.append("</a>");
    }

    @Override
    public void visit(TableOfContentsNode tableOfContentsNode) {
        TableOfContentsVisitor tableOfContentsVisitor = new TableOfContentsVisitor();
        TreeNode<HeadingNode> tableOfContents = tableOfContentsVisitor.compose(this._rootWikiPageNode);
        this.append("<div class=\"toc\">");
        this.append("<div class=\"collapsebox\">");
        this.append("<h4>Table of Contents");
        this.append("&nbsp;");
        this.append("<a class=\"toc-trigger\" href=\"javascript:;\">[-]</a></h4>");
        this.append("<div class=\"toc-index\">");
        this.appendTableOfContents(tableOfContents, 1);
        this.append("</div>");
        this.append("</div>");
        this.append("</div>");
    }

    protected void appendAbsoluteHref(LinkNode linkNode) {
        this.append(HtmlUtil.escape((String)linkNode.getLink()));
    }

    protected void appendHref(LinkNode linkNode) {
        if (linkNode.getLink() == null) {
            UnformattedLinksTextVisitor unformattedLinksTextVisitor = new UnformattedLinksTextVisitor();
            linkNode.setLink(unformattedLinksTextVisitor.getUnformattedText(linkNode));
        }
        if (linkNode.isAbsoluteLink()) {
            this.appendAbsoluteHref(linkNode);
        } else {
            this.appendWikiHref(linkNode);
        }
    }

    protected void appendTableOfContents(TreeNode<HeadingNode> tableOfContents, int depth) {
        this.append("<ol>");
        List treeNodes = tableOfContents.getChildNodes();
        if (treeNodes != null) {
            for (TreeNode treeNode : treeNodes) {
                this.append("<li class=\"toc-level-");
                this.append(depth);
                this.append("\">");
                HeadingNode headingNode = (HeadingNode)treeNode.getValue();
                String content = this.getUnformattedHeadingText(headingNode);
                this.append("<a class=\"wikipage\" href=\"");
                if (this._viewPageURL != null) {
                    this.append(this._viewPageURL.toString());
                }
                this.append("#");
                this.append(this.getHeadingMarkup(this._wikiPage.getTitle(), content));
                this.append("\">");
                this.append(content);
                this.append("</a>");
                this.appendTableOfContents((TreeNode<HeadingNode>)treeNode, depth + 1);
                this.append("</li>");
            }
        }
        this.append("</ol>");
    }

    protected void appendWikiHref(LinkNode linkNode) {
        WikiPage page = null;
        try {
            page = WikiPageLocalServiceUtil.getPage((long)this._wikiPage.getNodeId(), (String)linkNode.getLink());
        }
        catch (NoSuchPageException noSuchPageException) {
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        String attachmentLink = this.searchLinkInAttachments(linkNode);
        if (attachmentLink != null) {
            this.append(String.valueOf(this._attachmentURLPrefix) + attachmentLink);
            return;
        }
        String pageTitle = linkNode.getLink();
        if (page != null && this._viewPageURL != null) {
            this._viewPageURL.setParameter("title", pageTitle);
            this.append(this._viewPageURL.toString());
            this._viewPageURL.setParameter("title", this._wikiPage.getTitle());
        } else if (this._editPageURL != null) {
            this._editPageURL.setParameter("title", pageTitle);
            this.append(this._editPageURL.toString());
            this._editPageURL.setParameter("title", this._wikiPage.getTitle());
        }
    }

    protected String getHeadingMarkup(String prefix, String text) {
        StringBundler sb = new StringBundler(5);
        sb.append(_HEADING_ANCHOR_PREFIX);
        sb.append(prefix);
        sb.append("-");
        sb.append(text.trim());
        return StringUtil.replace((String)sb.toString(), (String)" ", (String)"+");
    }

    protected String getUnformattedHeadingText(HeadingNode headingNode) {
        UnformattedHeadingTextVisitor unformattedHeadingTextVisitor = new UnformattedHeadingTextVisitor();
        return unformattedHeadingTextVisitor.getUnformattedText(headingNode);
    }

    protected String searchLinkInAttachments(LinkNode linkNode) {
        String[] attachments = null;
        try {
            attachments = this._wikiPage.getAttachmentsFiles();
        }
        catch (Exception exception) {
            return null;
        }
        String link = "/" + this._wikiPage.getAttachmentsDir() + "/" + linkNode.getLink();
        String[] stringArray = attachments;
        int n = attachments.length;
        int n2 = 0;
        while (n2 < n) {
            String attachment = stringArray[n2];
            if (attachment.equals(link)) {
                int pos = attachment.lastIndexOf("/");
                return attachment.substring(pos + 1);
            }
            ++n2;
        }
        return null;
    }
}

