/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.journal.lar.JournalPortletDataHandlerImpl;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.persistence.WikiNodeUtil;
import com.liferay.portlet.wiki.service.persistence.WikiPageUtil;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import com.liferay.portlet.wiki.util.comparator.PageVersionComparator;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class WikiPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "wiki";
    private static PortletDataHandlerControl[] _metadataControls = new PortletDataHandlerControl[]{new PortletDataHandlerBoolean("wiki", "attachments"), new PortletDataHandlerBoolean("wiki", "categories"), new PortletDataHandlerBoolean("wiki", "comments"), new PortletDataHandlerBoolean("wiki", "ratings"), new PortletDataHandlerBoolean("wiki", "tags")};
    private static PortletDataHandlerBoolean _nodesAndPages = new PortletDataHandlerBoolean("wiki", "wikis-and-pages", true, true);

    public static void exportNode(PortletDataContext portletDataContext, Element nodesElement, Element pagesElement, WikiNode node) throws Exception {
        String path;
        if (portletDataContext.isWithinDateRange(node.getModifiedDate()) && portletDataContext.isPathNotProcessed(path = WikiPortletDataHandlerImpl.getNodePath(portletDataContext, node))) {
            Element nodeElement = nodesElement.addElement("node");
            portletDataContext.addClassedModel(nodeElement, path, (ClassedModel)node, _NAMESPACE);
        }
        Element dlFileEntryTypesElement = pagesElement.addElement("dl-file-entry-types");
        Element dlFoldersElement = pagesElement.addElement("dl-folders");
        Element dlFileEntriesElement = pagesElement.addElement("dl-file-entries");
        Element dlFileRanksElement = pagesElement.addElement("dl-file-ranks");
        Element dlRepositoriesElement = pagesElement.addElement("dl-repositories");
        Element dlRepositoryEntriesElement = pagesElement.addElement("dl-repository-entries");
        List pages = WikiPageUtil.findByN_S((long)node.getNodeId(), (int)0, (int)-1, (int)-1, (OrderByComparator)new PageVersionComparator(true));
        for (WikiPage page : pages) {
            WikiPortletDataHandlerImpl.exportPage(portletDataContext, nodesElement, pagesElement, dlFileEntryTypesElement, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, dlRepositoriesElement, dlRepositoryEntriesElement, page, true);
        }
    }

    public static PortletDataHandlerControl[] getMetadataControls() {
        return _metadataControls;
    }

    public static void importNode(PortletDataContext portletDataContext, WikiNode node) throws Exception {
        long userId = portletDataContext.getUserId(node.getUserUuid());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(node.getCreateDate());
        serviceContext.setModifiedDate(node.getModifiedDate());
        serviceContext.setScopeGroupId(portletDataContext.getScopeGroupId());
        WikiNode importedNode = null;
        if (portletDataContext.isDataStrategyMirror()) {
            WikiNode existingNode = WikiNodeUtil.fetchByUUID_G((String)node.getUuid(), (long)portletDataContext.getScopeGroupId());
            String initialNodeName = PropsValues.WIKI_INITIAL_NODE_NAME;
            if (existingNode == null && initialNodeName.equals(node.getName())) {
                try {
                    WikiNodeUtil.removeByG_N((long)portletDataContext.getScopeGroupId(), (String)node.getName());
                }
                catch (NoSuchNodeException noSuchNodeException) {}
            }
            if (existingNode == null) {
                serviceContext.setUuid(node.getUuid());
                importedNode = WikiNodeLocalServiceUtil.addNode((long)userId, (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedNode = WikiNodeLocalServiceUtil.updateNode((long)existingNode.getNodeId(), (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            String initialNodeName = PropsValues.WIKI_INITIAL_NODE_NAME;
            if (initialNodeName.equals(node.getName())) {
                try {
                    WikiNodeUtil.removeByG_N((long)portletDataContext.getScopeGroupId(), (String)node.getName());
                }
                catch (NoSuchNodeException noSuchNodeException) {}
            }
            String nodeName = WikiPortletDataHandlerImpl.getNodeName(portletDataContext, node, node.getName(), 2);
            importedNode = WikiNodeLocalServiceUtil.addNode((long)userId, (String)nodeName, (String)node.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)node, (ClassedModel)importedNode, _NAMESPACE);
    }

    public static void importPage(PortletDataContext portletDataContext, Element pageElement, WikiPage page) throws Exception {
        long userId = portletDataContext.getUserId(page.getUserUuid());
        Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        long nodeId = MapUtil.getLong((Map)nodeIds, (long)page.getNodeId(), (long)page.getNodeId());
        String content = JournalPortletDataHandlerImpl.importReferencedContent(portletDataContext, pageElement, page.getContent());
        page.setContent(content);
        ServiceContext serviceContext = portletDataContext.createServiceContext(pageElement, (ClassedModel)page, _NAMESPACE);
        if (page.getStatus() != 0) {
            serviceContext.setWorkflowAction(2);
        }
        WikiPage importedPage = null;
        WikiPage existingPage = WikiPageUtil.fetchByUUID_G((String)page.getUuid(), (long)portletDataContext.getScopeGroupId());
        if (existingPage == null) {
            try {
                existingPage = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)page.getTitle());
            }
            catch (NoSuchPageException noSuchPageException) {}
        }
        if (existingPage == null) {
            serviceContext.setUuid(page.getUuid());
            importedPage = WikiPageLocalServiceUtil.addPage((long)userId, (long)nodeId, (String)page.getTitle(), (double)page.getVersion(), (String)page.getContent(), (String)page.getSummary(), (boolean)page.isMinorEdit(), (String)page.getFormat(), (boolean)page.getHead(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
        } else {
            importedPage = WikiPageLocalServiceUtil.updatePage((long)userId, (long)nodeId, (String)existingPage.getTitle(), (double)0.0, (String)page.getContent(), (String)page.getSummary(), (boolean)page.isMinorEdit(), (String)page.getFormat(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "attachments") && page.isHead()) {
            for (Element attachmentElement : pageElement.elements("attachment")) {
                String name = attachmentElement.attributeValue("name");
                String binPath = attachmentElement.attributeValue("bin-path");
                InputStream inputStream = null;
                try {
                    inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
                    WikiPageLocalServiceUtil.addPageAttachment((long)importedPage.getCompanyId(), (String)importedPage.getAttachmentsDir(), (Date)importedPage.getModifiedDate(), (String)name, (InputStream)inputStream);
                }
                finally {
                    StreamUtil.cleanUp((InputStream)inputStream);
                }
            }
        }
        portletDataContext.importClassedModel((ClassedModel)page, (ClassedModel)importedPage, _NAMESPACE);
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages};
    }

    public PortletDataHandlerControl[] getExportMetadataControls() {
        return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(_NAMESPACE, "wiki-pages", true, _metadataControls)};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages};
    }

    public PortletDataHandlerControl[] getImportMetadataControls() {
        return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(_NAMESPACE, "wiki-pages", true, _metadataControls)};
    }

    public PortletPreferences importData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws PortletDataException {
        WikiCacheThreadLocal.setClearCache(false);
        try {
            PortletPreferences portletPreferences2 = super.importData(portletDataContext, portletId, portletPreferences, data);
            return portletPreferences2;
        }
        finally {
            WikiCacheThreadLocal.setClearCache(true);
        }
    }

    protected static void exportNode(PortletDataContext portletDataContext, Element nodesElement, long nodeId) throws Exception {
        if (!portletDataContext.hasDateRange()) {
            return;
        }
        WikiNode node = WikiNodeUtil.findByPrimaryKey((long)nodeId);
        String path = WikiPortletDataHandlerImpl.getNodePath(portletDataContext, node);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element nodeElement = nodesElement.addElement("node");
        portletDataContext.addClassedModel(nodeElement, path, (ClassedModel)node, _NAMESPACE);
    }

    protected static void exportPage(PortletDataContext portletDataContext, Element nodesElement, Element pagesElement, Element dlFileEntryTypesElement, Element dlFoldersElement, Element dlFileEntriesElement, Element dlFileRanksElement, Element dlRepositoriesElement, Element dlRepositoryEntriesElement, WikiPage page, boolean checkDateRange) throws Exception {
        if (!portletDataContext.isWithinDateRange(page.getModifiedDate())) {
            return;
        }
        String path = WikiPortletDataHandlerImpl.getPagePath(portletDataContext, page);
        page = (WikiPage)page.clone();
        Element pageElement = (Element)pagesElement.selectSingleNode("//page[@path='".concat(path).concat("']"));
        if (portletDataContext.isPathNotProcessed(path)) {
            if (pageElement == null) {
                pageElement = pagesElement.addElement("page");
            }
            String content = JournalPortletDataHandlerImpl.exportReferencedContent(portletDataContext, dlFileEntryTypesElement, dlFoldersElement, dlFileEntriesElement, dlFileRanksElement, dlRepositoriesElement, dlRepositoryEntriesElement, pageElement, page.getContent());
            page.setContent(content);
            String imagePath = WikiPortletDataHandlerImpl.getPageImagePath(portletDataContext, page);
            pageElement.addAttribute("image-path", imagePath);
            if (portletDataContext.getBooleanParameter(_NAMESPACE, "attachments") && page.isHead()) {
                String[] attachmentsFiles = page.getAttachmentsFiles();
                int i2 = 0;
                while (i2 < attachmentsFiles.length) {
                    String attachment = attachmentsFiles[i2];
                    Element attachmentElement = pageElement.addElement("attachment");
                    int pos = attachment.lastIndexOf("/");
                    String name = attachment.substring(pos + 1);
                    attachmentElement.addAttribute("name", name);
                    String binPath = WikiPortletDataHandlerImpl.getPageAttachementBinPath(portletDataContext, page, i2);
                    attachmentElement.addAttribute("bin-path", binPath);
                    byte[] bytes = DLStoreUtil.getFileAsBytes((long)portletDataContext.getCompanyId(), (long)0L, (String)attachment);
                    portletDataContext.addZipEntry(binPath, bytes);
                    ++i2;
                }
                page.setAttachmentsDir(page.getAttachmentsDir());
            }
            portletDataContext.addClassedModel(pageElement, path, (ClassedModel)page, _NAMESPACE);
        }
        WikiPortletDataHandlerImpl.exportNode(portletDataContext, nodesElement, page.getNodeId());
    }

    protected static String getNodeName(PortletDataContext portletDataContext, WikiNode node, String name, int count) throws Exception {
        WikiNode existingNode = WikiNodeUtil.fetchByG_N((long)portletDataContext.getScopeGroupId(), (String)name);
        if (existingNode == null) {
            return name;
        }
        String nodeName = node.getName();
        return WikiPortletDataHandlerImpl.getNodeName(portletDataContext, node, nodeName.concat(" ").concat(String.valueOf(count)), ++count);
    }

    protected static String getNodePath(PortletDataContext portletDataContext, WikiNode node) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("36"));
        sb.append("/nodes/");
        sb.append(node.getNodeId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getPageAttachementBinPath(PortletDataContext portletDataContext, WikiPage page, int count) {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getPortletPath("36"));
        sb.append("/bin/");
        sb.append(page.getPageId());
        sb.append("/");
        sb.append("attachement");
        sb.append(count);
        return sb.toString();
    }

    protected static String getPageImagePath(PortletDataContext portletDataContext, WikiPage page) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getPortletPath("36"));
        sb.append("/page/");
        sb.append(page.getUuid());
        sb.append("/");
        sb.append(page.getVersion());
        sb.append("/");
        return sb.toString();
    }

    protected static String getPagePath(PortletDataContext portletDataContext, WikiPage page) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("36"));
        sb.append("/pages/");
        sb.append(page.getPageId());
        sb.append(".xml");
        return sb.toString();
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(WikiPortletDataHandlerImpl.class, "deleteData")) {
            WikiNodeLocalServiceUtil.deleteNodes((long)portletDataContext.getScopeGroupId());
        }
        return null;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.wiki", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("wiki-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        Element nodesElement = rootElement.addElement("nodes");
        Element pagesElement = rootElement.addElement("pages");
        List nodes = WikiNodeUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (WikiNode node : nodes) {
            WikiPortletDataHandlerImpl.exportNode(portletDataContext, nodesElement, pagesElement, node);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.wiki", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element nodesElement = rootElement.element("nodes");
        for (Element nodeElement : nodesElement.elements("node")) {
            String path = nodeElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            WikiNode node = (WikiNode)portletDataContext.getZipEntryAsObject(path);
            WikiPortletDataHandlerImpl.importNode(portletDataContext, node);
        }
        Element pagesElement = rootElement.element("pages");
        JournalPortletDataHandlerImpl.importReferencedData(portletDataContext, pagesElement);
        for (Element pageElement : pagesElement.elements("page")) {
            String path = pageElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            WikiPage page = (WikiPage)portletDataContext.getZipEntryAsObject(path);
            WikiPortletDataHandlerImpl.importPage(portletDataContext, pageElement, page);
        }
        Map nodeIds = portletDataContext.getNewPrimaryKeysMap(WikiNode.class);
        Iterator iterator = nodeIds.values().iterator();
        while (iterator.hasNext()) {
            long nodeId = (Long)iterator.next();
            WikiCacheUtil.clearCache(nodeId);
        }
        return null;
    }
}

