/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageSoap;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(WikiPageServiceSoap.class);

    public static WikiPageSoap addPage(long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.addPage((long)nodeId, (String)title, (String)content, (String)summary, (boolean)minorEdit, (ServiceContext)serviceContext);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static WikiPageSoap addPage(long nodeId, String title, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.addPage((long)nodeId, (String)title, (String)content, (String)summary, (boolean)minorEdit, (String)format, (String)parentTitle, (String)redirectTitle, (ServiceContext)serviceContext);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void addPageAttachments(long nodeId, String title, List<ObjectValuePair<String, InputStream>> inputStream) throws RemoteException {
        try {
            WikiPageServiceUtil.addPageAttachments((long)nodeId, (String)title, inputStream);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void changeParent(long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPageServiceUtil.changeParent((long)nodeId, (String)title, (String)newParentTitle, (ServiceContext)serviceContext);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void deletePage(long nodeId, String title) throws RemoteException {
        try {
            WikiPageServiceUtil.deletePage((long)nodeId, (String)title);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void deletePage(long nodeId, String title, double version) throws RemoteException {
        try {
            WikiPageServiceUtil.deletePage((long)nodeId, (String)title, (double)version);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void deletePageAttachment(long nodeId, String title, String fileName) throws RemoteException {
        try {
            WikiPageServiceUtil.deletePageAttachment((long)nodeId, (String)title, (String)fileName);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void deleteTempPageAttachment(long nodeId, String fileName, String tempFolderName) throws RemoteException {
        try {
            WikiPageServiceUtil.deleteTempPageAttachment((long)nodeId, (String)fileName, (String)tempFolderName);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static WikiPageSoap getDraftPage(long nodeId, String title) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.getDraftPage((long)nodeId, (String)title);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static WikiPageSoap[] getNodePages(long nodeId, int max) throws RemoteException {
        try {
            List returnValue = WikiPageServiceUtil.getNodePages((long)nodeId, (int)max);
            return WikiPageSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static String getNodePagesRSS(long nodeId, int max, String type, double version, String displayStyle, String feedURL, String entryURL) throws RemoteException {
        try {
            String returnValue = WikiPageServiceUtil.getNodePagesRSS((long)nodeId, (int)max, (String)type, (double)version, (String)displayStyle, (String)feedURL, (String)entryURL);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static WikiPageSoap getPage(long nodeId, String title) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.getPage((long)nodeId, (String)title);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static WikiPageSoap getPage(long nodeId, String title, Boolean head) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (Boolean)head);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static WikiPageSoap getPage(long nodeId, String title, double version) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)version);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static String getPagesRSS(long companyId, long nodeId, String title, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String locale) throws RemoteException {
        try {
            String returnValue = WikiPageServiceUtil.getPagesRSS((long)companyId, (long)nodeId, (String)title, (int)max, (String)type, (double)version, (String)displayStyle, (String)feedURL, (String)entryURL, (Locale)LocaleUtil.fromLanguageId((String)locale));
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static String[] getTempPageAttachmentNames(long nodeId, String tempFolderName) throws RemoteException {
        try {
            String[] returnValue = WikiPageServiceUtil.getTempPageAttachmentNames((long)nodeId, (String)tempFolderName);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void movePage(long nodeId, String title, String newTitle, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPageServiceUtil.movePage((long)nodeId, (String)title, (String)newTitle, (ServiceContext)serviceContext);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static WikiPageSoap revertPage(long nodeId, String title, double version, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.revertPage((long)nodeId, (String)title, (double)version, (ServiceContext)serviceContext);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void subscribePage(long nodeId, String title) throws RemoteException {
        try {
            WikiPageServiceUtil.subscribePage((long)nodeId, (String)title);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void unsubscribePage(long nodeId, String title) throws RemoteException {
        try {
            WikiPageServiceUtil.unsubscribePage((long)nodeId, (String)title);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static WikiPageSoap updatePage(long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiPage returnValue = WikiPageServiceUtil.updatePage((long)nodeId, (String)title, (double)version, (String)content, (String)summary, (boolean)minorEdit, (String)format, (String)parentTitle, (String)redirectTitle, (ServiceContext)serviceContext);
            return WikiPageSoap.toSoapModel((WikiPage)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }
}

