/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.documentlibrary.DuplicateDirectoryException;
import com.liferay.portlet.documentlibrary.NoSuchDirectoryException;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.wiki.DuplicatePageException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.NoSuchPageResourceException;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.PageTitleException;
import com.liferay.portlet.wiki.PageVersionException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageConstants;
import com.liferay.portlet.wiki.model.WikiPageDisplay;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.model.impl.WikiPageDisplayImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.portlet.wiki.service.base.WikiPageLocalServiceBaseImpl;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import com.liferay.portlet.wiki.util.comparator.PageCreateDateComparator;
import com.liferay.portlet.wiki.util.comparator.PageVersionComparator;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageLocalServiceImpl
extends WikiPageLocalServiceBaseImpl {
    public WikiPage addPage(long userId, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, boolean head, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        Date now = new Date();
        long pageId = this.counterLocalService.increment();
        content = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)node.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)pageId, (String)("text/" + format), (String)content);
        this.validate(title, nodeId, content, format);
        long resourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(nodeId, title);
        WikiPage page = this.wikiPagePersistence.create(pageId);
        page.setUuid(serviceContext.getUuid());
        page.setResourcePrimKey(resourcePrimKey);
        page.setGroupId(node.getGroupId());
        page.setCompanyId(user.getCompanyId());
        page.setUserId(user.getUserId());
        page.setUserName(user.getFullName());
        page.setCreateDate(serviceContext.getCreateDate(now));
        page.setModifiedDate(serviceContext.getModifiedDate(now));
        page.setNodeId(nodeId);
        page.setTitle(title);
        page.setVersion(version);
        page.setMinorEdit(minorEdit);
        page.setContent(content);
        page.setStatus(2);
        page.setSummary(summary);
        page.setFormat(format);
        page.setHead(head);
        page.setParentTitle(parentTitle);
        page.setRedirectTitle(redirectTitle);
        this.wikiPagePersistence.update((BaseModel)page, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addPageResources(page, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addPageResources(page, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        node.setLastPostDate(serviceContext.getModifiedDate(now));
        this.wikiNodePersistence.update((BaseModel)node, false);
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        ExpandoBridge expandoBridge = page.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        if (PropsValues.WIKI_PAGE_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, page.getUserName(), page.getGroupId(), WikiPage.class.getName(), resourcePrimKey, 1);
        }
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)page.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)page.getPageId(), (Object)page, (ServiceContext)serviceContext);
        return page;
    }

    public WikiPage addPage(long userId, long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException, SystemException {
        double version = 1.0;
        String format = WikiPageConstants.DEFAULT_FORMAT;
        boolean head = false;
        String parentTitle = null;
        String redirectTitle = null;
        return this.addPage(userId, nodeId, title, version, content, summary, minorEdit, format, head, parentTitle, redirectTitle, serviceContext);
    }

    public void addPageAttachment(long userId, long nodeId, String title, String fileName, File file) throws PortalException, SystemException {
        if (Validator.isNull((String)fileName)) {
            return;
        }
        WikiPage page = this.getPage(nodeId, title);
        if (userId == 0L) {
            userId = page.getUserId();
        }
        this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 10006, String.valueOf(page.getAttachmentsDir()) + "/" + fileName, 0L);
        try {
            DLStoreUtil.addDirectory((long)page.getCompanyId(), (long)0L, (String)page.getAttachmentsDir());
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        DLStoreUtil.addFile((long)page.getCompanyId(), (long)0L, (String)(String.valueOf(page.getAttachmentsDir()) + "/" + fileName), (File)file);
    }

    public void addPageAttachment(long userId, long nodeId, String title, String fileName, InputStream inputStream) throws PortalException, SystemException {
        if (Validator.isNull((String)fileName)) {
            return;
        }
        WikiPage page = this.getPage(nodeId, title);
        if (userId == 0L) {
            userId = page.getUserId();
        }
        this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 10006, String.valueOf(page.getAttachmentsDir()) + "/" + fileName, 0L);
        try {
            DLStoreUtil.addDirectory((long)page.getCompanyId(), (long)0L, (String)page.getAttachmentsDir());
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        DLStoreUtil.addFile((long)page.getCompanyId(), (long)0L, (String)(String.valueOf(page.getAttachmentsDir()) + "/" + fileName), (InputStream)inputStream);
    }

    public void addPageAttachment(long companyId, String dirName, Date modifiedDate, String fileName, InputStream inputStream) throws PortalException, SystemException {
        if (inputStream == null) {
            return;
        }
        long repositoryId = 0L;
        try {
            DLStoreUtil.addDirectory((long)companyId, (long)repositoryId, (String)dirName);
        }
        catch (DuplicateDirectoryException duplicateDirectoryException) {}
        DLStoreUtil.addFile((long)companyId, (long)repositoryId, (String)(String.valueOf(dirName) + "/" + fileName), (boolean)false, (InputStream)inputStream);
    }

    public void addPageAttachments(long userId, long nodeId, String title, List<ObjectValuePair<String, InputStream>> inputStreams) throws PortalException, SystemException {
        if (inputStreams.size() == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < inputStreams.size()) {
            ObjectValuePair<String, InputStream> ovp = inputStreams.get(i2);
            String fileName = (String)ovp.getKey();
            InputStream inputStream = (InputStream)ovp.getValue();
            this.addPageAttachment(userId, nodeId, title, fileName, inputStream);
            ++i2;
        }
    }

    public void addPageResources(long nodeId, String title, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.addPageResources(page, addGroupPermissions, addGuestPermissions);
    }

    public void addPageResources(long nodeId, String title, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.addPageResources(page, groupPermissions, guestPermissions);
    }

    public void addPageResources(WikiPage page, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addPageResources(WikiPage page, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public String addTempPageAttachment(long userId, String fileName, String tempFolderName, InputStream inputStream) throws PortalException, SystemException {
        return TempFileUtil.addTempFile((long)userId, (String)fileName, (String)tempFolderName, (InputStream)inputStream);
    }

    public void changeParent(long userId, long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPage parentPage;
        if (Validator.isNotNull((String)newParentTitle) && Validator.isNotNull((String)(parentPage = this.getPage(nodeId, newParentTitle)).getRedirectTitle())) {
            newParentTitle = parentPage.getRedirectTitle();
        }
        WikiPage page = this.getPage(nodeId, title);
        String originalParentTitle = page.getParentTitle();
        double version = page.getVersion();
        String content = page.getContent();
        String summary = serviceContext.translate("changed-parent-from-x", new Object[]{originalParentTitle});
        boolean minorEdit = false;
        String format = page.getFormat();
        String redirectTitle = page.getRedirectTitle();
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(WikiPage.class.getName(), page.getResourcePrimKey());
        String[] assetTagNames = this.assetTagLocalService.getTagNames(WikiPage.class.getName(), page.getResourcePrimKey());
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetLinkEntryIds(null);
        serviceContext.setAssetTagNames(assetTagNames);
        this.updatePage(userId, nodeId, title, version, content, summary, minorEdit, format, newParentTitle, redirectTitle, serviceContext);
        List oldPages = this.wikiPagePersistence.findByN_T_H(nodeId, title, false);
        for (WikiPage oldPage : oldPages) {
            oldPage.setParentTitle(originalParentTitle);
            this.wikiPagePersistence.update((BaseModel)oldPage, false);
        }
    }

    public void deletePage(long nodeId, String title) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByN_T_H(nodeId, title, true, 0, 1);
        if (!pages.isEmpty()) {
            WikiPage page = (WikiPage)pages.iterator().next();
            this.deletePage(page);
        }
    }

    public void deletePage(long nodeId, String title, double version) throws PortalException, SystemException {
        this.wikiPagePersistence.removeByN_T_V(nodeId, title, version);
    }

    public void deletePage(WikiPage page) throws PortalException, SystemException {
        List children = this.wikiPagePersistence.findByN_H_P(page.getNodeId(), true, page.getTitle());
        for (WikiPage curPage : children) {
            this.deletePage(curPage);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
        indexer.delete((Object)page);
        long companyId = page.getCompanyId();
        long repositoryId = 0L;
        String dirName = page.getAttachmentsDir();
        try {
            DLStoreUtil.deleteDirectory((long)companyId, (long)repositoryId, (String)dirName);
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {}
        this.subscriptionLocalService.deleteSubscriptions(page.getCompanyId(), WikiPage.class.getName(), page.getResourcePrimKey());
        this.mbMessageLocalService.deleteDiscussionMessages(WikiPage.class.getName(), page.getResourcePrimKey());
        this.expandoValueLocalService.deleteValues(WikiPage.class.getName(), page.getResourcePrimKey());
        List pageVersions = this.wikiPagePersistence.findByN_T(page.getNodeId(), page.getTitle());
        for (WikiPage pageVersion : pageVersions) {
            this.assetEntryLocalService.deleteEntry(WikiPage.class.getName(), pageVersion.getPrimaryKey());
        }
        this.assetEntryLocalService.deleteEntry(WikiPage.class.getName(), page.getResourcePrimKey());
        this.resourceLocalService.deleteResource(page.getCompanyId(), WikiPage.class.getName(), 4, page.getResourcePrimKey());
        try {
            this.wikiPageResourceLocalService.deletePageResource(page.getNodeId(), page.getTitle());
        }
        catch (NoSuchPageResourceException noSuchPageResourceException) {}
        List pages = this.wikiPagePersistence.findByN_T(page.getNodeId(), page.getTitle());
        for (WikiPage curPage : pages) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(curPage.getCompanyId(), curPage.getGroupId(), WikiPage.class.getName(), curPage.getPageId());
        }
        this.wikiPagePersistence.removeByN_T(page.getNodeId(), page.getTitle());
        this.wikiPagePersistence.removeByN_R(page.getNodeId(), page.getTitle());
        this.clearPageCache(page);
    }

    public void deletePageAttachment(long nodeId, String title, String fileName) throws PortalException, SystemException {
        if (Validator.isNull((String)fileName)) {
            return;
        }
        WikiPage page = this.getPage(nodeId, title);
        long companyId = page.getCompanyId();
        long repositoryId = 0L;
        try {
            DLStoreUtil.deleteFile((long)companyId, (long)repositoryId, (String)fileName);
        }
        catch (NoSuchFileException noSuchFileException) {}
    }

    public void deletePages(long nodeId) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByN_H_P(nodeId, true, "");
        for (WikiPage page : pages) {
            this.deletePage(page);
        }
        pages = this.wikiPagePersistence.findByN_H_P(nodeId, false, "");
        for (WikiPage page : pages) {
            this.deletePage(page);
        }
    }

    public void deleteTempPageAttachment(long userId, String fileName, String tempFolderName) throws PortalException, SystemException {
        TempFileUtil.deleteTempFile((long)userId, (String)fileName, (String)tempFolderName);
    }

    public List<WikiPage> getChildren(long nodeId, boolean head, String parentTitle) throws SystemException {
        return this.wikiPagePersistence.findByN_H_P_S(nodeId, head, parentTitle, 0);
    }

    public WikiPage getDraftPage(long nodeId, String title) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByN_T_S(nodeId, title, 2, 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        pages = this.wikiPagePersistence.findByN_T_S(nodeId, title, 1, 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        throw new NoSuchPageException();
    }

    public List<WikiPage> getIncomingLinks(long nodeId, String title) throws PortalException, SystemException {
        UniqueList links = new UniqueList();
        List pages = this.wikiPagePersistence.findByN_H(nodeId, true);
        for (WikiPage page : pages) {
            if (!this.isLinkedTo(page, title)) continue;
            links.add(page);
        }
        List referrals = this.wikiPagePersistence.findByN_R(nodeId, title);
        for (WikiPage referral : referrals) {
            for (WikiPage page : pages) {
                if (!this.isLinkedTo(page, referral.getTitle())) continue;
                links.add(page);
            }
        }
        return ListUtil.sort((List)links);
    }

    public List<WikiPage> getNoAssetPages() throws SystemException {
        return this.wikiPageFinder.findByNoAssets();
    }

    public List<WikiPage> getOrphans(long nodeId) throws PortalException, SystemException {
        ArrayList<Map<String, Boolean>> pageTitles = new ArrayList<Map<String, Boolean>>();
        List pages = this.wikiPagePersistence.findByN_H_S(nodeId, true, 0);
        for (WikiPage page : pages) {
            pageTitles.add(WikiCacheUtil.getOutgoingLinks(page));
        }
        HashSet<WikiPage> notOrphans = new HashSet<WikiPage>();
        block1: for (WikiPage page : pages) {
            for (Map map : pageTitles) {
                if (map.get(page.getTitle().toLowerCase()) == null) continue;
                notOrphans.add(page);
                continue block1;
            }
        }
        ArrayList<WikiPage> orphans = new ArrayList();
        for (WikiPage page : pages) {
            if (notOrphans.contains(page)) continue;
            orphans.add(page);
        }
        orphans = ListUtil.sort(orphans);
        return orphans;
    }

    public List<WikiPage> getOutgoingLinks(long nodeId, String title) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        LinkedHashMap<String, WikiPage> pages = new LinkedHashMap<String, WikiPage>();
        Map<String, Boolean> links = WikiCacheUtil.getOutgoingLinks(page);
        for (Map.Entry<String, Boolean> entry : links.entrySet()) {
            String curTitle = entry.getKey();
            Boolean exists = entry.getValue();
            if (exists.booleanValue()) {
                WikiPage curPage = this.getPage(nodeId, curTitle);
                if (pages.containsKey(curPage.getTitle())) continue;
                pages.put(curPage.getTitle(), curPage);
                continue;
            }
            WikiPageImpl newPage = new WikiPageImpl();
            newPage.setNew(true);
            newPage.setNodeId(nodeId);
            newPage.setTitle(curTitle);
            if (pages.containsKey(curTitle)) continue;
            pages.put(curTitle, newPage);
        }
        return ListUtil.fromMapValues(pages);
    }

    public WikiPage getPage(long resourcePrimKey) throws PortalException, SystemException {
        return this.getPage(resourcePrimKey, Boolean.TRUE);
    }

    public WikiPage getPage(long resourcePrimKey, Boolean head) throws PortalException, SystemException {
        WikiPageResource wikiPageResource = this.wikiPageResourceLocalService.getPageResource(resourcePrimKey);
        return this.getPage(wikiPageResource.getNodeId(), wikiPageResource.getTitle(), head);
    }

    public WikiPage getPage(long nodeId, String title) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByN_T_H(nodeId, title, true, 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        throw new NoSuchPageException();
    }

    public WikiPage getPage(long nodeId, String title, Boolean head) throws PortalException, SystemException {
        List pages = head == null ? this.wikiPagePersistence.findByN_T(nodeId, title, 0, 1) : this.wikiPagePersistence.findByN_T_H(nodeId, title, head.booleanValue(), 0, 1);
        if (!pages.isEmpty()) {
            return (WikiPage)pages.get(0);
        }
        throw new NoSuchPageException();
    }

    public WikiPage getPage(long nodeId, String title, double version) throws PortalException, SystemException {
        WikiPage page = null;
        page = version == 0.0 ? this.getPage(nodeId, title) : this.wikiPagePersistence.findByN_T_V(nodeId, title, version);
        return page;
    }

    public WikiPage getPageByPageId(long pageId) throws PortalException, SystemException {
        return this.wikiPagePersistence.findByPrimaryKey(pageId);
    }

    public WikiPageDisplay getPageDisplay(long nodeId, String title, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        return this.getPageDisplay(page, viewPageURL, editPageURL, attachmentURLPrefix);
    }

    public WikiPageDisplay getPageDisplay(WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PortalException, SystemException {
        String formattedContent = WikiUtil.convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
        return new WikiPageDisplayImpl(page.getUserId(), page.getNodeId(), page.getTitle(), page.getVersion(), page.getContent(), formattedContent, page.getFormat(), page.getHead(), page.getAttachmentsFiles());
    }

    public List<WikiPage> getPages(long nodeId, boolean head, int start, int end) throws SystemException {
        return this.getPages(nodeId, head, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, boolean head, int start, int end, OrderByComparator obc) throws SystemException {
        return this.wikiPagePersistence.findByN_H_S(nodeId, head, 0, start, end, obc);
    }

    public List<WikiPage> getPages(long nodeId, int start, int end) throws SystemException {
        return this.getPages(nodeId, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.wikiPagePersistence.findByNodeId(nodeId, start, end, obc);
    }

    public List<WikiPage> getPages(long resourcePrimKey, long nodeId, int status) throws SystemException {
        return this.wikiPagePersistence.findByR_N_S(resourcePrimKey, nodeId, status);
    }

    public List<WikiPage> getPages(long userId, long nodeId, int status, int start, int end) throws SystemException {
        if (userId > 0L) {
            return this.wikiPagePersistence.findByU_N_S(userId, nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
        }
        return this.wikiPagePersistence.findByN_S(nodeId, status, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, boolean head, int start, int end) throws SystemException {
        return this.wikiPagePersistence.findByN_T_H(nodeId, title, head, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, int start, int end) throws SystemException {
        return this.wikiPagePersistence.findByN_T(nodeId, title, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, int start, int end, OrderByComparator obc) throws SystemException {
        return this.wikiPagePersistence.findByN_T(nodeId, title, start, end, obc);
    }

    public List<WikiPage> getPages(String format) throws SystemException {
        return this.wikiPagePersistence.findByFormat(format);
    }

    public int getPagesCount(long nodeId) throws SystemException {
        return this.wikiPagePersistence.countByNodeId(nodeId);
    }

    public int getPagesCount(long nodeId, boolean head) throws SystemException {
        return this.wikiPagePersistence.countByN_H_S(nodeId, head, 0);
    }

    public int getPagesCount(long userId, long nodeId, int status) throws SystemException {
        if (userId > 0L) {
            return this.wikiPagePersistence.countByU_N_S(userId, nodeId, status);
        }
        return this.wikiPagePersistence.countByN_S(nodeId, status);
    }

    public int getPagesCount(long nodeId, String title) throws SystemException {
        return this.wikiPagePersistence.countByN_T(nodeId, title);
    }

    public int getPagesCount(long nodeId, String title, boolean head) throws SystemException {
        return this.wikiPagePersistence.countByN_T_H(nodeId, title, head);
    }

    public int getPagesCount(String format) throws SystemException {
        return this.wikiPagePersistence.countByFormat(format);
    }

    public List<WikiPage> getRecentChanges(long nodeId, int start, int end) throws SystemException {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.add(3, -1);
        return this.wikiPageFinder.findByCreateDate(nodeId, cal.getTime(), false, start, end);
    }

    public int getRecentChangesCount(long nodeId) throws SystemException {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.add(3, -1);
        return this.wikiPageFinder.countByCreateDate(nodeId, cal.getTime(), false);
    }

    public String[] getTempPageAttachmentNames(long userId, String tempFolderName) {
        return TempFileUtil.getTempFileEntryNames((long)userId, (String)tempFolderName);
    }

    public boolean hasDraftPage(long nodeId, String title) throws SystemException {
        int count = this.wikiPagePersistence.countByN_T_S(nodeId, title, 2);
        return count > 0;
    }

    public void movePage(long userId, long nodeId, String title, String newTitle, boolean strict, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPage page4;
        List pageVersions;
        this.validateTitle(newTitle);
        if (title.equalsIgnoreCase(newTitle)) {
            throw new DuplicatePageException(newTitle);
        }
        if (this.isUsedTitle(nodeId, newTitle)) {
            WikiPage page2 = this.getPage(nodeId, newTitle);
            if (page2.getVersion() == 1.0 && page2.getContent().length() < 200 || !strict) {
                this.deletePage(nodeId, newTitle);
            } else {
                throw new DuplicatePageException(newTitle);
            }
        }
        if ((pageVersions = this.wikiPagePersistence.findByN_T(nodeId, title)).size() == 0) {
            return;
        }
        for (WikiPage page3 : pageVersions) {
            page3.setTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)page3, false);
        }
        List children = this.wikiPagePersistence.findByN_P(nodeId, title);
        for (WikiPage page4 : children) {
            page4.setParentTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)page4, false);
        }
        page4 = (WikiPage)pageVersions.get(pageVersions.size() - 1);
        long resourcePrimKey = page4.getResourcePrimKey();
        WikiPageResource wikiPageResource = this.wikiPageResourcePersistence.findByPrimaryKey(resourcePrimKey);
        wikiPageResource.setTitle(newTitle);
        this.wikiPageResourcePersistence.update((BaseModel)wikiPageResource, false);
        double version = 1.0;
        String summary = "Moved to " + title;
        String format = page4.getFormat();
        boolean head = true;
        String parentTitle = page4.getParentTitle();
        String redirectTitle = page4.getTitle();
        String content = "[[" + redirectTitle + "]]";
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(WikiPage.class.getName(), page4.getResourcePrimKey());
        List assetLinks = this.assetLinkLocalService.getDirectLinks(assetEntry.getEntryId(), 0);
        long[] assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
        serviceContext.setAssetLinkEntryIds(assetLinkEntryIds);
        this.addPage(userId, nodeId, title, version, content, summary, false, format, head, parentTitle, redirectTitle, serviceContext);
        List redirectedPages = this.wikiPagePersistence.findByN_R(nodeId, title);
        for (WikiPage redirectedPage : redirectedPages) {
            redirectedPage.setRedirectTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)redirectedPage, false);
        }
        this.updateAsset(userId, page4, null, null, null);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
        indexer.delete((Object)new Object[]{page4.getCompanyId(), page4.getNodeId(), title});
        indexer.reindex((Object)page4);
    }

    public void movePage(long userId, long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        this.movePage(userId, nodeId, title, newTitle, true, serviceContext);
    }

    public WikiPage revertPage(long userId, long nodeId, String title, double version, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPage oldPage = this.getPage(nodeId, title, version);
        return this.updatePage(userId, nodeId, title, 0.0, oldPage.getContent(), "Reverted to " + version, false, oldPage.getFormat(), this.getParentPageTitle(oldPage), oldPage.getRedirectTitle(), serviceContext);
    }

    public void subscribePage(long userId, long nodeId, String title) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.subscriptionLocalService.addSubscription(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public void unsubscribePage(long userId, long nodeId, String title) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.subscriptionLocalService.deleteSubscription(userId, WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public void updateAsset(long userId, WikiPage page, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        int approvedPagesCount;
        boolean addDraftAssetEntry = false;
        if (!page.isApproved() && page.getVersion() != 1.0 && (approvedPagesCount = this.wikiPagePersistence.countByN_T_S(page.getNodeId(), page.getTitle(), 0)) > 0) {
            addDraftAssetEntry = true;
        }
        AssetEntry assetEntry = null;
        assetEntry = addDraftAssetEntry ? this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), WikiPage.class.getName(), page.getPrimaryKey(), page.getUuid(), 0L, assetCategoryIds, assetTagNames, false, null, null, null, null, "text/html", page.getTitle(), null, null, null, null, 0, 0, null, false) : this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUuid(), 0L, assetCategoryIds, assetTagNames, page.isApproved(), null, null, null, null, "text/html", page.getTitle(), null, null, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public WikiPage updatePage(long userId, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        WikiPage oldPage = null;
        try {
            oldPage = this.wikiPagePersistence.findByN_T_First(nodeId, title, null);
        }
        catch (NoSuchPageException noSuchPageException) {
            return this.addPage(userId, nodeId, title, 1.0, content, summary, minorEdit, format, true, parentTitle, redirectTitle, serviceContext);
        }
        long pageId = 0L;
        pageId = oldPage.isApproved() ? this.counterLocalService.increment() : oldPage.getPageId();
        content = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)oldPage.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)pageId, (String)("text/" + format), (String)content);
        this.validate(nodeId, content, format);
        double oldVersion = oldPage.getVersion();
        if (version > 0.0 && version != oldVersion) {
            throw new PageVersionException();
        }
        serviceContext.validateModifiedDate((AuditedModel)oldPage, PageVersionException.class);
        long resourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(nodeId, title);
        long groupId = oldPage.getGroupId();
        WikiPage page = oldPage;
        double newVersion = oldVersion;
        if (oldPage.isApproved()) {
            newVersion = MathUtil.format((double)(oldVersion + 0.1), (int)1, (int)1);
            page = this.wikiPagePersistence.create(pageId);
        }
        page.setResourcePrimKey(resourcePrimKey);
        page.setGroupId(groupId);
        page.setCompanyId(user.getCompanyId());
        page.setUserId(user.getUserId());
        page.setUserName(user.getFullName());
        page.setCreateDate(serviceContext.getModifiedDate(now));
        page.setModifiedDate(serviceContext.getModifiedDate(now));
        page.setNodeId(nodeId);
        page.setTitle(title);
        page.setVersion(newVersion);
        page.setMinorEdit(minorEdit);
        page.setContent(content);
        if (oldPage.isPending()) {
            page.setStatus(oldPage.getStatus());
        } else {
            page.setStatus(2);
        }
        page.setSummary(summary);
        page.setFormat(format);
        if (Validator.isNotNull((String)parentTitle)) {
            page.setParentTitle(parentTitle);
        }
        if (Validator.isNotNull((String)redirectTitle)) {
            page.setRedirectTitle(redirectTitle);
        }
        this.wikiPagePersistence.update((BaseModel)page, false);
        ExpandoBridge expandoBridge = page.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        node.setLastPostDate(serviceContext.getModifiedDate(now));
        this.wikiNodePersistence.update((BaseModel)node, false);
        this.updateAsset(userId, page, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)page.getGroupId(), (long)userId, (String)WikiPage.class.getName(), (long)page.getPageId(), (Object)page, (ServiceContext)serviceContext);
        return page;
    }

    public WikiPage updateStatus(long userId, long resourcePrimKey, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPageResource wikiPageResource = this.wikiPageResourceLocalService.getPageResource(resourcePrimKey);
        List pages = this.wikiPagePersistence.findByN_T(wikiPageResource.getNodeId(), wikiPageResource.getTitle(), 0, 1, (OrderByComparator)new PageVersionComparator());
        WikiPage page = null;
        if (pages.isEmpty()) {
            throw new NoSuchPageException();
        }
        page = (WikiPage)pages.get(0);
        return this.updateStatus(userId, page, status, serviceContext);
    }

    public WikiPage updateStatus(long userId, WikiPage page, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(page.getNodeId());
        Date now = new Date();
        int oldStatus = page.getStatus();
        page.setStatus(status);
        page.setStatusByUserId(userId);
        page.setStatusByUserName(user.getFullName());
        page.setStatusDate(now);
        if (status == 0) {
            if (oldStatus != 0 && page.getVersion() != 1.0) {
                try {
                    AssetEntry draftAssetEntry = this.assetEntryLocalService.getEntry(WikiPage.class.getName(), page.getPrimaryKey());
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0);
                    long[] assetLinkEntryIds = StringUtil.split((String)ListUtil.toString((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR), (long)0L);
                    AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), page.getUuid(), 0L, assetCategoryIds, assetTagNames, true, null, null, null, null, "text/html", page.getTitle(), null, null, null, null, 0, 0, null, false);
                    this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                    this.assetEntryLocalService.deleteEntry(draftAssetEntry.getEntryId());
                }
                catch (NoSuchEntryException noSuchEntryException) {}
            }
            this.assetEntryLocalService.updateVisible(WikiPage.class.getName(), page.getResourcePrimKey(), true);
            if (!page.isMinorEdit() || PropsValues.WIKI_PAGE_MINOR_EDIT_ADD_SOCIAL_ACTIVITY) {
                int activity = 1;
                if (page.getVersion() > 1.0) {
                    activity = 2;
                }
                this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), activity, "", 0L);
            }
            if (NotificationThreadLocal.isEnabled() && (!page.isMinorEdit() || PropsValues.WIKI_PAGE_MINOR_EDIT_SEND_EMAIL)) {
                boolean update = false;
                if (page.getVersion() > 1.0) {
                    update = true;
                }
                this.notifySubscribers(node, page, serviceContext, update);
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(WikiPage.class);
            indexer.reindex((Object)page);
            this.clearPageCache(page);
            page.setHead(true);
            List pages = this.wikiPagePersistence.findByN_T_H(page.getNodeId(), page.getTitle(), true);
            for (WikiPage curPage : pages) {
                if (curPage.equals(page)) continue;
                curPage.setHead(false);
                this.wikiPagePersistence.update((BaseModel)curPage, false);
            }
        } else {
            page.setHead(false);
            List pages = this.wikiPagePersistence.findByN_T_S(page.getNodeId(), page.getTitle(), 0);
            for (WikiPage curPage : pages) {
                if (curPage.equals(page)) continue;
                curPage.setHead(true);
                this.wikiPagePersistence.update((BaseModel)curPage, false);
                break;
            }
        }
        return (WikiPage)this.wikiPagePersistence.update((BaseModel)page, false);
    }

    public void validateTitle(String title) throws PortalException {
        Pattern pattern;
        Matcher matcher;
        if (title.equals("all_pages") || title.equals("orphan_pages") || title.equals("recent_changes")) {
            throw new PageTitleException(String.valueOf(title) + " is reserved");
        }
        if (Validator.isNotNull((String)PropsValues.WIKI_PAGE_TITLES_REGEXP) && !(matcher = (pattern = Pattern.compile(PropsValues.WIKI_PAGE_TITLES_REGEXP)).matcher(title)).matches()) {
            throw new PageTitleException();
        }
    }

    protected void clearPageCache(WikiPage page) {
        if (!WikiCacheThreadLocal.isClearCache()) {
            return;
        }
        WikiCacheUtil.clearCache(page.getNodeId());
    }

    protected String getParentPageTitle(WikiPage page) {
        try {
            WikiPage parentPage = this.getPage(page.getNodeId(), page.getParentTitle());
            return parentPage.getTitle();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected WikiPage getPreviousVersionPage(WikiPage page) throws PortalException, SystemException {
        double previousVersion = MathUtil.format((double)(page.getVersion() - 0.1), (int)1, (int)1);
        if (previousVersion < 1.0) {
            return null;
        }
        return this.getPage(page.getNodeId(), page.getTitle(), previousVersion);
    }

    protected boolean isLinkedTo(WikiPage page, String targetTitle) throws PortalException {
        Map<String, Boolean> links = WikiCacheUtil.getOutgoingLinks(page);
        Boolean link = links.get(targetTitle.toLowerCase());
        return link != null;
    }

    protected boolean isUsedTitle(long nodeId, String title) throws SystemException {
        return this.getPagesCount(nodeId, title, true) > 0;
    }

    protected void notifySubscribers(WikiNode node, WikiPage page, ServiceContext serviceContext, boolean update) throws PortalException, SystemException {
        PortletPreferences preferences = null;
        String rootPortletId = serviceContext.getRootPortletId();
        if (Validator.isNull((String)rootPortletId) || rootPortletId.equals("54")) {
            preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        }
        if (preferences == null) {
            preferences = this.portletPreferencesLocalService.getPreferences(node.getCompanyId(), node.getGroupId(), 2, 0L, "154", null);
        }
        if (!(!update && WikiUtil.getEmailPageAddedEnabled(preferences) || update && WikiUtil.getEmailPageUpdatedEnabled(preferences))) {
            return;
        }
        String portalURL = serviceContext.getPortalURL();
        String layoutFullURL = serviceContext.getLayoutFullURL();
        WikiPage previousVersionPage = this.getPreviousVersionPage(page);
        String attachmentURLPrefix = String.valueOf(portalURL) + serviceContext.getPathMain() + "/wiki/get_page_attachment?p_l_id=" + serviceContext.getPlid() + "&nodeId=" + page.getNodeId() + "&title=" + HttpUtil.encodeURL((String)page.getTitle()) + "&fileName=";
        String pageDiffs = "";
        try {
            pageDiffs = WikiUtil.diffHtml(previousVersionPage, page, null, null, attachmentURLPrefix);
        }
        catch (Exception exception) {}
        String pageContent = null;
        if (Validator.equals((Object)page.getFormat(), (Object)"creole")) {
            pageContent = WikiUtil.convert(page, null, null, attachmentURLPrefix);
        } else {
            pageContent = page.getContent();
            pageContent = WikiUtil.processContent(pageContent);
        }
        String pageURL = "";
        String diffsURL = "";
        if (Validator.isNotNull((String)layoutFullURL)) {
            pageURL = String.valueOf(layoutFullURL) + "/-/" + "wiki/" + node.getNodeId() + "/" + HttpUtil.encodeURL((String)page.getTitle());
            if (previousVersionPage != null) {
                StringBundler sb = new StringBundler(16);
                sb.append(layoutFullURL);
                sb.append("?p_p_id=");
                sb.append("36");
                sb.append("&p_p_state=");
                sb.append((Object)WindowState.MAXIMIZED);
                sb.append("&struts_action=");
                sb.append(HttpUtil.encodeURL((String)"/wiki/compare_versions"));
                sb.append("&nodeId=");
                sb.append(node.getNodeId());
                sb.append("&title=");
                sb.append(HttpUtil.encodeURL((String)page.getTitle()));
                sb.append("&sourceVersion=");
                sb.append(previousVersionPage.getVersion());
                sb.append("&targetVersion=");
                sb.append(page.getVersion());
                sb.append("&type=html");
                diffsURL = sb.toString();
            }
        }
        String fromName = WikiUtil.getEmailFromName(preferences, page.getCompanyId());
        String fromAddress = WikiUtil.getEmailFromAddress(preferences, page.getCompanyId());
        String subjectPrefix = null;
        String body = null;
        String signature = null;
        if (update) {
            subjectPrefix = WikiUtil.getEmailPageUpdatedSubjectPrefix(preferences);
            body = WikiUtil.getEmailPageUpdatedBody(preferences);
            signature = WikiUtil.getEmailPageUpdatedSignature(preferences);
        } else {
            subjectPrefix = WikiUtil.getEmailPageAddedSubjectPrefix(preferences);
            body = WikiUtil.getEmailPageAddedBody(preferences);
            signature = WikiUtil.getEmailPageAddedSignature(preferences);
        }
        String subject = page.getTitle();
        if (subject.indexOf(subjectPrefix) == -1) {
            subject = String.valueOf(subjectPrefix) + " " + subject;
        }
        if (Validator.isNotNull((String)signature)) {
            body = String.valueOf(body) + "\n" + signature;
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(page.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$DIFFS_URL$]", diffsURL, "[$NODE_NAME$]", node.getName(), "[$PAGE_DATE_UPDATE$]", page.getModifiedDate(), "[$PAGE_ID$]", page.getPageId(), "[$PAGE_SUMMARY$]", page.getSummary(), "[$PAGE_TITLE$]", page.getTitle(), "[$PAGE_URL$]", pageURL});
        subscriptionSender.setContextAttribute("[$PAGE_CONTENT$]", (Object)pageContent, false);
        subscriptionSender.setContextAttribute("[$PAGE_DIFFS$]", (Object)this.replaceStyles(pageDiffs), false);
        subscriptionSender.setContextUserPrefix("PAGE");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("wiki_page", new Object[]{page.getNodeId(), page.getPageId()});
        subscriptionSender.setPortletId("36");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(node.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(page.getUserId());
        subscriptionSender.addPersistedSubscribers(WikiNode.class.getName(), node.getNodeId());
        subscriptionSender.addPersistedSubscribers(WikiPage.class.getName(), page.getResourcePrimKey());
        subscriptionSender.flushNotificationsAsync();
    }

    protected String replaceStyles(String html) {
        return StringUtil.replace((String)html, (String[])new String[]{"class=\"diff-html-added\"", "class=\"diff-html-removed\"", "class=\"diff-html-changed\"", "changeType=\"diff-added-image\"", "changeType=\"diff-removed-image\"", "changeType=\"diff-changed-image\""}, (String[])new String[]{"style=\"background-color: #CFC;\"", "style=\"background-color: #FDC6C6; text-decoration: line-through;\"", "style=\"border-bottom: 2px dotted blue;\"", "style=\"border: 10px solid #CFC;\"", "style=\"border: 10px solid #FDC6C6;\"", "style=\"border: 10px solid blue;\""});
    }

    protected void validate(long nodeId, String content, String format) throws PortalException {
        if (!WikiUtil.validate(nodeId, content, format)) {
            throw new PageContentException();
        }
    }

    protected void validate(String title, long nodeId, String content, String format) throws PortalException, SystemException {
        if (Validator.isNull((String)title)) {
            throw new PageTitleException();
        }
        if (this.isUsedTitle(nodeId, title)) {
            throw new DuplicatePageException();
        }
        this.validateTitle(title);
        this.validate(nodeId, content, format);
    }
}

