/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.social;

import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.service.WikiPageResourceLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;

public class WikiActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{WikiPage.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!WikiPagePermission.contains(permissionChecker, activity.getClassPK(), "VIEW")) {
            return null;
        }
        String groupName = "";
        if (activity.getGroupId() != themeDisplay.getScopeGroupId()) {
            groupName = this.getGroupName(activity.getGroupId(), themeDisplay);
        }
        String creatorUserName = this.getUserName(activity.getUserId(), themeDisplay);
        int activityType = activity.getType();
        WikiPageResource pageResource = WikiPageResourceLocalServiceUtil.getPageResource((long)activity.getClassPK());
        String link = String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/wiki/find_page?pageResourcePrimKey=" + activity.getClassPK();
        String titlePattern = null;
        if (activityType == 3 || activityType == 10005) {
            titlePattern = "activity-wiki-add-comment";
        } else if (activityType == 1) {
            titlePattern = "activity-wiki-add-page";
        } else if (activityType == 2) {
            titlePattern = "activity-wiki-update-page";
        }
        if (Validator.isNotNull((String)groupName)) {
            titlePattern = String.valueOf(titlePattern) + "-in";
        }
        String pageTitle = this.wrapLink(link, HtmlUtil.escape((String)pageResource.getTitle()));
        Object[] titleArguments = new Object[]{groupName, creatorUserName, pageTitle};
        String title = themeDisplay.translate(titlePattern, titleArguments);
        String body = "";
        return new SocialActivityFeedEntry(link, title, body);
    }
}

