/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class WikiIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{WikiPage.class.getName()};
    public static final String PORTLET_ID = "36";
    private static final boolean _PERMISSION_AWARE = true;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] nodeIds;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)-1);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
        if ((nodeIds = searchContext.getNodeIds()) != null && nodeIds.length > 0) {
            BooleanQuery nodeIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            long[] lArray = nodeIds;
            int n = nodeIds.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    long nodeId = lArray[n2];
                    try {
                        WikiNodeServiceUtil.getNode((long)nodeId);
                    }
                    catch (Exception exception) {
                        break block5;
                    }
                    nodeIdsQuery.addTerm("nodeId", nodeId);
                }
                ++n2;
            }
            contextQuery.add((Query)nodeIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long companyId) {
        Property property = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(property.eq((Object)companyId));
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long groupId, long nodeId) {
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(groupIdProperty.eq((Object)groupId));
        Property nodeIdProperty = PropertyFactoryUtil.forName((String)"nodeId");
        dynamicQuery.add(nodeIdProperty.eq((Object)nodeId));
        Property headProperty = PropertyFactoryUtil.forName((String)"head");
        dynamicQuery.add(headProperty.eq((Object)true));
    }

    protected void doDelete(Object obj) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setSearchEngineId(this.getSearchEngineId());
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            long companyId = (Long)array[0];
            long nodeId = (Long)array[1];
            String title = (String)array[2];
            DocumentImpl document = new DocumentImpl();
            document.addUID(PORTLET_ID, nodeId, title);
            SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)companyId, (String)document.get("uid"));
        } else if (obj instanceof WikiNode) {
            WikiNode node = (WikiNode)obj;
            BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            booleanQuery.addRequiredTerm("portletId", PORTLET_ID);
            booleanQuery.addRequiredTerm("nodeId", node.getNodeId());
            Hits hits = SearchEngineUtil.search((String)this.getSearchEngineId(), (long)node.getCompanyId(), (Query)booleanQuery, (int)-1, (int)-1);
            int i2 = 0;
            while (i2 < hits.getLength()) {
                Document document = hits.doc(i2);
                SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)node.getCompanyId(), (String)document.get("uid"));
                ++i2;
            }
        } else if (obj instanceof WikiPage) {
            WikiPage page = (WikiPage)obj;
            DocumentImpl document = new DocumentImpl();
            document.addUID(PORTLET_ID, page.getNodeId(), page.getTitle());
            SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)page.getCompanyId(), (String)document.get("uid"));
        }
    }

    protected Document doGetDocument(Object obj) throws Exception {
        WikiPage page = (WikiPage)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)page);
        document.addUID(PORTLET_ID, page.getNodeId(), page.getTitle());
        String content = HtmlUtil.extractText((String)WikiUtil.convert(page, null, null, null));
        document.addText("content", content);
        document.addKeyword("nodeId", page.getNodeId());
        document.addText("title", page.getTitle());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String nodeId = document.get("nodeId");
        portletURL.setParameter("struts_action", "/wiki/view");
        portletURL.setParameter("nodeId", nodeId);
        portletURL.setParameter("title", title);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        WikiPage page = (WikiPage)obj;
        if (Validator.isNotNull((String)page.getRedirectTitle())) {
            return;
        }
        Document document = this.getDocument(page);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)page.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        this.doReindex(page);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexNodes(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexNodes(long companyId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(WikiNode.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minNodeIdProjection = ProjectionFactoryUtil.min((String)"nodeId");
        Projection maxNodeIdProjection = ProjectionFactoryUtil.max((String)"nodeId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minNodeIdProjection);
        projectionList.add(maxNodeIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, companyId);
        List results = WikiNodeLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxNodeIds = (Object[])results.get(0);
        if (minAndMaxNodeIds[0] == null || minAndMaxNodeIds[1] == null) {
            return;
        }
        long minNodeId = (Long)minAndMaxNodeIds[0];
        long maxNodeId = (Long)minAndMaxNodeIds[1];
        long startNodeId = minNodeId;
        long endNodeId = startNodeId + 10000L;
        while (startNodeId <= maxNodeId) {
            this.reindexNodes(companyId, startNodeId, endNodeId);
            startNodeId = endNodeId;
            endNodeId += 10000L;
        }
    }

    protected void reindexNodes(long companyId, long startNodeId, long endNodeId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(WikiNode.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"nodeId");
        dynamicQuery.add(property.ge((Object)startNodeId));
        dynamicQuery.add(property.lt((Object)endNodeId));
        this.addReindexCriteria(dynamicQuery, companyId);
        List nodes = WikiNodeLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (WikiNode node : nodes) {
            long groupId = node.getGroupId();
            long nodeId = node.getNodeId();
            this.reindexPages(companyId, groupId, nodeId);
        }
    }

    protected void reindexPages(long companyId, long groupId, long nodeId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(WikiPage.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minPageIdProjection = ProjectionFactoryUtil.min((String)"pageId");
        Projection maxPageIdProjection = ProjectionFactoryUtil.max((String)"pageId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minPageIdProjection);
        projectionList.add(maxPageIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, groupId, nodeId);
        List results = WikiPageLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxPageIds = (Object[])results.get(0);
        if (minAndMaxPageIds[0] == null || minAndMaxPageIds[1] == null) {
            return;
        }
        long minPageId = (Long)minAndMaxPageIds[0];
        long maxPageId = (Long)minAndMaxPageIds[1];
        long startPageId = minPageId;
        long endPageId = startPageId + 10000L;
        while (startPageId <= maxPageId) {
            this.reindexPages(companyId, groupId, nodeId, startPageId, endPageId);
            startPageId = endPageId;
            endPageId += 10000L;
        }
    }

    protected void reindexPages(long companyId, long groupId, long nodeId, long startPageId, long endPageId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(WikiPage.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"pageId");
        dynamicQuery.add(property.ge((Object)startPageId));
        dynamicQuery.add(property.lt((Object)endPageId));
        this.addReindexCriteria(dynamicQuery, groupId, nodeId);
        List pages = WikiPageLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        if (pages.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>(pages.size());
        for (WikiPage page : pages) {
            Document document = this.getDocument(page);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

