/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.SHA1Digest;
import org.spongycastle.crypto.digests.SHA256Digest;
import org.spongycastle.crypto.params.DSAParameters;
import org.spongycastle.crypto.params.DSAValidationParameters;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.BigIntegers;

public class DSAParametersGenerator {
    private int L;
    private int N;
    private int certainty;
    private SecureRandom random;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    public void init(int size, int certainty, SecureRandom random) {
        this.init(size, DSAParametersGenerator.getDefaultN(size), certainty, random);
    }

    private void init(int L, int N, int certainty, SecureRandom random) {
        this.L = L;
        this.N = N;
        this.certainty = certainty;
        this.random = random;
    }

    public DSAParameters generateParameters() {
        return this.L > 1024 ? this.generateParameters_FIPS186_3() : this.generateParameters_FIPS186_2();
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters generateParameters_FIPS186_2() {
        seed = new byte[20];
        part1 = new byte[20];
        part2 = new byte[20];
        u = new byte[20];
        sha1 = new SHA1Digest();
        n = (this.L - 1) / 160;
        w = new byte[this.L / 8];
        block0: while (true) {
            this.random.nextBytes(seed);
            DSAParametersGenerator.hash(sha1, seed, part1);
            System.arraycopy(seed, 0, part2, 0, seed.length);
            DSAParametersGenerator.inc(part2);
            DSAParametersGenerator.hash(sha1, part2, part2);
            for (i = 0; i != u.length; ++i) {
                u[i] = (byte)(part1[i] ^ part2[i]);
            }
            u[0] = (byte)(u[0] | -128);
            u[19] = (byte)(u[19] | 1);
            q = new BigInteger(1, u);
            if (!q.isProbablePrime(this.certainty)) continue;
            offset = Arrays.clone(seed);
            DSAParametersGenerator.inc(offset);
            counter = 0;
            while (true) {
                if (counter < 4096) ** break;
                continue block0;
                for (k = 0; k < n; ++k) {
                    DSAParametersGenerator.inc(offset);
                    DSAParametersGenerator.hash(sha1, offset, part1);
                    System.arraycopy(part1, 0, w, w.length - (k + 1) * part1.length, part1.length);
                }
                DSAParametersGenerator.inc(offset);
                DSAParametersGenerator.hash(sha1, offset, part1);
                System.arraycopy(part1, part1.length - (w.length - n * part1.length), w, 0, w.length - n * part1.length);
                w[0] = (byte)(w[0] | -128);
                x = new BigInteger(1, w);
                c = x.mod(q.shiftLeft(1));
                p = x.subtract(c.subtract(DSAParametersGenerator.ONE));
                if (p.bitLength() == this.L && p.isProbablePrime(this.certainty)) {
                    g = DSAParametersGenerator.calculateGenerator_FIPS186_2(p, q, this.random);
                    return new DSAParameters(p, q, g, new DSAValidationParameters(seed, counter));
                }
                ++counter;
            }
            break;
        }
    }

    private static BigInteger calculateGenerator_FIPS186_2(BigInteger p, BigInteger q, SecureRandom r) {
        BigInteger h;
        BigInteger g;
        BigInteger e = p.subtract(ONE).divide(q);
        BigInteger pSub2 = p.subtract(TWO);
        while ((g = (h = BigIntegers.createRandomInRange(TWO, pSub2, r)).modPow(e, p)).bitLength() <= 1) {
        }
        return g;
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters generateParameters_FIPS186_3() {
        d = new SHA256Digest();
        outlen = d.getDigestSize() * 8;
        seedlen = this.N;
        seed = new byte[seedlen / 8];
        n = (this.L - 1) / outlen;
        b = (this.L - 1) % outlen;
        output = new byte[d.getDigestSize()];
        block0: while (true) {
            this.random.nextBytes(seed);
            DSAParametersGenerator.hash(d, seed, output);
            U = new BigInteger(1, output).mod(DSAParametersGenerator.ONE.shiftLeft(this.N - 1));
            q = DSAParametersGenerator.ONE.shiftLeft(this.N - 1).add(U).add(DSAParametersGenerator.ONE).subtract(U.mod(DSAParametersGenerator.TWO));
            if (!q.isProbablePrime(this.certainty)) continue;
            offset = Arrays.clone(seed);
            counterLimit = 4 * this.L;
            counter = 0;
            while (true) {
                if (counter < counterLimit) ** break;
                continue block0;
                W = DSAParametersGenerator.ZERO;
                j = 0;
                exp = 0;
                while (j <= n) {
                    DSAParametersGenerator.inc(offset);
                    DSAParametersGenerator.hash(d, offset, output);
                    Vj = new BigInteger(1, output);
                    if (j == n) {
                        Vj = Vj.mod(DSAParametersGenerator.ONE.shiftLeft(b));
                    }
                    W = W.add(Vj.shiftLeft(exp));
                    ++j;
                    exp += outlen;
                }
                X = W.add(DSAParametersGenerator.ONE.shiftLeft(this.L - 1));
                p = X.subtract((c = X.mod(q.shiftLeft(1))).subtract(DSAParametersGenerator.ONE));
                if (p.bitLength() == this.L && p.isProbablePrime(this.certainty)) {
                    g = DSAParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(p, q, this.random);
                    return new DSAParameters(p, q, g, new DSAValidationParameters(seed, counter));
                }
                ++counter;
            }
            break;
        }
    }

    private static BigInteger calculateGenerator_FIPS186_3_Unverifiable(BigInteger p, BigInteger q, SecureRandom r) {
        return DSAParametersGenerator.calculateGenerator_FIPS186_2(p, q, r);
    }

    private static void hash(Digest d, byte[] input, byte[] output) {
        d.update(input, 0, input.length);
        d.doFinal(output, 0);
    }

    private static int getDefaultN(int L) {
        return L > 1024 ? 256 : 160;
    }

    private static void inc(byte[] buf) {
        for (int i = buf.length - 1; i >= 0; --i) {
            byte b;
            buf[i] = b = (byte)(buf[i] + 1 & 0xFF);
            if (b != 0) break;
        }
    }
}

