/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.flink.common;

import java.io.Serializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class KustoRetryConfig
implements Serializable {
    private final int maxAttempts;
    private final long baseIntervalMillis;
    private final long maxIntervalMillis;
    private final int cacheExpirationSeconds;

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public long getBaseIntervalMillis() {
        return this.baseIntervalMillis;
    }

    public long getMaxIntervalMillis() {
        return this.maxIntervalMillis;
    }

    public int getCacheExpirationSeconds() {
        return this.cacheExpirationSeconds;
    }

    @Contract(pure=true)
    private KustoRetryConfig(@NotNull Builder builder) {
        this.maxAttempts = builder.maxAttempts;
        this.baseIntervalMillis = builder.baseIntervalMillis;
        this.maxIntervalMillis = builder.maxIntervalMillis;
        this.cacheExpirationSeconds = builder.cacheExpirationSeconds;
    }

    @Contract(value=" -> new")
    public static @NotNull Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int maxAttempts = 3;
        private long baseIntervalMillis = 1000L;
        private long maxIntervalMillis = 10L * this.baseIntervalMillis;
        private int cacheExpirationSeconds = 7200;

        public Builder withMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder withBaseIntervalMillis(long baseIntervalMillis) {
            this.baseIntervalMillis = baseIntervalMillis;
            return this;
        }

        public Builder withMaxIntervalMillis(long maxIntervalMillis) {
            this.maxIntervalMillis = maxIntervalMillis;
            return this;
        }

        public Builder withCacheExpirationSeconds(int cacheExpirationSeconds) {
            this.cacheExpirationSeconds = cacheExpirationSeconds;
            return this;
        }

        public KustoRetryConfig build() {
            return new KustoRetryConfig(this);
        }
    }
}

