/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.flink.common;

import com.microsoft.azure.flink.common.KustoRetryConfig;
import com.microsoft.azure.kusto.data.exceptions.KustoDataExceptionBase;
import com.microsoft.azure.kusto.ingest.exceptions.IngestionServiceException;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class KustoRetryUtil {
    private KustoRetryUtil() {
    }

    @NotNull
    public static Retry getRetries(@NotNull KustoRetryConfig kustoRetryConfig) {
        IntervalFunction backOffFunction = IntervalFunction.ofExponentialRandomBackoff((long)kustoRetryConfig.getBaseIntervalMillis(), (double)1.5, (double)0.5, (long)kustoRetryConfig.getMaxIntervalMillis());
        Predicate<Throwable> isTransientException = e -> {
            if (e instanceof KustoDataExceptionBase) {
                return !((KustoDataExceptionBase)e).isPermanent();
            }
            return e instanceof IngestionServiceException;
        };
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(kustoRetryConfig.getMaxAttempts()).intervalFunction(backOffFunction).retryOnException(isTransientException).build();
        RetryRegistry registry = RetryRegistry.of((RetryConfig)retryConfig);
        Retry retry = registry.retry("tempStoreService", retryConfig);
        return retry;
    }
}

