/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.flink.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.util.Preconditions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KustoWriteOptions
implements Serializable {
    protected static final Logger LOG = LoggerFactory.getLogger(KustoWriteOptions.class);
    private final String database;
    private final String table;
    private final String ingestionMappingRef;
    private final boolean flushImmediately;
    private final long batchIntervalMs;
    private final long batchSize;
    private final long clientBatchSizeLimit;
    private final List<String> ingestByTags;
    private final List<String> additionalTags;
    private final DeliveryGuarantee deliveryGuarantee;
    private final boolean pollForIngestionStatus;

    private KustoWriteOptions(@NotNull Builder builder) {
        this.database = (String)Preconditions.checkNotNull((Object)builder.database);
        this.table = (String)Preconditions.checkNotNull((Object)builder.table);
        this.ingestionMappingRef = builder.ingestionMappingRef;
        this.flushImmediately = builder.flushImmediately;
        if (this.flushImmediately) {
            LOG.warn("FlushImmediately is set to true, this may cause performance issues");
        }
        this.batchIntervalMs = builder.batchIntervalMs;
        this.batchSize = builder.batchSize;
        this.clientBatchSizeLimit = builder.clientBatchSizeLimit;
        this.ingestByTags = builder.ingestByTags;
        this.additionalTags = builder.additionalTags;
        this.deliveryGuarantee = builder.deliveryGuarantee;
        this.pollForIngestionStatus = builder.pollForIngestionStatus;
    }

    public List<String> getIngestByTags() {
        return this.ingestByTags;
    }

    public List<String> getAdditionalTags() {
        return this.additionalTags;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String getIngestionMappingRef() {
        return this.ingestionMappingRef;
    }

    public boolean getFlushImmediately() {
        return this.flushImmediately;
    }

    public long getBatchIntervalMs() {
        return this.batchIntervalMs;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public long getClientBatchSizeLimit() {
        return this.clientBatchSizeLimit;
    }

    public DeliveryGuarantee getDeliveryGuarantee() {
        return this.deliveryGuarantee;
    }

    public boolean getPollForIngestionStatus() {
        return this.pollForIngestionStatus;
    }

    public int hashCode() {
        return Objects.hash(this.database, this.table);
    }

    @Contract(value=" -> new")
    public static @NotNull Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "KustoWriteOptions{database='" + this.database + '\'' + ", table='" + this.table + '\'' + ", ingestionMappingRef='" + this.ingestionMappingRef + '\'' + ", flushImmediately=" + this.flushImmediately + ", batchIntervalMs=" + this.batchIntervalMs + ", batchSize=" + this.batchSize + ", clientBatchSizeLimit=" + this.clientBatchSizeLimit + ", ingestByTags=" + this.ingestByTags + ", additionalTags=" + this.additionalTags + ", deliveryGuarantee=" + this.deliveryGuarantee + ", pollForIngestionStatus=" + this.pollForIngestionStatus + '}';
    }

    @PublicEvolving
    public static class Builder {
        private String database;
        private String table;
        private String ingestionMappingRef = null;
        private boolean flushImmediately = false;
        private long batchIntervalMs = 30000L;
        private long batchSize = 1000L;
        private long clientBatchSizeLimit = 314572800L;
        private boolean pollForIngestionStatus = false;
        private DeliveryGuarantee deliveryGuarantee = DeliveryGuarantee.AT_LEAST_ONCE;
        private List<String> ingestByTags = Collections.emptyList();
        private List<String> additionalTags = Collections.emptyList();

        private Builder() {
        }

        public Builder withDatabase(String database) {
            this.database = (String)Preconditions.checkNotNull((Object)database, (String)"The database  must not be null");
            return this;
        }

        public Builder withTable(String table) {
            this.table = (String)Preconditions.checkNotNull((Object)table, (String)"The table  must not be null");
            return this;
        }

        public Builder withIngestionMappingRef(String ingestionMappingRef) {
            this.ingestionMappingRef = (String)Preconditions.checkNotNull((Object)ingestionMappingRef, (String)"The mapping ingestion reference  must not be null");
            return this;
        }

        public Builder withFlushImmediately(boolean flushImmediately) {
            this.flushImmediately = flushImmediately;
            return this;
        }

        public Builder withBatchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder withBatchIntervalMs(long batchIntervalMs) {
            this.batchIntervalMs = batchIntervalMs;
            return this;
        }

        public Builder withIngestByTags(List<String> ingestByTags) {
            this.ingestByTags = ingestByTags;
            return this;
        }

        public Builder withDeliveryGuarantee(DeliveryGuarantee deliveryGuarantee) {
            if (deliveryGuarantee != null) {
                if (deliveryGuarantee == DeliveryGuarantee.NONE) {
                    LOG.info(DeliveryGuarantee.NONE.getDescription().toString());
                }
                this.deliveryGuarantee = deliveryGuarantee;
            }
            return this;
        }

        public Builder withClientBatchSizeLimit(long clientBatchSizeLimit) {
            this.clientBatchSizeLimit = clientBatchSizeLimit;
            return this;
        }

        public Builder withPollForIngestionStatus(boolean pollForIngestionStatus) {
            this.pollForIngestionStatus = pollForIngestionStatus;
            return this;
        }

        public KustoWriteOptions build() {
            if (this.batchIntervalMs > 0L || this.batchSize > 0L) {
                LOG.warn("BatchInterval and BatchSize are applicable options only for SinkWriter and not applicable for GenericWriteAheadSink");
            }
            return new KustoWriteOptions(this);
        }
    }
}

