/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.flink.writer.internal.sink;

import com.microsoft.azure.flink.config.KustoConnectionOptions;
import com.microsoft.azure.flink.config.KustoWriteOptions;
import com.microsoft.azure.flink.writer.internal.sink.KustoSinkWriter;
import java.net.URISyntaxException;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KustoSink<IN>
implements Sink<IN> {
    protected static final Logger LOG = LoggerFactory.getLogger(KustoSink.class);
    private static final long serialVersionUID = 1L;
    private final KustoConnectionOptions connectionOptions;
    private final KustoWriteOptions writeOptions;
    private final TypeSerializer<IN> serializer;
    private final TypeInformation<IN> typeInfo;

    public KustoSink(KustoConnectionOptions connectionOptions, KustoWriteOptions writeOptions, TypeSerializer<IN> serializer, TypeInformation<IN> typeInfo) {
        this.connectionOptions = (KustoConnectionOptions)Preconditions.checkNotNull((Object)connectionOptions);
        this.writeOptions = (KustoWriteOptions)Preconditions.checkNotNull((Object)writeOptions);
        this.serializer = (TypeSerializer)Preconditions.checkNotNull(serializer);
        this.typeInfo = (TypeInformation)Preconditions.checkNotNull(typeInfo);
        ClosureCleaner.clean(serializer, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
    }

    public SinkWriter<IN> createWriter(Sink.InitContext context) {
        try {
            LOG.info("Writing to DB {} in cluster {} ", (Object)this.writeOptions.getDatabase(), (Object)this.connectionOptions.getClusterUrl());
            return new KustoSinkWriter<IN>(this.connectionOptions, this.writeOptions, this.serializer, this.typeInfo, true, context);
        }
        catch (URISyntaxException e) {
            LOG.error("Writing to DB {} in cluster {} failed with URISyntaxException", (Object)this.writeOptions.getDatabase(), (Object)this.connectionOptions.getClusterUrl());
            throw new RuntimeException(e);
        }
    }
}

