/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.KustoCheckedFunction;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialRetry<E1 extends Throwable, E2 extends Throwable> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int maxAttempts;
    double sleepBaseSecs;
    double maxJitterSecs;

    public ExponentialRetry(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        this.sleepBaseSecs = 1.0;
        this.maxJitterSecs = 1.0;
    }

    public ExponentialRetry(int maxAttempts, double sleepBaseSecs, double maxJitterSecs) {
        this.maxAttempts = maxAttempts;
        this.sleepBaseSecs = sleepBaseSecs;
        this.maxJitterSecs = maxJitterSecs;
    }

    public ExponentialRetry(ExponentialRetry other) {
        this.maxAttempts = other.maxAttempts;
        this.sleepBaseSecs = other.sleepBaseSecs;
        this.maxJitterSecs = other.maxJitterSecs;
    }

    public <T> T execute(KustoCheckedFunction<Integer, T, E1, E2> function) throws E1, E2 {
        for (int currentAttempt = 0; currentAttempt < this.maxAttempts; ++currentAttempt) {
            log.info("execute: Attempt {}", (Object)currentAttempt);
            try {
                T result = function.apply(currentAttempt);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception e) {
                log.error("execute: Error is permanent, stopping", (Throwable)e);
                throw e;
            }
            double currentSleepSecs = this.sleepBaseSecs * (double)((float)Math.pow(2.0, currentAttempt));
            double jitterSecs = (double)((float)Math.random()) * this.maxJitterSecs;
            double sleepMs = (currentSleepSecs + jitterSecs) * 1000.0;
            log.info("execute: Attempt {} failed, trying again after sleep of {} seconds", (Object)currentAttempt, (Object)(sleepMs / 1000.0));
            try {
                Thread.sleep((long)sleepMs);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("execute: Interrupted while sleeping", e);
            }
        }
        return null;
    }
}

