/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.IClientCertificate;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.azure.kusto.data.auth.AccessTokenTokenProvider;
import com.microsoft.azure.kusto.data.auth.ApplicationCertificateTokenProvider;
import com.microsoft.azure.kusto.data.auth.ApplicationKeyTokenProvider;
import com.microsoft.azure.kusto.data.auth.CallbackTokenProvider;
import com.microsoft.azure.kusto.data.auth.ConnectionStringBuilder;
import com.microsoft.azure.kusto.data.auth.DeviceAuthTokenProvider;
import com.microsoft.azure.kusto.data.auth.ManagedIdentityTokenProvider;
import com.microsoft.azure.kusto.data.auth.SubjectNameIssuerTokenProvider;
import com.microsoft.azure.kusto.data.auth.TokenProviderBase;
import com.microsoft.azure.kusto.data.auth.UserPromptTokenProvider;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenProviderFactory {
    private TokenProviderFactory() {
    }

    public static TokenProviderBase createTokenProvider(@NotNull ConnectionStringBuilder csb, @Nullable HttpClient httpClient) throws URISyntaxException {
        String clusterUrl = csb.getClusterUrl();
        String authorityId = csb.getAuthorityId();
        if (StringUtils.isNotBlank((CharSequence)csb.getApplicationClientId())) {
            if (StringUtils.isNotBlank((CharSequence)csb.getApplicationKey())) {
                String clientId = csb.getApplicationClientId();
                IClientSecret clientSecret = ClientCredentialFactory.createFromSecret((String)csb.getApplicationKey());
                return new ApplicationKeyTokenProvider(clusterUrl, clientId, clientSecret, authorityId, httpClient);
            }
            if (csb.getX509CertificateChain() != null && !csb.getX509CertificateChain().isEmpty() && csb.getPrivateKey() != null) {
                IClientCertificate clientCertificate = ClientCredentialFactory.createFromCertificateChain((PrivateKey)csb.getPrivateKey(), csb.getX509CertificateChain());
                String applicationClientId = csb.getApplicationClientId();
                return new SubjectNameIssuerTokenProvider(clusterUrl, applicationClientId, clientCertificate, authorityId, httpClient);
            }
            if (csb.getX509Certificate() != null && csb.getPrivateKey() != null) {
                IClientCertificate clientCertificate = ClientCredentialFactory.createFromCertificate((PrivateKey)csb.getPrivateKey(), (X509Certificate)csb.getX509Certificate());
                String applicationClientId = csb.getApplicationClientId();
                return new ApplicationCertificateTokenProvider(clusterUrl, applicationClientId, clientCertificate, authorityId, httpClient);
            }
            throw new IllegalArgumentException("No token provider exists for the provided ConnectionStringBuilder");
        }
        if (StringUtils.isNotBlank((CharSequence)csb.getAccessToken())) {
            String accessToken = csb.getAccessToken();
            return new AccessTokenTokenProvider(clusterUrl, accessToken);
        }
        if (csb.getTokenProvider() != null) {
            Callable<String> tokenProvider = csb.getTokenProvider();
            return new CallbackTokenProvider(clusterUrl, tokenProvider);
        }
        if (csb.isUseDeviceCodeAuth()) {
            return new DeviceAuthTokenProvider(clusterUrl, authorityId, httpClient);
        }
        if (csb.isUseManagedIdentityAuth()) {
            return new ManagedIdentityTokenProvider(clusterUrl, csb.getManagedIdentityClientId(), httpClient);
        }
        if (csb.isUseUserPromptAuth()) {
            if (StringUtils.isNotBlank((CharSequence)csb.getUserUsernameHint())) {
                String usernameHint = csb.getUserUsernameHint();
                return new UserPromptTokenProvider(clusterUrl, usernameHint, authorityId, httpClient);
            }
            return new UserPromptTokenProvider(clusterUrl, null, authorityId, httpClient);
        }
        throw new IllegalArgumentException("No token provider exists for the provided ConnectionStringBuilder");
    }
}

