/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.ingest.resources;

import com.azure.core.http.HttpClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.microsoft.azure.kusto.data.UriUtils;
import com.microsoft.azure.kusto.ingest.resources.ResourceWithSas;
import java.net.URISyntaxException;

public class ContainerWithSas
implements ResourceWithSas<BlobContainerClient> {
    private final String sas;
    private final BlobContainerClient container;

    public ContainerWithSas(String url, HttpClient httpClient) throws URISyntaxException {
        String[] parts = UriUtils.getSasAndEndpointFromResourceURL((String)url);
        String endpoint = parts[0];
        String sas = parts[1];
        this.sas = '?' + sas;
        this.container = new BlobContainerClientBuilder().endpoint(endpoint).sasToken(sas).httpClient(httpClient).buildClient();
    }

    public String getSas() {
        return this.sas;
    }

    public BlobContainerClient getContainer() {
        return this.container;
    }

    @Override
    public String getEndpointWithoutSas() {
        return this.container.getBlobContainerUrl();
    }

    @Override
    public String getAccountName() {
        return this.container.getAccountName();
    }

    @Override
    public BlobContainerClient getResource() {
        return this.container;
    }
}

