// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.ParticipantInfo;
import com.microsoft.graph.models.extensions.MediaStream;
import com.microsoft.graph.models.extensions.RecordingInfo;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Participant.
 */
public class Participant extends Entity implements IJsonBackedObject {


    /**
     * The Info.
     * Information about the participant.
     */
    @SerializedName(value = "info", alternate = {"Info"})
    @Expose
    public ParticipantInfo info;

    /**
     * The Is In Lobby.
     * true if the participant is in lobby.
     */
    @SerializedName(value = "isInLobby", alternate = {"IsInLobby"})
    @Expose
    public Boolean isInLobby;

    /**
     * The Is Muted.
     * true if the participant is muted (client or server muted).
     */
    @SerializedName(value = "isMuted", alternate = {"IsMuted"})
    @Expose
    public Boolean isMuted;

    /**
     * The Media Streams.
     * The list of media streams.
     */
    @SerializedName(value = "mediaStreams", alternate = {"MediaStreams"})
    @Expose
    public java.util.List<MediaStream> mediaStreams;

    /**
     * The Recording Info.
     * Information on whether the participant has recording capability.
     */
    @SerializedName(value = "recordingInfo", alternate = {"RecordingInfo"})
    @Expose
    public RecordingInfo recordingInfo;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
