// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Agreement;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementAcceptanceRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementAcceptanceRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementFileRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementFileRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAgreementFileLocalizationRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AgreementFileLocalizationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement Request Builder.
 */
public class AgreementRequestBuilder extends BaseRequestBuilder implements IAgreementRequestBuilder {

    /**
     * The request builder for the Agreement
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IAgreementRequest instance
     */
    public IAgreementRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IAgreementRequest instance
     */
    public IAgreementRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.extensions.AgreementRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IAgreementAcceptanceCollectionRequestBuilder acceptances() {
        return new AgreementAcceptanceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("acceptances"), getClient(), null);
    }

    public IAgreementAcceptanceRequestBuilder acceptances(final String id) {
        return new AgreementAcceptanceRequestBuilder(getRequestUrlWithAdditionalSegment("acceptances") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for AgreementFile
     *
     * @return the IAgreementFileRequestBuilder instance
     */
    public IAgreementFileRequestBuilder file() {
        return new AgreementFileRequestBuilder(getRequestUrlWithAdditionalSegment("file"), getClient(), null);
    }
    public IAgreementFileLocalizationCollectionRequestBuilder files() {
        return new AgreementFileLocalizationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("files"), getClient(), null);
    }

    public IAgreementFileLocalizationRequestBuilder files(final String id) {
        return new AgreementFileLocalizationRequestBuilder(getRequestUrlWithAdditionalSegment("files") + "/" + id, getClient(), null);
    }
}
