// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IGroupSubscribeByMailRequest;
import com.microsoft.graph.requests.extensions.GroupSubscribeByMailRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group Subscribe By Mail Request Builder.
 */
public class GroupSubscribeByMailRequestBuilder extends BaseActionRequestBuilder implements IGroupSubscribeByMailRequestBuilder {

    /**
     * The request builder for this GroupSubscribeByMail
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public GroupSubscribeByMailRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IGroupSubscribeByMailRequest
     *
     * @param requestOptions the options for the request
     * @return the IGroupSubscribeByMailRequest instance
     */
    public IGroupSubscribeByMailRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IGroupSubscribeByMailRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IGroupSubscribeByMailRequest instance
     */
    public IGroupSubscribeByMailRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        GroupSubscribeByMailRequest request = new GroupSubscribeByMailRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
