// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Agreement;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Agreement Request.
 */
public interface IAgreementRequest extends IHttpRequest {

    /**
     * Gets the Agreement from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Agreement> callback);

    /**
     * Gets the Agreement from the service
     *
     * @return the Agreement from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Agreement get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super Agreement> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Agreement with a source
     *
     * @param sourceAgreement the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Agreement sourceAgreement, final ICallback<? super Agreement> callback);

    /**
     * Patches this Agreement with a source
     *
     * @param sourceAgreement the source object with updates
     * @return the updated Agreement
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Agreement patch(final Agreement sourceAgreement) throws ClientException;

    /**
     * Posts a Agreement with a new object
     *
     * @param newAgreement the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Agreement newAgreement, final ICallback<? super Agreement> callback);

    /**
     * Posts a Agreement with a new object
     *
     * @param newAgreement the new object to create
     * @return the created Agreement
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Agreement post(final Agreement newAgreement) throws ClientException;

    /**
     * Posts a Agreement with a new object
     *
     * @param newAgreement the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Agreement newAgreement, final ICallback<? super Agreement> callback);

    /**
     * Posts a Agreement with a new object
     *
     * @param newAgreement the object to create/update
     * @return the created Agreement
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Agreement put(final Agreement newAgreement) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAgreementRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAgreementRequest expand(final String value);

}

