// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.StsPolicy;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Sts Policy Request.
 */
public interface IStsPolicyRequest extends IHttpRequest {

    /**
     * Gets the StsPolicy from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super StsPolicy> callback);

    /**
     * Gets the StsPolicy from the service
     *
     * @return the StsPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    StsPolicy get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super StsPolicy> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this StsPolicy with a source
     *
     * @param sourceStsPolicy the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final StsPolicy sourceStsPolicy, final ICallback<? super StsPolicy> callback);

    /**
     * Patches this StsPolicy with a source
     *
     * @param sourceStsPolicy the source object with updates
     * @return the updated StsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    StsPolicy patch(final StsPolicy sourceStsPolicy) throws ClientException;

    /**
     * Posts a StsPolicy with a new object
     *
     * @param newStsPolicy the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final StsPolicy newStsPolicy, final ICallback<? super StsPolicy> callback);

    /**
     * Posts a StsPolicy with a new object
     *
     * @param newStsPolicy the new object to create
     * @return the created StsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    StsPolicy post(final StsPolicy newStsPolicy) throws ClientException;

    /**
     * Posts a StsPolicy with a new object
     *
     * @param newStsPolicy the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final StsPolicy newStsPolicy, final ICallback<? super StsPolicy> callback);

    /**
     * Posts a StsPolicy with a new object
     *
     * @param newStsPolicy the object to create/update
     * @return the created StsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    StsPolicy put(final StsPolicy newStsPolicy) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IStsPolicyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IStsPolicyRequest expand(final String value);

}

