// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.SubscribeToToneOperation;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Subscribe To Tone Operation Request.
 */
public class SubscribeToToneOperationRequest extends BaseRequest implements ISubscribeToToneOperationRequest {
	
    /**
     * The request for the SubscribeToToneOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SubscribeToToneOperationRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SubscribeToToneOperation.class);
    }

    /**
     * Gets the SubscribeToToneOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super SubscribeToToneOperation> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the SubscribeToToneOperation from the service
     *
     * @return the SubscribeToToneOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SubscribeToToneOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super SubscribeToToneOperation> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SubscribeToToneOperation with a source
     *
     * @param sourceSubscribeToToneOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final SubscribeToToneOperation sourceSubscribeToToneOperation, final ICallback<? super SubscribeToToneOperation> callback) {
        send(HttpMethod.PATCH, callback, sourceSubscribeToToneOperation);
    }

    /**
     * Patches this SubscribeToToneOperation with a source
     *
     * @param sourceSubscribeToToneOperation the source object with updates
     * @return the updated SubscribeToToneOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SubscribeToToneOperation patch(final SubscribeToToneOperation sourceSubscribeToToneOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceSubscribeToToneOperation);
    }

    /**
     * Creates a SubscribeToToneOperation with a new object
     *
     * @param newSubscribeToToneOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final SubscribeToToneOperation newSubscribeToToneOperation, final ICallback<? super SubscribeToToneOperation> callback) {
        send(HttpMethod.POST, callback, newSubscribeToToneOperation);
    }

    /**
     * Creates a SubscribeToToneOperation with a new object
     *
     * @param newSubscribeToToneOperation the new object to create
     * @return the created SubscribeToToneOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SubscribeToToneOperation post(final SubscribeToToneOperation newSubscribeToToneOperation) throws ClientException {
        return send(HttpMethod.POST, newSubscribeToToneOperation);
    }

    /**
     * Creates a SubscribeToToneOperation with a new object
     *
     * @param newSubscribeToToneOperation the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final SubscribeToToneOperation newSubscribeToToneOperation, final ICallback<? super SubscribeToToneOperation> callback) {
        send(HttpMethod.PUT, callback, newSubscribeToToneOperation);
    }

    /**
     * Creates a SubscribeToToneOperation with a new object
     *
     * @param newSubscribeToToneOperation the object to create/update
     * @return the created SubscribeToToneOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SubscribeToToneOperation put(final SubscribeToToneOperation newSubscribeToToneOperation) throws ClientException {
        return send(HttpMethod.PUT, newSubscribeToToneOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ISubscribeToToneOperationRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (SubscribeToToneOperationRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ISubscribeToToneOperationRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (SubscribeToToneOperationRequest)this;
     }

}

